;Scripts for Groupwise 7.0
;If Groupwise 5.2 is being used, then this script switches to gw52.jss.
;If Groupwise 6.5 or less is being used, then thise script switches to gw65.
;
;Copyright (c) 2004 Freedom Scientific, Inc.
;
;Permission is hereby granted, free of charge, to any person obtaining a copy
;of this software and associated documentation files (the Software), to deal
;in the Software without restriction, including without limitation the rights
;to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
;copies of the Software, and to permit persons to whom the Software is
;furnished to do so, subject to the following
;conditions:
;
;The above copyright notice and this permission notice shall be included in
;all copies or substantial portions of the Software.
;
;THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
;DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
;OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
;USE OR OTHER DEALINGS IN THE SOFTWARE.

Include "Hjglobal.jsh"
Include "hjconst.jsh"
Include "HjHelp.jsh"
Include "Grpwise.jsm"
Include "Grpwise.jsh"
Include "common.jsm"
Include "WinStyles.jsh"
Include "tutorialhelp.jsm"

globals
	int	GWVersion,
	int g_bSayNonHighlightedText,
	int g_bSuppressHighlightedText,
	int g_bLastSayHighlightedTextWasCalWnd,
	int g_iLastFocusedItem,
	handle g_hwndLastSysTab,
	string g_sLastTabName,
	string g_strLastDuration,
	string g_strLastDate,
	string g_strLastTime,
	string g_strLastFreeBusy,
	string g_sLastReadCalendarObjectName,
	string g_sFirstItemList,
	string g_strLastSearchCriteria,
	int    g_bAllDayEventflag,
	handle g_hwndPrevChooseDlg,
	handle g_hwndLastSayFocusWindow,
	handle g_hwndLastFocusedDay,
	handle g_hwndLastClickedDay,
	int bSayFocusWindowSameAsLast,
	handle g_hwndNull	;By default, this variable is initialized to NULL.
						;We use it in 'if' statements and to set other 
						;'handles' to NULL



int Function GetGWVersion ()
; This function builds an integer value from the program version information.
; This value is used with in the scripts to determine which version of groupwise is being executed.
var
	int iValue,
	string sVersion

let sVersion = GetVersionInfoString (GetAppFilePath (), cmsg283_L)
let iValue = stringToInt (StringSegment (sVersion, SC_PROGRAMVERSION, 1))
let iValue = stringToInt (StringSegment (sVersion, SC_PROGRAMVERSION, 2)) + iValue * 10 
let iValue = stringToInt (StringSegment (sVersion, SC_PROGRAMVERSION, 3)) + iValue * 10
return iValue;
endFunction



string function GetAppVersion ()
var
	string sProduct,
	string sVersion,
	string sMessage
let sProduct = GetVersionInfoString (GetAppFilePath (), cmsg282_L)
let sVersion = GetVersionInfoString (GetAppFilePath (), cmsg283_L)
let sMessage = FormatString (cmsg239_L, sProduct, sVersion)
return sMessage
EndFunction



Function AutoStartEvent ()
;;;TrcEnter("AutoStartEvent-GroupWise")
var
	string sMessageLong,
	string sMessageShort
;
let GWVersion = GetGWVersion()

;;;OutputDebugString(FormatString("GroupWise Version=%1",IntToString(GWVersion)))
;;;OutputDebugString(FormatString("JAWS Version=%1",IntToString(GetJFWVersion())))
 
; Versions 5.0.0 thru 5.2.x should use gw52 script
; Versions 5.5.x thru 6.x.x use this script.
; Version 6.5.0 thru 6.5.2 don't work well with this script.
; Version 6.5.3 works much better (this script looks for 6.5.3)
;

if (GWVersion >= 500) &&
   (GWVersion <= 529) then
	SwitchToScriptFile ("gw52", "GroupWise")
	;;;TrcExit("AutoStartEvent-GW52")
	return
EndIf

if (GWVersion > 529) &&
	(GWVersion < 700) then
	SwitchToScriptFile ("gw65", "GroupWise")
	;;;TrcExit("AutoStartEvent-GW65")
	return
EndIf

let g_hwndLastSysTab = g_hwndNull

let GlobalMousePixel = 3
let iToggleColumnLabelReading = iniReadInteger(Section_applicationVerbositySettings,hKey_ColumnLabels, FALSE,jsiFileName)
let iTogglePageReading = iniReadInteger(Section_applicationVerbositySettings,hKey_ReadMessage, FALSE,jsiFileName)
let iToggleQuickViewReading = iniReadInteger(Section_applicationVerbositySettings,hKey_QuickView, TRUE,jsiFileName)
FrameClearValues ()
VirtualStart ()
if (! GWFirstTime) then
	let GWFirstTime = TRUE
	let sMessageShort = FormatString (msgAutoStart0_S, GetAppVersion ())
	SayFormattedMessage (ot_app_start, sMessageLong, sMessageShort)
EndIf

;;AddHook (HK_SCRIPT, "GWScriptHook")		;;! Debug only

;;;TrcExit("AutoStartEvent")
EndFunction



Void Function AutoFinishEvent ()
;Put code here that will be triggered when the application is finished.
;It also gets performed when the application loses focus, as with ALT+TAB.
;SayFormattedMessage (ot_debug, cmsgDebugAppFinish1_L)

let g_hwndLastSayFocusWindow = g_hwndNull

;;RemoveHook(HK_SCRIPT,"GWScriptHook")		;;! Debug only

EndFunction


string function GetCustomTutorMessage()
var
	handle	hwndControl,
	string	sCustomTutorMessage

	let hwndControl = GlobalFocusWindow
	let sCustomTutorMessage = cscNull

	if ((IDC_CONTACT_PHOTO == GetControlId(hwndControl)) && 
	   (WCN_BUTTON == GetWindowClass(hwndControl)) &&
	   (WCN_DIALOG == GetWindowClass(GetParent(hwndControl)))) then
      		let sCustomTutorMessage = msgContactPhotoTutor
	endif

	If ((GetWindowClass(GetParent(hwndControl)) == WCN_PopupButton) && (GetControlId(GetParent(hwndControl)) == CID_ENUM_ACCEPT_LEVEL)) then
			If(GetWindowClass(GetFocus()) == wcn_Button) Then
				let sCustomTutorMessage = msgAvailabilityStatusInButton
			Else
				let sCustomTutorMessage = msgAvailabilityStatusInMenu
			EndIf
	EndIf

	return sCustomTutorMessage
endfunction


; This function was obtained from default.jss.  
; It had a problem (checking the wrong bit) which is corrected here.
;
void function SayLVItemCheckStatus(handle hWnd)
;;;TrcEnter("SayLVItemCheckStatus")
var
	int iState
let iState = lvGetItemState (hwnd,lvGetFocusItem (hwnd))
;if iState & lv_ItemChecked then
if (iState & 0x1000) then
	Say(smmGetStartMarkupForControlState(wt_ListView,CTRL_CHECKED),ot_item_state,true)
else
	Say(smmGetStartMarkupForControlState(wt_ListView,CTRL_UNCHECKED),ot_item_state,true)
EndIf
EndFunction

; A variation of the above function which returns the "checked" or
; "not checked" string.
;
string function GetLVItemCheckStatus(handle hWnd)
;;;TrcEnter("SayLVItemCheckStatus")
var
	int iState
let iState = lvGetItemState (hwnd,lvGetFocusItem (hwnd))
;if iState & lv_ItemChecked then
if (iState & 0x1000) then
	return smmGetStartMarkupForControlState(wt_ListView,CTRL_CHECKED)
else
	return smmGetStartMarkupForControlState(wt_ListView,CTRL_UNCHECKED)
EndIf
EndFunction


Void Function SayLine ()
;;;TrcEnter("SayLine")
Var
	String TheRealWindow, ;stores the real window name.
	Handle hwnd,
	Int TheTypecode ;stores the window type code.

;Assigns the window type code to variable.
let hwnd = GetFocus()
let TheTypeCode = GetWindowTypeCode (globalFocusWindow)

;Assigns the window real name to variable.
let TheRealWindow = GetWindowName (GetRealWindow (GlobalFocusWindow))
;;;OutputDebugString(FormatString("TheRealWindow : %1", TheRealWindow)) 
;;;OutputDebugString(FormatString("TheTypeCode : %1", IntToString(TheTypeCode))) 

;This will say the column header before the info that is in the column
;The lvFunctions are only available with JAWS 5.10 and greater.
if (GetJFWVersion() >= 510000) && (iToggleColumnLabelReading) then
	If  (TheTypeCode == WT_LISTVIEW && GetControlId(hwnd) == 1 && 	GetMenuMode () == INACTIVE) then
		var
			int i,
			int selected,
			int count,
			string info,
			string header

		let count = lvGetNumOfColumns (hwnd)
		let selected = lvGetFocusItem (hwnd)
		let i = 3
		if (lvGetItemText (hwnd,selected,i ) == lvGetItemText (hwnd,selected,i+1 )) then
			;this is a folder
			return
		endif

		while(i < count + 4)
			let header = lvGetColumnHeader (hwnd,i )
			let info =  lvGetItemText (hwnd,selected,i ) 
			if (header && info) then
				saystring(header)
				sayString(info)
			endif
			let i = i + 1
		endwhile
		SayMessage (OT_POSITION, PositionInGroup ())
		; Because we didn't call 'sayline' the internal JAWS stuff will call
		; SayHighlightedText which repeats a portion of what we spoke above.
		; We will suppress the next "SayHighlightedText" event.
		;
		let g_bSuppressHighlightedText = 1;
		return
	endif
endif

; Note: The following was used to 'read' the "checked" or "not checked"
; state for entries in the category list.  It is no longer used because
; we now append the text "On" or "Off" to the category name.  When
; JAWS 'reads' the current item it also reads the "on"/"off" state.
; (An example of this can be found in the "Folder Options" dialog, 
; "View" tab, "Advanced settings:" list.)
;
;If  (TheTypeCode == WT_LISTVIEW && GetControlId(hwnd) == CID_CATEGORY_LV) then
;	SayLVItemCheckStatus(hwnd)
;	SayLine()
;	return;
;endif

; Calendar Multi-User List Dialog
If (GetControlId(hwnd) == CID_MultiUserListCheck) then
SayFormattedMessage(OT_help,MSG_LISTCHECK)
EndIf

;If the window with focus is a list box in the address dialogue,
;Then only read out the highlighted text.
;this function has been modified to fix a problem that JAWS has with detecting the address list box.
;
If (TheTypeCode == WT_listBox) &&
 (TheRealWindow == wn_AddressBook) then
	SayWindow (GetFocus(), READ_HIGHLIGHTED )
	Return
endIf

;;;OutputDebugString(FormatString("AppTitle : %1", GetAppTitle ())) 
;;;OutputDebugString(FormatString("Windowclass : %1", GetWindowclass (GetFocus ()))) 
;Announce the New date when focus is on the Calendar in the Day Calendar view.
If (GetAppTitle ()== wn_Daywindow || GetAppTitle () == WN_MainGWCalendarWindow) && 
   (GetWindowclass (GetFocus ()) == WCN_Calendar || GetWindowclass (GetFocus ()) == WCN_CalendarPane) Then
	Return
EndIf

;Handle date picker controls
if (HandleDatePicker (GlobalFocusWindow)) then
	return
endif

; check to see if the window is one of the menu format buttons in the Date Time Options dlg - format tab
if (TheTypeCode == WT_BUTTON) then
	var	handle	hParent,
			int			nId

	let hParent	= GetParent (hwnd)
	let nId			= GetControlId (hParent)

	if (nId == CID_DateFormat_Date) then
		SayFormatButton (hParent, CID_DateFormat_Date_Format)
		return
	elif (nId == CID_DateFormat_MainWnd) then
		SayFormatButton (hParent, CID_DateFormat_MainWnd_Format)
		return
	elif (nId == CID_DateFormat_Properties) then
		SayFormatButton (hParent, CID_DateFormat_Properties_Format)
		return
	elif (nId == CID_DateFormat_FileInfo) then
		SayFormatButton (hParent, CID_DateFormat_FileInfo_Format)
		return
	endif
endif

sayLine ()
;;;TrcExit("SayLine")
EndFunction

void Function SayFormatButton (handle hParent, int nId)
	var	handle hTemp

	let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), nId)

	SayString (GetWindowText (hParent, READ_EVERYTHING))
	SayString (GetWindowName (hTemp))
EndFunction


String Function GetDayViewHeader ()
Var
	String Buffer, ;Stores a string value.
	Handle Hwnd, ;Stores the window handle.
	Int Loop ;Stores the loop counter
;;;TrcEnter("GetDayViewHeader")
let HWnd = GetParent (GlobalFocusWindow) ;assigns the parent window handle to variable.
let HWnd = GetFirstWindow (HWnd) ;assigns the first window handle of the same logical level to variable.
;The while statement moves through the window handles on the same logical level to see if
;the first child window handle equals the window handle with focus.
;If not, then the while loop increases the loop counter by one and
;gets the next window handle on the same logical level.
;the purpose of the loop is to determine the position of the parent window of the window with focus.
;Once the logical position is worked out, then the correct header information can be given.
While (GetFirstChild (Hwnd) != GlobalFocusWindow)
	let Loop = loop + 1 ;adds 1 to the loop counter.
	let Hwnd = GetNextWindow (HWnd) ;gets the next window handle on the same logical level
endWhile
;Tests to see the logical position of the parent window.
;1 equals the Appointment panel.
;2 equals the Notes panel
;3 = The Tasks panel.
If (Loop == AppointmentPanel) Then
	let Buffer = MSG_Prompt7_L ; "Appointments: "
ElIf (Loop == NotesPanel) Then
	let Buffer = MSG_Prompt8_L ;"Notes: "
ElIf (Loop == TasksPanel) Then
	let Buffer = MSG_Prompt9_L ;"Tasks: "
EndIf
;;;TrcExit("GetDayViewHeader")
Return Buffer
EndFunction



string Function GetCalendarViewDate ()
;;;TrcEnter("GetCalendarViewDate")
var
	string sWindowText

; Extracts the date of the Calendar Day Window.
let sWindowText = GetWindowTextex (GetAppMainWindow (GlobalFocusWindow), READ_EVERYTHING, false)
;;;OutputDebugString(FormatString("sWindowText : %1", sWindowText)) 
let sWindowText = stringChopRight (stringChopLeft (sWindowText, 83), 6)
;;;OutputDebugString(FormatString("sWindowText : %1", sWindowText)) 
;;;TrcExit("GetCalendarViewDate")
Return sWindowText
EndFunction



Int Function GetMessageViewType (handle hWnd)
var
	int iValue

let hWnd = GetFirstChild (GetAppMainWindow (hWnd))
While hWnd
	If (GetWindowClass (hWnd) == WCN_EntryField) Then
		let iValue = iValue + 1
	EndIf
	let hWnd = GetNextWindow (hWnd)
EndWhile
Return iValue
EndFunction



;;x;int function GetAddressFieldPos ()
;;x;; this function returns the position of the address field (To, CC, BC or From)
;;x;; of the current message view.
;;x;var
;;x;	handle hWnd,
;;x;	int iPos
;;x;
;;x;let hWnd = GetFirstWindow (GetParent (GetFocus ()))
;;x;let ipos = 1
;;x;while (hWnd != GetParent (GetFocus ()))
;;x;	if (GetWindowClass (hWnd) == WCN_EntryField) Then
;;x;		let iPos = iPos + 1
;;x;	endIf
;;x;	let hwnd = getNextWindow (hWnd)
;;x;endWhile
;;x;return iPos
;;x;EndFunction



;;x;void Function SaySenderFieldPrompt ()
;;x;;;;TrcEnter("SaySenderFieldPrompt")
;;x;Var
;;x;	int iPos
;;x;
;;x;let iPos = GetAddressFieldPos ()
;;x;if (iPos == To_Field) Then
;;x;	SayFormattedMessage (OT_CONTROL_NAME, MSG_TO_FIELD)
;;x;ElIf (iPos == CC_Field) Then
;;x;	SayFormattedMessage (OT_CONTROL_NAME, MSG_CC_FIELD)
;;x;elif (iPos == BC_Field) Then
;;x;	SayFormattedMessage (OT_CONTROL_NAME, MSG_BC_FIELD)
;;x;elif (iPos == From_Field) Then
;;x;	;SayString ("From: ")
;;x;EndIf
;;x;EndFunction



Void Function SayNonHighlightedText (handle hwnd, string buffer)
;;;TrcEnter("SayNonHighlightedText")
; NonHighlightedText  Function for speaking all newly written nonhighlighted
; text.
var
	string TheClass

	;;;OutputDebugString(FormatString("buffer : %1", buffer)) 
	;;;OutputDebugString(FormatString("g_bSayNonHighlightedText : %1", IntToString(g_bSayNonHighlightedText))) 

;;;var
 	;;;int iControlId,
 	;;;int iParentId,
 	;;;handle  hwndControl,
 	;;;handle  hwndParent,
 	;;;string  sControlClassName,
 	;;;string  sParentClassName

 	;;;let hwndControl = HWnd
 	;;;let hwndParent = GetParent(hwndControl)
 	;;;let iControlId = GetControlId(hwndControl)
 	;;;let iParentId = GetControlId(hwndParent)
 	;;;let sControlClassName = GetWindowClass(hwndControl)
 	;;;let sParentClassName = GetWindowClass(hwndParent)

 	;;;OutputDebugString(FormatString("--ControlId=%1",IntToString(iControlId)))
 	;;;OutputDebugString(FormatString("--ClassName=%1", sControlClassName ))
 	;;;OutputDebugString(FormatString("--Type=%1",IntToString(GetWindowTypeCode(hwndControl))))
 	;;;OutputDebugString(FormatString("--Subtype=%1",IntToString(GetWindowSubTypeCode(hwndControl))))
 	;;;OutputDebugString(FormatString("--ParentId=%1",IntToString(iParentId)))
 	;;;OutputDebugString(FormatString("--ParentClass=%1",sParentClassName))
 	;;;OutputDebugString(FormatString("--ParentType=%1",IntToString(GetWindowTypeCode(hwndParent))))
 	;;;OutputDebugString(FormatString("--ParentSubtype=%1",IntToString(GetWindowSubTypeCode(hwndParent))))
 	;;;OutputDebugString(FormatString("--RealClassName=%1",GetWindowClass(GetRealWindow(hwndControl))))

if (g_bSayNonHighlightedText) then
	;;;TrcEnter("SayNonHighlightedText1")
	SayFormattedMessage(OT_NO_DISABLE, buffer)
	;;;TrcExit("SayNonHighlightedText1")
endif

let TheClass = GetWindowClass(hwnd)
	;;;OutputDebugString(FormatString("TheClass : %1", TheClass)) 
if ((GetScreenEcho() > 1) || (TheClass == wn1 )) then
	;;;TrcEnter("SayNonHighlightedText2")
	SayFormattedMessage (OT_NO_DISABLE, buffer)
	;;;TrcExit("SayNonHighlightedText2")
EndIf
;Speaks the quick viewer message window, when selected from the view menu.
If (TheClass == WCN_QuickViewer) && iToggleQuickViewReading Then
	If !QuickViewHasFocus Then
	;;;TrcEnter("SayNonHighlightedText3")
		SayFormattedMessage (OT_NO_DISABLE, buffer)
	;;;TrcExit("SayNonHighlightedText3")
	EndIf
endIf
If (GetWindowTypeCode(GetParent(GetFocus())) == WT_LISTVIEW) && (GetControlId(GetFocus()) == CID_POPUP_EDIT) Then
	SayItemInContactPropertiesList(GetFocus())
EndIf

If (TheClass == WCN_GWPopDetail) Then
    If (GetWindowClass(GetRealWindow(hwnd)) == WCN_GWPopDetail) Then
        ;;;TrcEnter("SayNonHighlightedText4")
        SayFormattedMessage (OT_NO_DISABLE, buffer)
        ;;;TrcExit("SayNonHighlightedText4")
    EndIf
EndIf

; Speak the content of the current day of the month in the calendar
; The value for g_hwndLastFocusedDay could be previously set by MouseButtonEvent (using mouse) or SayFocusedWindow(using neither keyboard or mouse)
if (GetWindowName(hwnd) == "GWDay" && HasFocusRect(hwnd)) then
	if (hwnd != g_hwndLastFocusedDay && g_hwndLastFocusedDay != g_hwndNull) then
		SayFocusRect(hwnd)
		if (GetWindowClass(g_hwndLastFocusedDay) == "OWL_Window" || (GetWindowClass(g_hwndLastFocusedDay) == "AfxWnd80ud" || GetWindowClass(g_hwndLastFocusedDay) == "AfxFrameOrView80ud")) then
			SayFormattedMessage(OT_NO_DISABLE,  msgOpenDaySchedule)
		endif
	endif
	let g_hwndLastFocusedDay = hwnd
endIf

; GWHdrCtl's have window class "GWHdrCtl" or have a parent that is "GWHdrCtl"
if (GetWindowClass(hwnd) == WCN_GWHDRCTL) || (GetWindowClass(GetParent(hwnd)) == WCN_GWHDRCTL) then
	if (GetControlId(hwnd) == CID_HDR_FILTER_EDITBOX_CTLID) then
		var
			string strCurrentSearchCriteria
		let strCurrentSearchCriteria = GetTextInWindow(hwnd)
		if (StringCompare(strCurrentSearchCriteria,g_strLastSearchCriteria) != 0) then
			SayFormattedMessage(OT_NO_DISABLE, msgClearFilter)
		endif
		let g_strLastSearchCriteria = strCurrentSearchCriteria
	endif
endif

;;;TrcExit("SayNonHighlightedText")
EndFunction

Function SayFocusedObject()
	var
		handle	hwndControl

	let hwndControl = GlobalFocusWindow

	;Speak the commands about how move through the month in the calendar
	;This code is called after open the Day Schedule window (double click on a day of the month)
	if (GetWindowName(hwndControl) == "GWMonth") then
		SayFormattedMessage(OT_NO_DISABLE, GetTextInWindow(FindWindow(GetParent(GetParent(GetParent(GetParent((hwndControl))))),"GWDatePicker")))
		SayFormattedMessage(OT_NO_DISABLE, msgMoveThroughCalendar)
		SayFormattedMessage(OT_NO_DISABLE, msgOpenDaySchedule)
		let g_hwndLastFocusedDay = hwndControl
		let g_hwndLastClickedDay = hwndControl
		return
	endif

	SayFocusedObject()
EndFunction

Void Function MouseButtonEvent (int eventID, int x, int y)
	var
			handle hwnd

	if eventID == WM_LBUTTONUP then
		let hwnd = GetWindowAtPoint(x,y)
		;Speak the commands about how move through the month in the calendar only if the last selected window is different from any cell (day) located in the month
		if ((((GetWindowClass(hwnd) == "OWL_Window" && GetWindowClass(GetParent(hwnd)) == "GWCalendarContentPane") || GetWindowClass(hwnd) == "AfxWnd80ud" || GetWindowClass(hwnd) == "AfxFrameOrView80ud") &&
		     (GetWindowClass(g_hwndLastFocusedDay) != "AfxWnd80ud" && GetWindowClass(g_hwndLastFocusedDay) !="AfxFrameOrView80ud")) ||
		     (GetWindowClass(hwnd) == "AfxWnd80ud" && g_hwndLastClickedDay == g_hwndNull))then
			SayFormattedMessage(OT_NO_DISABLE, GetTextInWindow(FindWindow(GetParent(GetRealWindow(hwnd)),"GWDatePicker")))
			SayFormattedMessage(OT_NO_DISABLE, msgMoveThroughCalendar)
			SayFormattedMessage(OT_NO_DISABLE, msgOpenDaySchedule)
			let g_hwndLastClickedDay = hwnd
		endif
		let g_hwndLastFocusedDay = hwnd
	endIf

	MouseButtonEvent(eventID,x,y)
EndFunction


String Function GetBusyAppointmentDateTime (int Flag)
;;;TrcEnter("GetBusyAppointmentDateTime")
Var
	String StatusLine, ;Stores the status line
	String buffer, ;stores a string of text
	Int STRTimeLen ;stores the length of the time

Delay (2)

;Assigns the status line from the Choose Appointment Time dialogue to the variable
let StatusLine = GetWindowText (FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_BusyStatusLine), Read_Everything)

;If the flag is true, get the new date.
;Otherwise get the time from the status line.
If Flag Then
	;StatusSrch1  = "Start Time:"
	let Buffer = StringLeft (StatusLine, StringContains (StatusLine, StatusSrch1) - 1)
else
	;StatusSrch1  = "Start Time:"
	;StatusSrch2 = "Duration"
	;Calculates the length of the time portion of the status line.	let STRTimeLen = StringContains (StatusLine, StatusSrch2) - StringContains (StatusLine, StatusSrch1)
	;Extracts the time portion of the status line.
	let Buffer = SubString (StatusLine, StringContains (StatusLine, StatusSrch1), STRTimeLen)
EndIf
;;;TrcExit("GetBusyAppointmentDateTime")
Return Buffer
EndFunction



Void Function SayHighlightedText (handle HWnd, string Buffer)
;;;TrcEnter("SayHighlightedText")
;;;OutputDebugString(Buffer)
Var
	String TheParentClass ;stores the parent class

var
	int iControlId,
	int iParentId,
	handle	hwndControl,
	handle hwndParent,
	string	sControlClassName,
	string	sParentClassName

	let hwndControl = HWnd
	let hwndParent = GetParent(hwndControl)
	let iControlId = GetControlId(hwndControl)
	let iParentId = GetControlId(hwndParent)
	let sControlClassName = GetWindowClass(hwndControl)
	let sParentClassName = GetWindowClass(hwndParent)

	;;;OutputDebugString(FormatString("--ControlId=%1",IntToString(iControlId)))
	;;;OutputDebugString(FormatString("--ClassName=%1", sControlClassName ))
	;;;OutputDebugString(FormatString("--Type=%1",IntToString(GetWindowTypeCode(hwndControl))))
	;;;OutputDebugString(FormatString("--Subtype=%1",IntToString(GetWindowSubTypeCode(hwndControl))))
	;;;OutputDebugString(FormatString("--ParentId=%1",IntToString(iParentId)))
	;;;OutputDebugString(FormatString("--ParentClass=%1",sParentClassName))
	;;;OutputDebugString(FormatString("--ParentType=%1",IntToString(GetWindowTypeCode(hwndParent))))
	;;;OutputDebugString(FormatString("--ParentSubtype=%1",IntToString(GetWindowSubTypeCode(hwndParent))))
	;;;OutputDebugString(FormatString("--RealClassName=%1",GetWindowClass(GetRealWindow(hwndControl))))
;	;;;OutputDebugString(FormatString("----GetItemCount=%1",IntToString(GetItemCount(hwndControl))))

if (g_bSuppressHighlightedText) then
	let g_bSuppressHighlightedText = 0
	;;;TrcExit("SayHighlightedText1")
	return
endif

; With the calendar view displayed (with small months on the left) when you cursor left/right between
; the different days the date will be 'read' twice via SayHighlightedText: (1) the heading at the top of each 
; column is read, and (2) the day-of-the-month in the small calendar.  We want to suppress the 'reading'
; of the small month.
; If the previous call to SayHighlightedText was for the CalWnd window (the column heading) AND
; this call to SayHighlighted text is for the GWSmallMonth window (the day of the month) THEN
; just return and suppress saying the Highlighted text for the small month.
;
if (g_bLastSayHighlightedTextWasCalWnd) then
	let g_bLastSayHighlightedTextWasCalWnd= FALSE;
	if (GetWindowClass(hwnd) == "GWSmallMonth") then
		;;;TrcExit("SayHighlightedText2")
		return;
	endif
endif
let g_bLastSayHighlightedTextWasCalWnd = GetWindowClass( hwnd ) == "CalWnd"

let TheParentClass = GetWindowClass (GetParent (HWnd)) ;assigns the parent class to variable
; HighlightedText Function for speaking all newly written highlighted
; text.
if (GetWindowSubTypeCode (hwnd) == WT_TREEVIEW) Then
		SayTreeViewLevel ()
		;;;TrcExit("SayHighlightedText3")
		Return
EndIf

;The following if test prevents the highlighted text from being spoken twice in certain list views.
;Such as the Mail box item list and the Find result window.
If (TheParentClass	== WCN_MainWindow) ||
(TheParentClass == WCN_FindResultWindow) ||
(GetControlId (hWnd) == 1034)  Then
	If (GetWindowTypecode (HWnd) == WT_ListView) Then
		;;;TrcExit("SayHighlightedText4")
		return
	EndIf ;(GetWindowTypecode (HWnd) == WT_ListView)
EndIf ;(TheParentClass  == WCN_MainWindow) || (TheParentClass == WCN_FindResultWindow)
;the following if test prevents highlighted text eing spoken,
;when the calendar control of the Day Calendar view is highlighted.
If  (GetAppTitle ()== wn_DayWindow || GetAppTitle () == WN_MainGWCalendarWindow) Then 
	If (GetWindowclass (HWnd) == WCN_StaticMonth) Then
		;;;TrcExit("SayHighlightedText5")
	Return
	ElIf (GetWindowclass (HWnd) == WCN_CalendarPane) Then
	    var string sObjectName
	    let sObjectName = GetObjectName()
	    If ((sObjectName == "Task")) Then
	        SayFormattedMessage(OT_NO_DISABLE, "Task ")
	        let g_sLastReadCalendarObjectName = "Task"
	    EndIf
	    If ((sObjectName == "Appointment") && (g_sLastReadCalendarObjectName != "Appointment")) Then
	        SayFormattedMessage(OT_NO_DISABLE, "Appointments ")
	        let g_sLastReadCalendarObjectName = "Appointment"
	    EndIf
	    If ((sObjectName == "Reminder Note")) Then
	        SayFormattedMessage(OT_NO_DISABLE, "Reminder Note ")
	        let g_sLastReadCalendarObjectName = "Reminder Note"
	    EndIf
	    If ((sObjectName == "All Day Event")) Then
	        If ((Buffer != "")) Then
                SayFormattedMessage(OT_NO_DISABLE, "All Day Event ")
	            let g_sLastReadCalendarObjectName = "All Day Event"
	            let g_bAllDayEventflag = TRUE
	        EndIf
	    EndIf
	    SayFormattedMessage(OT_NO_DISABLE, Buffer)
		;;;TrcExit("SayHighlightedText6")
		Return
	EndIf
EndIf
If (GetWindowName (GetRealWindow (HWnd)) == wn_WritingToolsDialogue) &&
(GetCurrentControlid () == CID_SpellChecker) Then
	;;;TrcExit("SayHighlightedText7")
	Return
endIf
if (GetScreenEcho() > 0) then
    If ( g_bAllDayEventflag == TRUE) Then
        let g_bAllDayEventflag = FALSE
        ;;;TrcExit("SayHighlightedText8")
        Return
    EndIf
	SayFormattedMessage (OT_NO_DISABLE, buffer)
EndIf
;;;TrcExit("SayHighlightedText")
EndFunction



string Function getGroupBoxName ()
var
	Handle hWnd,
	int iControlId,
	string sWindowText,
	String sWindowName

let sWindowName = GetWindowName (GetRealwindow (GlobalFocuswindow)) ;assigns the window name to variable
let iControlId = getControlId (GlobalFocusWindow)
/*If ((sWindowName == wn_Environment) ||
(sWindowName == wn_DateTimeOptions) ||
(sWindowName == wn_SendOption)) &&*/
If (GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) Then
	let hWnd = GetParent (GlobalFocusWindow)
	While (GetWindowSubtypeCode (hWnd) != WT_GROUPBOX) && HWnd
		let hWnd = getPriorWindow (hWnd)
	EndWhile
	let sWindowText = GetWindowTextEx (hWnd, read_Everything, false)
else
	let sWindowText = GetGroupBoxName ()
EndIf
return sWindowText
EndFunction



;;x;int function CheckMessageType (string sWindowName, handle hWnd, string sRealWindowClass )
;;x;;;;TrcEnter("CheckMessageType")
;;x;; checks to see if the focus is in an Appointment, Task, Phone or Mail message window.
;;x;; Also checks to see if the message is a Posted or Group message view.
;;x;; Posted messages are messages to yourself.
;;x;; Group Messages are messages that are sent to another individual.
;;x;var
;;x;	int iValue,
;;x;	int iFieldPos,
;;x;string sClass
;;x;
;;x;let iValue = FALSE
;;x;let sClass = GetWindowClass (GlobalFocusWindow)
;;x;if (sClass == WCN_RichEdit) Then
;;x;	; Only checks the window Hierarchy position when the class is a Rich Edit.
;;x;	let iFieldPos = GetWindowHierarchyX (GlobalFocusWindow)
;;x;else
;;x;	return FALSE;
;;x;EndIf
;;x;If ((sWindowName == WN_PostedAppointmentWindow) ||
;;x;(sWindowName == WN_PostedTaskWindow)) && (iFieldPos  == 11) Then
;;x;	SayFormattedMessageBoxWindow ()
;;x;	let iValue = TRUE
;;x;ElIf (sWindowName == WN_PostedNoteWindow) && (iFieldPos  == 6) Then
;;x;	SayFormattedMessageBoxWindow ()
;;x;	let iValue = TRUE
;;x;ElIf (sWindowName == WN_PostedPhoneWindow) && (iFieldPos == 12) Then
;;x;	SayFormattedMessageBoxWindow ()
;;x;	let iValue = TRUE
;;x;ElIf (sWindowName == WN_PostedMailWindow) && (iFieldPos == 2) Then
;;x;	SayFormattedMessageBoxWindow ()
;;x;	let iValue = TRUE
;;x;ElIf (sRealWindowClass == WCN_AppointmentWindow) || (sRealWindowClass == WCN_TaskWindow) Then
;;x;	If (iFieldPos	 == 12) Then
;;x;		SayFormattedMessageBoxWindow ()
;;x;		let iValue = True
;;x;	endif
;;x;ElIf (sRealWindowClass == WCN_NoteWindow) Then
;;x;	If (iFieldPos	 == 7) Then
;;x;		SayFormattedMessageBoxWindow ()
;;x;		let iValue = True
;;x;	endif
;;x;elIf (sRealWindowClass == WCN_PhoneWindow) Then
;;x;	If (FindWindow (GetForegroundWindow (), WCN_PopupButton, CSCNull)) &&
;;x;	(iFieldPos   == 13) Then
;;x;		SayFormattedMessageBoxWindow ()
;;x;		let iValue = True
;;x;	ElIf (iFieldPos   == 12) Then
;;x;		SayFormattedMessageBoxWindow ()
;;x;		let iValue = True
;;x;	endif
;;x;elif (sRealWindowClass == WCN_MailWindow) then
;;x;	; The subject field of the Mail Small view does not have any prompt.
;;x;	; The following test checks for this view and adds the prompt.
;;x;	If (GetWindowHierarchyX (GlobalFocusWindow) == 2) &&
;;x;	(GetMessageViewType (GlobalFocusWindow) == MSGVW_SmallView) Then
;;x;		SayControlExWithMarkup (GlobalFocusWindow, MSG_Prompt4_L) ;MSG_Prompt4_L "Subject: "
;;x;		let iValue = True
;;x;	EndIf
;;x;	; The Message box window is always the third window of the same logical level of the Hierarchy.
;;x;	If (GetWindowHierarchyX (GlobalFocusWindow) == 3) Then
;;x;		; Call the function that determines if to perform a SayAll or read the current line of a message
;;x;		SayFormattedMessageBoxWindow ()
;;x;		let iValue = TRUE
;;x;	EndIf
;;x;endIf
;;x;If (sClass == cwcIEServer) Then
;;x;; Stores the current setting of the Quick key navigation for HTML pages.
;;x;	Let giGWQuickKeyNavigation= GetJcfOption (opt_quick_key_navigation_mode)
;;x;	SayFormattedMessageBoxWindow ()
;;x;	return TRUE
;;x;EndIf
;;x;; Sets the Quick Key Navigation back to the default setting, 
;;x;; when not in the Internet_Server window.
;;x;SetJcfOption (opt_quick_key_navigation_mode,giGWQuickKeyNavigation)
;;x;return iValue
;;x;
;;x;EndFunction



Function SayFormattedMessageBoxWindow()
;;;TrcEnter("SayFormattedMessageBoxWindow")
Var
	string sTitle

let sTitle = GetAppTitle ()
;;;OutputDebugString(sTitle)
If StringContains (sTitle, wn_to) Then
	If (GetWindowClass (GlobalFocusWindow) == cwcIEServer) Then
	; Turns off the Quick Key Navigation when editing a html message.
		SetJcfOption (opt_quick_key_navigation_mode,0)
	EndIf
	;;;OutputDebugString("--SayControlExWithMarkup")
	SayControlExWithMarkup (GlobalFocusWindow, MSG_Prompt1_L) ;MSG_Prompt1Prompt1_L "Message "
Else
    If ((GetWindowClass (GlobalFocusWindow) == cwcIEServer) && (iTogglePageReading == FALSE) &&
        (GetWindowClass (GetParent (GlobalFocusWindow)) == WCN_HTMLMessageWindow) && 
        (GetWindowClass (GetRealWindow (GlobalFocusWindow)) == wcn_Dialog) &&
        (StringContains(GetWindowName(GetTopLevelWindow(GetFocus())), "Organization") )) Then
        If ((bSayFocusWindowSameAsLast == FALSE)) Then
            If ((PriorParagraph() == TRUE)) Then
                SayParagraph()
            Else
                SayParagraph()
            EndIf
            If ((NextParagraph() == TRUE)) Then
                SayParagraph()
            EndIf
            ;;;TrcExit("SayFormattedMessageBoxWindow1a")
            return
        EndIf
        ;;;TrcExit("SayFormattedMessageBoxWindow1b")
        return
    EndIf
	If iTogglePageReading then
		SayAll ()
	Else
		SayLine ()
	endIf
EndIf
;;;TrcExit("SayFormattedMessageBoxWindow")
EndFunction



int Function HandleMessageOrProperties(
	handle	hwnd,
	int		iControlId,
	string	sControlClassName,
	string	sParentClassName)
;;;TrcEnter("HandleMessageOrProperties")
var string sControlName,
	string sControlType,
	string sTutorMsg,
	int bReadOnly

	let sControlName = ""
	let sControlType = ""
	let sTutorMsg = ""
	let bReadOnly = FALSE
	;;;OutputDebugString(FormatString("sControlClassName : %1", sControlClassName))
	;;;OutputDebugString(FormatString("sParentClassName : %1", sParentClassName))
	;;;OutputDebugString(FormatString("iControlId : %1",IntToString(iControlId)))

if (sControlClassName == WCN_RICHEDIT20) && (iControlId == CID_MESSAGE_RTF) then
	let sControlName = MSG_MESSAGE_COLON
	let bReadOnly = GetWindowStyleBits(hwnd) & ES_READONLY
elif (sControlClassName == cwcIEServer) then
	if IsDescendent(hwnd, "CHTMLPropertiesViewer") then
		let sControlName = MSG_PROPERTIES_COLON
		let sControlType = "Edit"
		let sTutorMsg = msgReadOnlyEdit ; "Use your reading keys to read the text"
		let bReadOnly = TRUE
	elif (sParentCLassName == "GWEditHost") then
		let sControlName = MSG_MESSAGE_COLON
		let sControlType = "Edit"
		let sTutorMsg = msgEdit			; "Type in text"
		let bReadOnly = FALSE
	elif IsDescendent(hwnd, "OWL_Window") then
		let sControlName = MSG_MESSAGE_COLON
		let sControlType = "Edit"
		let sTutorMsg = msgReadOnlyEdit ; "Use your reading keys to read the text"
		let bReadOnly = TRUE
 	endif
endif

if (sControlName != "") then
	SayControlExWithMarkup(hwnd, sControlName, sControlType)
	if (bReadOnly) then
		if (sTutorMsg != "") then 
			SayUsingVoice(VCTX_MESSAGE, sTutorMsg, OT_TUTOR)	 ;For IEServer, says "Use your reading keys to read the text"
		endif
		if (iTogglePageReading) then
			SayAll()
		else
			SayLine()
		endif
	else
		if (sTutorMsg != "") then
			SayUsingVoice(VCTX_MESSAGE, sTutorMsg, OT_TUTOR)	; For IEServer, Says "type in text"
		endif
	endif
	;;;TrcExit("HandleMessageOrProperties1-return true")
	return TRUE
endif

;;;TrcExit("HandleMessageOrProperties0-return false")
return FALSE
EndFunction ;HandleMessageOrProperties




Function ProxyDialogue ()
Var
	Handle TheParent ;Stores the parent handle

let TheParent = GetParent (GlobalFocusWindow) ;Assigns the parent window handle to variable.
;Checks to see if the current control is the proxy name.
If (GetControlId (TheParent) == CID_ProxyName) Then
	;Announce the static text which is the prior window.
	SayFormattedMessage (OT_control_name, GetWindowText (GetPriorwindow (TheParent), Read_Everything))
EndIf
;Checks to see if the focus is on the list box or not.
If (GetCurrentControlId () == CID_ProxyListBox) Then
	;Anounces the static text which is the previous window.
	SayFormattedMessage (OT_control_name, GetWindowText (GetPriorwindow (GlobalFocuswindow), Read_Everything))
EndIf
EndFunction



Function Find55Dialogue ()
Var
	Handle TheParent, ;Assigns the parent handle.
	Handle HWnd, ;tempory window handle variable
	string sMessage

let TheParent = GetParent (GlobalFocusWindow) ;Assigns the parent handle to variable
;Checks to see if the parent control id is the combo box of the find dialogue.
If (GetControlId (TheParent) == CID_FindComboBox) Then
	;Announces the prompt associated with the full text search combo box
	let sMessage = FormatString (ssc1, GetWindowText (GetPriorWindow (TheParent), Read_Everything))
	SayFormattedMessage (OT_control_name, sMessage)
EndIf
;Checks to see if the control id is the Advance find button.
;If so, then the static text associated with the button is announced.
If (GetCurrentControlId () == CID_FindAdvanceButton) then
	;Announces the current rule for the advance find button.
	let sMessage = FormatString (MSG_Prompt6_L, GetWindowText (GetNextWindow (GetNextWindow (GlobalFocusWindow)), Read_Everything))
		SayFormattedMessage (OT_control_name, sMessage)
endIf
If (GetCurrentControlID () == CID_FIND55SUBJECT) Then
	let sMessage = FormatString (ssc1, GetWindowText (GetFirstChild (GetPriorwindow (getPriorWindow (globalFocuswindow))), Read_Everything))
	SayFormattedMessage (OT_control_name, sMessage)
EndIf
If (GetCurrentControlID () == CID_FIND55AUTHOR) Then
	let sMessage = FormatString (ssc1, GetWindowText (GetPriorWindow (globalFocuswindow), Read_Everything))
	SayFormattedMessage (OT_control_name, sMessage)
endIf
If (GetCurrentControlID () >= CID_FIND55MAILITEM) && (GetCurrentControlID () <= CID_FIND55DOCUMENTITEM) Then
	let Hwnd = FindDescendantWindow (TheParent, CID_FIND55ITEM)
	SayFormattedMessage (OT_control_name, GetWindowText (HWnd, Read_Everything))
endIf
If (GetCurrentControlID () >= CID_FIND55RECEIVED) && (GetCurrentControlID () <= CID_FIND55DRAFT) Then
	let Hwnd = FindDescendantWindow (TheParent, CID_FIND55ITEMSOURCE)
	SayFormattedMessage (OT_control_name, GetWindowText (HWnd, Read_Everything))
endIf
If (GetCurrentControlID () == CID_FIND55DATERANGE) ||
(GetCurrentControlID () == CID_FIND55LOOKIN) THEN
	SayFormattedMessage (OT_control_name, GetWindowText (GetPriorwindow (GlobalFocuswindow), Read_Everything))
endIf
EndFunction



Void Function FilterAdvanceDialogue()
Var
	Int FilterNo, ;Stores the filter number.
	string sMessage

;Checks to see if the control id falls between the Filter (condition) combo box and the operator button.
;Each time a condition is created and the user uses a logical operator, Groupwise assigns a new control id
;to the condition combo box.	As far as I know, the condition combo boxes stay in the 1300 range and since the
;operator button starts at 1400, therefore the possible maximum number of conditions are about 99.
If (GetCurrentControlId () >= CID_FilterAdvanceComboBox) &&
(GetCurrentcontrolid () < CID_FilterAdvanceOperatorButton) Then		;If the current control id is the same as 1300, assign 1 to the variable.
;Checks to see if the CID_FilterAdvanceComboBox (control id 1300) is present on the screen.
;This is done because when you create a new condition, the first control id is 1300 and every condition combo box from
;that point is increased by one.  E.G.	The second condition combo box has a control id of 1301, etc.
;If you are editing a condition, then the first condition combo box is 1301, therefore a different calculation has to be used.
	If FindDescendantWindow (GetRealWindow (GlobalFocusWindow), CID_FilterAdvanceComboBox) Then
		;Subtract the CID_FilterAdvanceComboBox from the current control id and add one to get the condition number.
		let FilterNo = (GetCurrentcontrolId () - CID_FilterAdvanceComboBox) + 1
	Else
		;Subtract the CID_FilterAdvanceComboBox from the current control id to get the condition number.
		let FilterNo = GetCurrentcontrolId () - CID_FilterAdvanceComboBox
	endIf
	let sMessage = FormatString (MSG_Prompt5_L, IntToString (filterNo))
	SayFormattedMessage (OT_CONTROL_NAME, sMessage) ;MSG_Prompt5_L "Condition: "
EndIf
EndFunction



Int Function DefineRule ()
Var
	int iValue,
	Handle Hwnd,
	String TheParentClass,
	Int TheControlId,
	Int TheParentControlId,
	Handle TheParent

let iValue = FALSE
let TheParent = GetParent (GlobalFocusWindow)
let TheParentClass = GetWindowClass (TheParent)
let TheControlId = GetCurrentControlId ()
let TheParentControlId = GetControlId (TheParent)
; the following if tests fixes problems with group boxes or prompts not being correctly spoken.
If (TheParentControlId == CID_NewRuleEventButton) Then
	SayControlExWithMarkup (GlobalFocusWindow, GetObjectName (), GetObjectType (), GetObjectState (), GetWindowText (GetPriorwindow (TheParent), Read_Everything))
	let iValue = TRUE
EndIf
If (TheControlId >= CID_MailItemButton) && (TheControlId <= CID_NoteItemButton) Then
	let Hwnd = FindDescendantWindow (TheParent, CID_MailItemButton)
	SayControlExWithMarkup (GlobalFocusWindow, GetObjectName (), GetObjectType (), GetObjectState (), GetWindowText (GetPriorwindow (Hwnd), Read_Everything))
	let iValue = TRUE
endIf
If (TheControlId >= CID_RecievedButton) && (ThecontrolId <= CID_DraftsButton) Then
	let Hwnd = FindDescendantWindow (TheParent, CID_RecievedStaticText)
	SayControlExWithMarkup (GlobalFocusWindow, GetObjectName (), GetObjectType (), GetObjectState (), GetWindowText (Hwnd, Read_Everything))
	let iValue = TRUE
endIf
If TheControlId == CID_ConditionButton Then
	let HWnd = FindDescendantWindow (TheParent, CID_ConditionPrompt)
	SayControlExWithMarkup (GlobalFocusWindow, GetObjectName (), GetObjectType (), GetObjectState (), GetWindowText (GetNextWindow (HWnd), Read_Everything))
	SayFormattedMessage (OT_control_name, GetWindowText (GetNextWindow (GlobalFocuswindow), Read_Everything))
	let iValue = TRUE
EndIf
If (ThecontrolId == 25) Then
	let HWnd = FindDescendantWindow (TheParent, CID_AppointmentConflictButton)
	SayControlExWithMarkup (GlobalFocusWindow, GetObjectName (), GetObjectType (), GetObjectState (), GetWindowText (GetNextWindow (HWnd), Read_Everything))
	let iValue = TRUE
endIf
return iValue
EndFunction



Function BusySearchDialogue ()
Var
	Int TheControlId

let TheControlId = GetControlId (GetParent (GlobalFocuswindow))
If (ThecontrolId == CID_BusySearchTo) Then
	SayFormattedMessage (OT_control_name, MSG_Prompt2_L) ;MSG_Prompt2_L "To: "
EndIf
If (TheControlId == CID_BusySearchDateButton) Then
	SayFormattedMessage (OT_control_name, MSG_Prompt2_L) ;MSG_Prompt2_L "To: "
EndIf
EndFunction

Function PhoneMessageWindow ()
;;;TrcEnter("PhoneMessageWindow")
Var
	Int TheControlId, ;contains the control id
	Handle HWnd, ;contains window handle
	String TheTitle ;Contains the window title

;Stores the window title into the TheTitle variable.
let TheTitle = GetWindowName (GetRealWindow (globalFocuswindow))

;The following if test checks to see if the current window with focus is a Window class of edit.
;If so, then the focus is on either the To, CC and BC fields of a message.

if (GWVersion>=653) then
	SayFieldPrompt( GlobalFocusWindow, " ");sWindowName )
else
	if (GetWindowClass (GlobalFocusWindow) == WCN_Edit) Then
		SaySenderFieldPrompt ()
	endif
endif

;Store the control id into the TheControlId variable.
let TheControlId = GetControlId (GlobalFocusWindow)
If (!FindDescendantWindow (GetRealwindow (GlobalFocusWindow), CID_StandardButton)) Then
	If FindDescendantWindow (GetRealWindow (GlobalFocusWindow), Cid_PhoneTo) Then
		let TheControlId = TheControlId - 1
	EndIf
EndIf
If (TheControlId == CID_PhoneMessageBox) Then
;	SayControlExWithMarkup (GlobalFocusWindow, MSG_Prompt1_L) ;MSG_Prompt1Prompt1_L "Message "
	SayFormattedMessageBoxWindow ()
	;;;TrcExit("PhoneMessageWindow1")
	Return
EndIf
SayWindowTypeAndText (globalFocusWindow)
;;;TrcExit("PhoneMessageWindow1")
EndFunction

;----------------------------------------------------------------------
; KeyPressedEvent
;----------------------------------------------------------------------
Void Function KeyPressedEvent (int nKey, string strKeyName, int nIsBrailleKey, int nIsScriptKey)
var 	
	handle hFocus,
	int iControlId,
	int iObjType
let hFocus = GetFocus()
let iObjType = GetWindowSubtypeCode(hFocus)
;;;;OutputDebugString(FormatString("--KPE:%1,%2", IntToSTring(nKey), strKeyName ))

; When we get a keypressed event when focus is in a SysTabControl 
; it is usually Ctrl-Tab, Left-Arrow or some other navigation
; key sequence that will cause the selected 'tab' to change.
; When this happens, JAWS will correctly 'read' the new "tab".
; We need to remember that the 'tab' has already been 'read' so
; we won't speak it a second time.
;
if (iObjType == WT_TABCONTROL) then
	let g_hwndLastSysTab = hFocus;
	let g_sLastTabName = GetWindowName(g_hwndLastSysTab);
endif

; The space toggles the checked state on some listview and
; Treeview controls.
;
if (nKey == key_SPACEBAR && iObjType == wt_listview) then
	let iControlId = GetControlId(hFocus)
	;
	; If we are in the category listview, the spacebar causes the
	; checkbox to be "checked" or "not checked".  The code 'appends'
	; the checked state to the category name: "On" or "Off". 
	; The change in the category name will, in turn, result in a
	; "SayHighlightedText" event, or for some category colors, a
	; "SayNonHighlightedText" event.  In either case, we want
	; that text to be 'read'.
	;
	if ((iControlId == CID_CATEGORY_LV) || (iControlId == CID_CATEGORIESLIST)) then
		; SayHighlighted text is automatically spoken.
		; Set a flag so "SayNonHighlighted" text will also be spoken.
		let g_bSayNonHighlightedText = 1
		; Invoke the keypressedevent so the item will change state.
		KeyPressedEvent(nKey,strKeyName,nIsBrailleKey,nIsScriptKey)
		; Now clear the flag 
		let g_bSayNonHighlightedText = 0
		return
	endif
endif

If ((GetWindowClass(GetParent(hFocus)) == WCN_PopupButton) && (GetControlId(GetParent(hFocus)) == CID_ENUM_ACCEPT_LEVEL)) then
	If ((nKey== key_DownArrow) || (nKey==key_UpArrow)) Then
		SayFormattedMessage(OT_CONTROL_NAME, "Show as")
		SimulateKey("Space")
		return
	endif
EndIf

;Call default function
KeyPressedEvent(nKey,strKeyName,nIsBrailleKey,nIsScriptKey)
EndFunction


;----------------------------------------------------------------------
; IsDescendent
; If the window handle is a descendent of a window with the specified
; class name, return the window handle of the ancestor window.
;----------------------------------------------------------------------
Handle Function IsDescendent( handle hwnd, string sAncestorClass)
var int bIsDescendent
let bIsDescendent = FALSE
while (hwnd)
	let hwnd = GetParent(hwnd)
	if (GetWindowClass(hwnd) == sAncestorClass) then
		return hwnd;
	endif
endwhile
return g_hwndNull
EndFunction

;----------------------------------------------------------------------
; HandleTabControl
; This function handles 'read'ing of the SysTabControl that is an
; ancestor of the window that now has focus.
; This function is necessary for SysTabControls in GroupWise views.
; JAWS correctly handles SysTabControls that are in dialogs.
;
; Returns TRUE if the calling routine needs to continue processing
; the window that received focus.
; Returns FALSE if the calling routine does not need to continue
; processing the window that received focus.
;----------------------------------------------------------------------
int Function HandleTabControl()
;;;TrcEnter("HandleTabControl")
;
; JAWS seems to handle SysTabControls correctly when they appear in a 
; dialog. If JAWS already knows the focus is in a tabbed dialog, 
; bail out here.
;
if IsMultiPageDialog() then 
	;;;OutputDebugString("--Tab Control Handled By JAWS")
	;;;TrcExit("HandleTabControl-False1")
	return false	;continue processing GlobalFocusWindow
endif

; if this control is a SysTabControl, then 'read' it and remember 
; that we 'read' it.
;
if (GetWindowClass(GlobalFocusWindow)==WCN_SysTabControl32) then
	let g_hwndLastSysTab = GlobalFocusWindow;
	let g_sLastTabName = GetWindowName(g_hwndLastSysTab);
	;;;OutputDebugString("--Control Is A Tab Control")
	SayFocusedObject();
	;;;TrcExit("HandleTabControl-True1");
	return TRUE		; no need to continue processing GlobalFocusWindow
endif

; If this control is not under a SysTabControl we can bail out.
;
var handle hwndSysTab
let hwndSysTab = IsDescendent( GlobalFocusWindow, WCN_SysTabControl32 )
if (hwndSysTab == g_hwndNull) then
	;;;OutputDebugString("--Not a descendent of systabcontrol")
	;;;TrcExit("HandleTabControl-False2")
	return FALSE	; continue processing globalfocuswindow
endif

; Get the Current Tab's name
;
var string sTabName
let sTabName = GetWindowName(hwndSysTab)

; If the current tab has already been 'read', we can bail out.
;
if (hwndSysTab == g_hwndLastSysTab) && (sTabName == g_sLastTabName) then
	;;;OutputDebugString("--Tab has already been read")
	;;;TrcExit("HandleTabControl-False3)")
	return FALSE	; continue processing globalfocuswindow
endif

; 'Read' the TabControl's Type and Text.  
; Remember that we 'read' it.
;
let g_hwndLastSysTab = hwndSysTab
let g_sLastTabName = sTabName
SayWindowTypeandText(hwndSysTab)
;;;OutputDebugString("--Tab control 'read'!")
;;;TrcExit("HandleTabControl-False4")
return FALSE	; continue processing globalfocuswindow
EndFunction


Function SayFocusedWindow ()
;;;OutputDebugString("")
;;;TrcEnter("SayFocusedWindow")

var
	int iControlId,
	int iParentId,
	handle	hwndControl,
	handle hwndParent,
	string	sControlClassName,
	string	sParentClassName,
	string sCurrentWnd,
	string sAppTitle,
	handle hwndLabel

	let hwndControl = GlobalFocusWindow
	let hwndParent = GetParent(hwndControl)
	let iControlId = GetControlId(hwndControl)
	let iParentId = GetControlId(hwndParent)
	let sControlClassName = GetWindowClass(hwndControl)
	let sParentClassName = GetWindowClass(hwndParent)
	let  sCurrentWnd = GetWindowClass (GetRealWindow (GetFocus()))
	let sAppTitle = GetAppTitle()

	;;;OutputDebugString(FormatString("--ControlId=%1",IntToString(iControlId)))
	;;;OutputDebugString(FormatString("--ClassName=%1", sControlClassName ))
	;;;OutputDebugString(FormatString("--Type=%1",IntToString(GetWindowTypeCode(hwndControl))))
	;;;OutputDebugString(FormatString("--Subtype=%1",IntToString(GetWindowSubTypeCode(hwndControl))))
	;;;OutputDebugString(FormatString("--ParentId=%1",IntToString(iParentId)))
	;;;OutputDebugString(FormatString("--ParentClass=%1",sParentClassName))
	;;;OutputDebugString(FormatString("--ParentType=%1",IntToString(GetWindowTypeCode(hwndParent))))
	;;;OutputDebugString(FormatString("--ParentSubtype=%1",IntToString(GetWindowSubTypeCode(hwndParent))))
	;;;OutputDebugString(FormatString("--RealClassName=%1",GetWindowClass(GetRealWindow(hwndControl))))
	;;;OutputDebugString(FormatString("----GetItemCount=%1",IntToString(GetItemCount(hwndControl))))
	;;;OutputDebugString(FormatString("--sAppTitle=%1", sAppTitle))

	;Say a message indicating the purpose of the '+' link in the Welcome Screen
	if (GetObjectType() == "Link" && GetObjectName() == "gwlinkplus" && GetWindowClass(hwndControl) == CWCIEServer) then
		SayFormattedMessage(OT_NO_DISABLE,  GetObjectType()+"Launch online tutorial window now")
		return
	endif

	;Say the controls for deleting and editing comments in the Notes Tab (Contact Information Dialog)
	if (GetWindowClass(hwndControl) == CWCIEServer && GetWindowClass(GetParent (hwndControl)) == WCN_HTMLMessageWindow
	    && GetWindowClass(GetParent(GetParent(hwndControl))) == WC_SHELL && GetWindowText(GetNextWindow(GetParent(GetParent(GetParent(hwndControl)))),0) == WN_Categories) then	
		Refresh()
		if (StringCompare(GetObjectName(),"#1") == 0 || StringCompare(GetObjectName(),"Delete") == 0) then
			SayFormattedMessage(OT_NO_DISABLE,  MSG_DELETECOMMENT)
			return
		endif
		if (StringCompare(GetObjectName(),"#2") == 0 || StringCompare(GetObjectName(),"Edit") == 0) then
			SayFormattedMessage(OT_NO_DISABLE,  MSG_EDITCOMMENT)
			return
		endif
	endif

	;Hit the Road spin boxes
	if (sControlClassName == wcn_Edit && sParentClassName == WCN_SPINCTRL && GetWindowClass(GetParent(hwndParent)) == wcn_Dialog) then
		var string sLabel 
		if (iControlId == 101) then
			var handle hwndContainer
			let hwndContainer = GetParent(hwndParent)
			if (GetWindowName(hwndContainer) == "Retrieve Page") then
				if (iParentId == ID_RETVOPTS_DAYSPRIOR) then
					let hwndLabel = FindWindowWithClassAndId(hwndContainer, "static", ID_RETVOPTS_FROM_LABEL)
					let sLabel = GetTextInWindow(hwndLabel)
					let hwndLabel = FindWindowWithClassAndId(hwndContainer, "static", ID_RETVOPTS_FROM)
					let sLabel = sLabel + GetTextInWindow(hwndLabel)
					let hwndLabel = FindWindowWithClassAndId(hwndContainer, "static", ID_RETVOPTS_DAYSPRIOR_LABEL)
					SayControlEx(hwndControl, sLabel, "", "", "", "", "", "", GetTextInWindow(hwndLabel))
					return
				endif
				if (iParentId == ID_RETVOPTS_DAYSAFTER) then
					let hwndLabel = FindWindowWithClassAndId(hwndContainer, "static", ID_RETVOPTS_TO_LABEL)
					let sLabel = GetTextInWindow(hwndLabel)
					let hwndLabel = FindWindowWithClassAndId(hwndContainer, "static", ID_RETVOPTS_TO)
					let sLabel = sLabel + GetTextInWindow(hwndLabel)
					let hwndLabel = FindWindowWithClassAndId(hwndContainer, "static", ID_RETVOPTS_DAYSAFTER_LABEL)
					SayControlEx(hwndControl, sLabel, "", "", "", "", "", "", GetTextInWindow(hwndLabel))
					return
				endif
			endif
			if (iParentId == ID_SIZEOPTS_MESSAGE || iParentId == ID_SIZEOPTS_ATTACHMENT || iParentId == ID_SIZEOPTS_TOCCBC) then
				if (GetWindowName(hwndContainer) == "Size Limits Page") then
					let hwndLabel = FindWindowWithClassAndId(hwndContainer, "static", ID_SIZEOPTS_KB + (iParentId - 15))
					SayControlEx(hwndControl, "", "", "", "", "", "", "", GetTextInWindow(hwndLabel))
					return
				endif
			endif
		endif
	endif

	;Speak the commands about how move through the month in the calendar only if the last selected window is different from any cell (day) located in the month
	if (GetControlId(g_hwndLastSayFocusWindow) != ID_FOLDERLIST_CTRL && GetWindowClass(hwndControl) == "OWL_Window" && GetWindowClass(GetParent(hwndControl)) == "GWCalendarContentPane" && (GetWindowClass(g_hwndLastFocusedDay) != "AfxWnd80ud" && GetWindowClass(g_hwndLastFocusedDay) != "AfxFrameOrView80ud")) then
		SayFormattedMessage(OT_NO_DISABLE, GetTextInWindow(FindWindow(GetRealWindow(hwndControl),"GWDatePicker")))
		SayFormattedMessage(OT_NO_DISABLE, msgMoveThroughCalendar)
		SayFormattedMessage(OT_NO_DISABLE, msgOpenDaySchedule)
		let g_hwndLastFocusedDay = hwndControl
		return
	endif
	if (GetWindowClass(hwndControl) == "OWL_Window" && GetWindowClass(GetParent(hwndControl)) == "GWCalendarContentPane") then
		let g_hwndLastFocusedDay = hwndControl
	else
		let g_hwndLastFocusedDay = g_hwndNull
		let g_hwndLastClickedDay = g_hwndNull
	endif

	if ((sControlClassName == wcn_Button) && (sParentClassName == wcn_Dialog )) then
		if (iControlId == IDC_CHECKOUT_BROWSE && GetWindowName(hwndParent) == "Check-out" ) then
			SayFormattedMessage(OT_NO_DISABLE,  msgBrowseFolder)
			IndicateControlType(WT_BUTTON)
   		return
		endif
	endif

	;Say what these buttons are for (in Contact Information Dialog)
	if (sControlClassName == wcn_Button && sParentClassName == wcn_Dialog && GetWindowClass(GetParent(hwndParent)) == wcn_Dialog) then
		if (iControlId == CID_COMPANY_INFORMATION) then
			SayFormattedMessage(OT_NO_DISABLE,  msgCompanyInformation)
			IndicateControlType(WT_BUTTON)
   		return
		endif
		if (iControlId == IDC_CONTACT_PHOTO) then
			SayFormattedMessage(OT_NO_DISABLE,  msgContactPhoto)
			IndicateControlType(WT_BUTTON)
   		return
		endif
		if (iControlId == IDC_ENABLE_BIRTHDAY) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_BIRTHDAY)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel),"","","","","","","")
   		return
		endif	
		if (iControlId == IDC_VIEW_BIRTHDAY) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_BIRTHDAY)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel)+msgViewBirthdayInCalendar,"","","","","","","")
   		return
		endif
		if (iControlId == IDC_ENABLE_ANNIVERSARY) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_ANNIVERSARY)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel),"","","","","","","")
   		return
		endif		
		if (iControlId == IDC_VIEW_ANNIVERSARY) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_ANNIVERSARY)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel)+msgViewAnniversaryInCalendar,"","","","","","","")
   		return
		endif
		if (iControlId == IDC_LAUNCH_OFFICE_WEBSITE) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_OFFICE_WEBSITE)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel)+msgLaunchOfficeWebsite,"","","","","","","")
   		return
		endif
		if (iControlId == IDC_LAUNCH_PERSONAL_WEBSITE) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_PERSONAL_WEBSITE)
			SayControlEx(hwndControl,GetTextInWindow(hwndLabel)+msgLaunchPersonalWebsite,"","","","","","","")
   		return
		endif
	endif

	;Say what these EDIT BOX are for (in Contact Information Dialog)
	if (sControlClassName == wcn_Edit && sParentClassName == wcn_Dialog && GetWindowClass(GetParent(hwndParent)) == wcn_Dialog) then		
		if (iControlId == IDC_FULLNAME) then
			SayControlEx(hwndControl,msgFullName,"","","","","","","")
   		return
		endif
		if (iControlId >= IDC_OFFICE_ADDRESS && iControlId <= IDC_OFFICE_POSTALCODE) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_OFFICE_ADDRESS)
			if (iControlId == IDC_OFFICE_ADDRESS) then
				SayControlEx(hwndControl,msgStreetAddress,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OFFICE_CITY) then
				SayControlEx(hwndControl,msgCity,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OFFICE_STATE) then
				SayControlEx(hwndControl,msgState,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OFFICE_POSTALCODE) then
				SayControlEx(hwndControl,msgPostalCode,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			return
		endif
		if (iControlId >= IDC_HOME_ADDRESS && iControlId <= IDC_HOME_POSTALCODE) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_HOME_ADDRESS)
			if (iControlId == IDC_HOME_ADDRESS) then
				SayControlEx(hwndControl,msgStreetAddress,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_HOME_CITY) then
				SayControlEx(hwndControl,msgCity,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_HOME_STATE) then
				SayControlEx(hwndControl,msgState,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_HOME_POSTALCODE) then
				SayControlEx(hwndControl,msgPostalCode,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			return
		endif
		if (iControlId >= IDC_OTHER_ADDRESS && iControlId <= IDC_OTHER_POSTALCODE) then
			let hwndLabel = FindWindowWithClassAndId(hwndParent,"Static",IDC_LABEL_OTHER_ADDRESS)
			if (iControlId == IDC_OTHER_ADDRESS) then
				SayControlEx(hwndControl,msgStreetAddress,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OTHER_CITY) then
				SayControlEx(hwndControl,msgCity,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OTHER_STATE) then
				SayControlEx(hwndControl,msgState,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iControlId == IDC_OTHER_POSTALCODE) then
				SayControlEx(hwndControl,msgPostalCode,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			return
		endif
	endif

	;Say what these COMBO BOX are for (in Contact Information Dialog)
	if (sParentClassName == wcn_ComboBox && GetWindowClass(GetParent(hwndParent)) == wcn_Dialog && GetWindowClass(GetParent(GetParent(hwndParent))) == wcn_Dialog) then
		if ((iControlId == IDC_EDIT_COUNTRY)  && (sControlClassName == wcn_Edit)) then
			if (iParentId == IDC_OFFICE_COUNTRY) then
				let hwndLabel = FindWindowWithClassAndId(GetParent(hwndParent),"Static",IDC_LABEL_OFFICE_ADDRESS)
				SayControlEx(hwndControl,msgCountry,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iParentId == IDC_HOME_COUNTRY) then
				let hwndLabel = FindWindowWithClassAndId(GetParent(hwndParent),"Static",IDC_LABEL_HOME_ADDRESS)
				SayControlEx(hwndControl,msgCountry,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			if (iParentId == IDC_OTHER_COUNTRY) then
				let hwndLabel = FindWindowWithClassAndId(GetParent(hwndParent),"Static",IDC_LABEL_OTHER_ADDRESS)
				SayControlEx(hwndControl,msgCountry,"","",GetTextInWindow(hwndLabel),"","","","")
			endif
			return				
		endif
	endif

; If the focusedwindow is below a SysTabControl on an itemview,
; make sure the 'tab' has been read.  
;
if HandleTabControl() then
	;;;TrcExit("SayFocusedWindow-0a bail out because its a TabControl")
	return
endif

; If this window is the same as the last window we 'spoke', set flag TRUE
;

if (GlobalFocusWindow == g_hwndLastSayFocusWindow) then
	let bSayFocusWindowSameAsLast = TRUE
else
	let bSayFocusWindowSameAsLast = FALSE
endif
let g_hwndLastSayFocusWindow = GlobalFocusWindow	; Save for next time we are called

if (HandleGWHdrCtl( GlobalFocusWindow)) then
	;;;TrcExit("SayFocusedWindow-1a")
	return
endif
if (HandleAddressField( GlobalFocusWindow)) then
	;;;TrcExit("SayFocusedWindow-1b")
	return
endif

if (HandleDatePicker( GlobalFocusWindow)) then
	;;;TrcExit("SayFocusedWindow-1c")
	return
endif

if HandleMessageOrProperties(GlobalFocusWindow, iControlId, sControlClassName, sParentClassName) then
	;;;TrcExit("SayFocusedWindow-1d")
	return
endif
; If the control is part of the IE font dialog, call default 
; SayFocusedWindow and return. We must do this check BEFORE calling 
; HandleOther.  Otherwise the "Internet Explorer_Server" window that 
; is part of the IE Font Dialog is mistaken for a message window.
;
if IsDescendent( GlobalFocusWindow, WCN_IE_TRIDENTDLGFRAME) then
	SayFocusedWindow()
	;;;TrcExit("SayFocusedWindow-1e")
	return;
endif

if (HandleOther( GlobalFocusWindow)) then
	;;;TrcExit("SayFocusedWindow-1f")
	return
endif

;	SayControlExDebug( GlobalFocusWindow )
;	SayControlExWMDebug( GlobalFocusWindow )
;	SayVariousDebug(  )

Var
	String TheWindowName, 		;Gets the current window name.
	String TheRealWindowClass, ;Stores the real window class
	Handle hwndReal,				;stores the handle of the window
;;x;	String TheClass, 				;stores the window class
;;x;	int iControlId, 				;control id of the current control id
;;x;	int iParentControlId, 		;control id of the parent control.
	string sGroupBox, 			;stores the groupBox name
	string sWindowText ,			;stores the window text.
	handle hwndTmp

let TheWindowName = GetWindowName (GetRealwindow (GlobalFocuswindow)) ;assigns the window name to variable
;let TheClass = GetWindowClass (GlobalFocusWindow) ;assigns the window class to variable
let hwndReal = GetRealwindow (GlobalFocusWindow) ;Assigns the real window handle to variable
let TheRealWindowClass = GetWindowclass (hwndReal) ;assigns the real window class to variable

;;x;if CheckMessageType (TheWindowName, hwndReal, TheRealWindowClass) Then
;;x;	;;;TrcExit("SayFocusedWindow-2b")
;;x;	return
;;x;endif

;checks to see if the current control is a menu button or not.
If (sParentClassName == WCN_PopupButton) Then
	if (iParentId == CID_ENUM_ACCEPT_LEVEL) then
		SayFormattedMessage(OT_CONTROL_NAME, "Show as")
		If (!bSayFocusWindowSameAsLast) Then
			SimulateKey("Space")
		Else
			SayFocusedObject()
		EndIf
		return
	else
		let sWindowText = GetWindowName(GetPriorWindow(GetParent(GlobalFocusWindow))) + " " + Msg_Prompt11_L + " " + GetWindowText (GlobalFocusWindow, FALSE) + " selected"
		SayString (sWindowText)

		var	handle hTemp

		if (iParentId == CID_DateFormat_Date) then
			let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_DateFormat_Date_Format)

			SayString (GetWindowName (hTemp))
		elif (iParentId == CID_DateFormat_MainWnd) then
			let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_DateFormat_MainWnd_Format)

			SayString (GetWindowName (hTemp))
		elif (iParentId == CID_DateFormat_Properties) then
			let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_DateFormat_Properties_Format)

			SayString (GetWindowName (hTemp))
		elif (iParentId == CID_DateFormat_FileInfo) then
			let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_DateFormat_FileInfo_Format)

			SayString (GetWindowName (hTemp))
		endif

		;;;TrcExit("SayFocusedWindow3")
		Return
	endif
EndIf

;The purpose for the following if test, is to read out buttons labels correctly.
;JAWS does not read out the graphic label attached to Bit map buttons automatically in Groupwise.
;But JAWS has no problems with Text labelled Buttons.
;all bit map buttons have graphic labels associated with them.
;The first condition of the If test, checks to see if the control is a button.
;If it is, then checks the length of the character.
;all text labelled buttons will return a lenght of one when you use the GetCharacter function, making the test false.
If (GetWindowTypeCode (GlobalFocusWindow)  == WT_Button) &&
(StringLength (GetCharacter ()) > 1)	Then
;	Pause ()
	SayControlExWithMarkup (GlobalFocusWindow, GetCharacter ()) ;announces the graphic attached to the bit map button.
	;;;TrcExit("SayFocusedWindow4")
	Return
EndIf
if (GWVersion >= 653) Then
	;Checks to see if the focus is in the appointment, task or note panes.
	If (sControlClassName ==  WCN_CalendarPane) Then
	    var string sObjectName
	    let sObjectName = GetObjectName()
	    If ((sObjectName == "Task")) Then
	        SayFormattedMessage(OT_NO_DISABLE, "Task ")
	        let g_sLastReadCalendarObjectName = "Task"
	    EndIf
	    If ((sObjectName == "Appointment") && (g_sLastReadCalendarObjectName != "Appointment")) Then
	        SayFormattedMessage(OT_NO_DISABLE, "Appointments ")
	        let g_sLastReadCalendarObjectName = "Appointment"
	    EndIf
	    If ((sObjectName == "Reminder Note")) Then
	        SayFormattedMessage(OT_NO_DISABLE, "Reminder Note ")
	        let g_sLastReadCalendarObjectName = "Reminder Note "
	    EndIf
	    If ((sObjectName == "All Day Event") && (g_bAllDayEventflag == FALSE)) Then
	        SayFormattedMessage(OT_NO_DISABLE, "All Day Event Area ")
	        let g_sLastReadCalendarObjectName = "All Day Event Area"
	    EndIf
	    If ((g_bAllDayEventflag == TRUE)) Then
	        let g_bAllDayEventflag = FALSE
	        Return
	    EndIf
			SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
			let g_bAllDayEventflag = FALSE
			;;;TrcExit("SayFocusedWindow5")
			Return
	endIf
else
	;Checks to see if the window title is the Calendar Day view.
	If (GetAppTitle () == wn_DayWindow || GetAppTitle () == WN_MainGWCalendarWindow) Then 
		;Checks to see if the focus is in the appointment, task or note pains.
		If (sControlClassName ==  WCN_CalendarPane) Then
			SayFormattedMessage (OT_control_name, GetDayViewHeader ())
			;;;TrcExit("SayFocusedWindow6")
			Return
		endIf
		;Checks to see if the focus is in the calendar or not.
		If (sControlClassName == WCN_Calendar) Then
			SayCalendarDate ()
			;;;TrcExit("SayFocusedWindow7")
			Return
		EndIf
	EndIf
Endif

;Checks to see if the busy search dialogue is opened.
If (TheWindowName == wn_BusySearch) Then
	BusySearchDialogue ()
endIf

;Checks to see if the Find Advance, Filter or define condition  dialogues have been opened.
If (TheWindowName == wn_FindAdvanceDialogue) ||
(TheWindowName == wn_FilterDialogue) ||
(TheWindowName == wn_DefineConditionDialogue) Then
	FilterAdvanceDialogue ()
endIf

;Checks to see if the Proxy dialogue has been opened.
If (TheWindowName == wn_ProxyDialogue) Then
	ProxyDialogue ()
EndIf

;checks to see if the rule dialogue has been opened.
If (TheWindowName == wn_RulesDialogue) Then
	; the GetControlId function has to be used in the below if test,
	; because the GetCurrentControlId doesn't return the control id of the List box when it is empty.
	If (GetControlId (GlobalFocusWindow) == CID_rulesListbox) Then
		SayFormattedMessage (OT_control_name, GetWindowText (GetPriorwindow (GlobalFocuswindow), Read_Everything))
	EndIf
EndIf
;Checks to see if the New or Edit rule dialogues have been opened.
If (TheWindowName == wn_NewRuleDialogue) ||
(TheWindowName == wn_EditRuleDialogue) Then
	If DefineRule () Then
		; Control with focus required special handling and has been already announced.
		;;;TrcExit("SayFocusedWindow8")
		return
	EndIf
EndIf
;Checks to see if the spell checker dialogue has been opened.
If (TheWindowName == wn_WritingToolsDialogue) &&
(GetCurrentControlId () == CID_Spellchecker) Then
	SayFormattedMessage (OT_control_name, Msg_Prompt10_L) ;Msg_Prompt10_L "Spell Checker"
	SayFormattedMessage (OT_control_name, GetWindowText (FindDescendantWindow (GetRealWindow (GlobalFocusWindow), CID_NotFoundPrompt), Read_Everything))
	SayFormattedMessage (OT_control_name, GetWindowText (FindDescendantWindow (GetRealWindow (GlobalFocusWindow), CID_NotFoundWord), Read_Everything))
	Delay (5)
	TypeKey (ks1)
	;;;TrcExit("SayFocusedWindow9")
	Return
endIf

;;x;let iControlId = getControlId (GlobalFocusWindow)
;;x;let iParentControlId = getControlId (GetParent (GlobalFocusWindow))

;Checks to see if the Choose Appointment dialogue has been opened.
If (TheWindowName == wn_ChooseAppointmentDialogue) &&
(sControlClassName == WCN_TimeCalendarGrid) Then
	If (GWVersion < 600) Then
		SayFormattedMessage (OT_control_name, GetBusyAppointmentDateTime (TRUE))
		SayFormattedMessage (OT_control_name, GetBusyAppointmentDateTime (FALSE))
	else
		; Weird problem: When using arrow keys, SayFocusedWindow gets called again on first up/down arrow after getting focus
		if (!bSayFocusWindowSameAsLast) then
			SayFormattedMessage( OT_CONTROL_NAME, GetWindowText(GetPriorWindow(GlobalFocusWindow),FALSE))
			SayBusyInfo( iControlId, SBI_SAY_ALL | SBI_SAY_RECIPIENT);
		endif
	endif
	Return
	;;;TrcExit("SayFocusedWindow10")
endIf

;When Groupwise opens for the first time, the first item in the mailbox was not being spoken.
;The following code fixes this problem by introducing a delay.  To prevendelays in other areas of the program,
;The delay statement is only executed when the application window handle changes.
;This does not effect any other groupwise window.
	If (GetWindowTypecode (GlobalFocuswindow) == WT_ListView) &&
	(GlobalPrevApp != GetAppMainWindow (GlobalFocusWindow)) Then
;	Delay (5)
	EndIf

/*
;checks to see if the current message is a HTML message.
If (TheClass == wc_shell) ||
(TheClass == WCN_HTMLMessageWindow) Then
	SayFormattedMessage (OT_control_name, MSG_Prompt1_L)
	InvisibleCursor ()
	MoveToWindow (FindWindow (GlobalFocusWindow, cwcIEServer , cscNull))
	routePcToInvisible ()
	;;;TrcExit("SayFocusedWindow11")
	Return
EndIf
*/
; Handles when the quick view windows have focus.
let QuickViewHasFocus = FALSE
If (sControlClassName == WCN_QuickViewer) Then
;Checks to see if you are in the Quick View window.
	SayFormattedMessage (OT_control_name, msgQuickViewWindow)
	SayFormattedMessageBoxWindow	()
	let QuickViewHasFocus = TRUE
EndIf
If (TheRealWindowClass == WCN_MainWindow) &&
	(GetCurrentControlId () == 333) Then
	;Checks to see if you are in the Quick view Attachment list box.
	SayFormattedMessage(OT_CONTROL_NAME, MSG_Prompt3_S)
EndIf

If (TheWindowName == wn_Environment) &&
(GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) Then
	; Correctly announces the prompt for the edit spin boxes in the environment dialogue, contained within the Option dialogue.
	If (iParentId == cid_GeneralRefreshMins) ||
	(iParentId == cid_GeneralRefreshSecs) Then
		let hwndTmp = GetPriorWindow (GetParent (GlobalFocusWindow))
		let sWindowText = GetWindowText (hwndTmp, READ_EVERYTHING)
		let hwndTmp = FindDescendantWindow (GetParent (hwndTmp), cid_GeneralRefreshStatic)
		let sWindowText = FormatString (GWMsgJoinString, GetWindowText (hwndTmp, Read_EveryThing), sWindowText)
		SayControlExWithMarkup (globalFocusWindow, sWindowText, cscNull, cscNull, GetGroupBoxName ())
		Return
	elIf (iParentId == cid_CleanUpMail) ||
	(iParentId == cid_CleanupAppointment) Then
		let hwndTmp = GetPriorWindow (GetParent (GlobalFocusWindow))
		let sWindowText = GetWindowText (hwndTmp, READ_EVERYTHING)
		SayControlExWithMarkup (globalFocusWindow, sWindowText, cscNull, cscNull, GetGroupBoxName ())
		;;;TrcExit("SayFocusedWindow12")
		Return
	EndIf
EndIF

If (TheWindowName == wn_SendOption) &&
(GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) &&
(iControlId == cid_EditSpinBox) Then
	SayObjectTypeAndText ()
	SayFormattedMessage (OT_NO_DISABLE, GetWindowText (GetNextWindow (GetParent (GlobalFocusWindow)), READ_EVERYTHING), cmsgSilent )
	;;;TrcExit("SayFocusedWindow13")
	Return
EndIf

If StringContains (TheWindowName, wn_DocumentSetup ) &&
(GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) &&
(iControlId == cid_EditSpinBox) Then
	; announces the prompt for the edit spinBox in the Property dialogue
	let hwndTmp = GetPriorWindow (GetParent (GlobalFocusWindow))
	SayControlExWithMarkup (globalFocusWindow, GetWindowText (hwndTmp, READ_EVERYTHING), cscNull, cscNull, GetGroupboxName ())
	;;;TrcExit("SayFocusedWindow14")
	Return
EndIf

If (TheWindowName == wn_DateTimeOptions ) Then
; Announces prompts that are not spoken by default within the Date Time Options dialogue.
; Announce the correct prompts for the spin boxes that are found in the Busy dialogue or calendar page.
	If (GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) Then
		If (iParentId == cid_BusyHourSpinBox) ||
		(iParentId == cid_CalendarHourSpinBox) ||
		(iParentId == cid_CalendarMinuteSpinBox) ||
		(iParentId == cid_BusyMinuteSpinBox) Then
			let hwndTmp = GetPriorWindow (GetParent (GlobalFocusWindow))
			SayControlExWithMarkup (globalFocusWindow, GetWindowText (hwndTmp, READ_EVERYTHING), cscNull, cscNull, getGroupBoxName ())
			;;;TrcExit("SayFocusedWindow15")
			Return
		ElIf (iParentId == cid_BusyDaySpinBox) Then
			SayObjectTypeAndText ()
			SayFormattedMessage (OT_NO_DISABLE, GetWindowText (GetNextWindow (GetParent (GlobalFocusWindow)), READ_EVERYTHING), cmsgSilent )
			;;;TrcExit("SayFocusedWindow16")
			Return
		elIf (iParentId == cid_CalendarAlarmMinuteSpinBox) Then
			let hwndTmp = GetPriorWindow (GetParent (GlobalFocusWindow))
			let sWindowText = GetWindowText (hwndTmp, READ_EVERYTHING)
			SayControlExWithMarkup (globalFocusWindow, sWindowText, cscNull, cscNull, sGroupBox)
			SayFormattedMessage (OT_NO_DISABLE, GetWindowText (GetNextWindow (GetParent (GlobalFocusWindow)), READ_EVERYTHING), cmsgSilent )
			;;;TrcExit("SayFocusedWindow17")
			Return
		EndIf
	Elif (GetDialogPageName () == dpN_Calendar) Then
		If (iControlId >= cid_AppointmentColourCheckBox) &&
		(iControlId == cid_TaskColourCheckBox) Then
			let hwndTmp = FindDescendantWindow (GetParent (GlobalFocusWindow), cid_AppointmentColourCheckBox)
			let sWindowText = GetWindowText (GetPriorWindow (GetPriorWindow (GetPriorWindow (hwndTmp))), Read_Everything)
			let sWindowText = FormatString (GWMsgJoinString, GetWindowText (GetPriorWindow (GlobalFocusWindow), read_Everything), sWindowText)
			SayControlExWithMarkup (GlobalFocusWindow, sWindowText)
			;;;TrcExit("SayFocusedWindow18")
			Return
		ElIf (iControlid == cid_ReminderNoteLineCheckBox) ||
		(iControlId == cid_TaskLineCheckBox) Then
			let hwndTmp = FindDescendantWindow (GetParent (GlobalFocusWindow), cid_AppointmentColourCheckBox)
			let sWindowText = GetWindowText (GetPriorWindow (GetPriorWindow (hwndTmp)), Read_Everything)
			let sWindowText = FormatString (GWMsgJoinString, GetWindowText (GetPriorWindow (GetPriorWindow (GlobalFocusWindow)), read_Everything),sWindowText)
			SayControlExWithMarkup (GlobalFocusWindow, sWindowText)
			;;;TrcExit("SayFocusedWindow19")
			Return
		EndIf
	EndIf
EndIf

If (TheWindowName == wn_SecurityOptions)  Then
	; Announces prompts for the security Options dialogue.
	If (iParentid == cid_SecurityNameEdit) Then
		SayControlExWithMarkup (GlobalFocusWindow, GetWindowText (GetPriorWindow (GetParent (GlobalFocusWindow)), FALSE))
		;;;TrcExit("SayFocusedWindow20")
		Return
	ElIf (iControlId == cid_SecurityListView) Then
		SayControlExWithMarkup (GlobalFocusWindow, GetWindowText (GetPriorWindow (GlobalFocusWindow), FALSE))
		;;;TrcExit("SayFocusedWindow21")
		Return
	elIf (GetDialogPageName () == dpn_SecurityProxyAccess) Then
		If (iControlId == cid_ProxyAccessMailPhoneRead) ||
		(iControlId == cid_ProxyAccessAppointmentRead) ||
		(iControlId == cid_ProxyAccessReminderNoteRead) ||
		(iControlId == cid_ProxyAccessTaskRead) Then
			let sWindowText = FormatString (GWMsgJoinString, getWindowText (GetPriorWindow (GlobalFocusWindow), READ_EVERYTHING), getControlName ())
			SayControlExWithMarkup (GlobalFocusWindow, SWindowText)
			;;;TrcExit("SayFocusedWindow22")
			Return
		ElIf (iControlId == cid_ProxyAccessMailPhoneWrite) ||
		(iControlId == cid_ProxyAccessAppointmentWrite) ||
		(iControlId == cid_ProxyAccessReminderNoteWrite) ||
		(iControlId == cid_ProxyAccessTaskWrite) Then
			let sWindowText = FormatString (GWMsgJoinString, getWindowText (GetPriorWindow (GetPriorWindow (GlobalFocusWindow)), READ_EVERYTHING), getControlName ())
			SayControlExWithMarkup (GlobalFocusWindow, SWindowText)
			;;;TrcExit("SayFocusedWindow23")
			Return
		EndIf
	EndIf
EndIf

If (TheWindowName == wn_FindDialogue) Then
;Checks to see if the find dialogue is opened (not the find text dialogue).
	Find55Dialogue ()
EndIf

;Checks to see if the control id is the edit control in the multi-user list dialog.
If (iControlId == CID_MultiUserListEdit) then
	if (iParentId == CID_MultiUserListNCC) then 
		SayControlExWithMarkup ( hwndControl, 
				GetWindowText (FindDescendantWindow (
					GetRealWindow (hwndControl), CID_MultiUserListName), Read_Everything))
		return;
	Endif
EndIf

;Checks to see if the control id is the edit control in the multi-user list dialog.
If (iControlId == CID_CategoriesList) then  
	SayControlExWithMarkup ( hwndControl, 
			GetWindowText (FindDescendantWindow (
				GetRealWindow (hwndControl), CID_CategoriesListLabel), Read_Everything))
	return;
EndIf

;Checks to see if the control id is the List control in the multi-user list dialog.
If (iControlId == CID_MultiUserListCheck) then  	;OnFocus
	SayWindowTypeAndText(GetFocus())
	SayLine()
	return;
EndIf


;Check if the focus is in Header Control in the Address Selector Dialog
If iControlId == CID_HEADER Then
	SayFocusedObject ()
	SayFormattedMessage (OT_help, cmsg6_L+msgButton)
	return
EndIf

;If the focus changes to the properties list in the Advanced tab of
;Contact Details (Address Selector Dialog), forget the last focused item. 
;In this way JAWS will say the list (SayFocusedObject()) and the item in the list
If (GetWindowTypeCode(GetParent(GlobalFocusWindow)) == WT_LISTVIEW) && (iControlId == CID_POPUP_EDIT) Then
	If (!bSayFocusWindowSameAsLast) Then
		SayFocusedObject ()
		let g_iLastFocusedItem = 0
		return
	EndIf
EndIf

;Save the firs Item of the "To:" Field in the MailBox Dialog
If( GetControlId(GetCurrentWindow() ) == Cid_UsersToListBox && sCurrentWnd == WCN_GWABListFrame10 ) Then	  
  Let g_sFirstItemList=GetWindowText( GetFocus(), TRUE)
  SayString(g_sFirstItemList)
  return
EndIf

if (sParentClassName == WCN_DAYTIME) Then
	
	;Say the group text before to enter to edit box,  Date Diffeference Dialog 
	If ( GetWindowName(GetRealWindow (GetFocus())) == WN_DATEDIFFERENCE && iControlId == CID_DTDIFF_EDIT_DATE ) Then
				SayWindowTypeAndText(GetPriorWindow(GetParent(GetFocus())))
	
	;Say the name of the button, Auto-Date Dialog
	elif ( GetWindowName(GetRealWindow (GetFocus()) ) == WN_AUTODATE) Then
			if (GetTextInWindow(GetPriorWindow(hwndParent)) == "Start:") then
				SayFormattedMessage(OT_NO_DISABLE,  msgStartDate)
			elif (GetTextInWindow(GetPriorWindow(hwndParent)) == "End") then
				SayFormattedMessage(OT_NO_DISABLE,  msgEndDate)
			endif
			if ( iControlId == DTMBTN_ID ) then
				IndicateControlType(WT_BUTTON)
			elif ( iControlId == DTMEDIT_ID ) then
				IndicateControlType(WT_EDIT)
			endif
			return
	endif

endif

;Adding a message for button in Set Date Dialog  
If(GetWindowName(GetParent(GetFocus())) == WN_SetDate) then
	if (iControlId ==CID_PrevMonth) then 
		SayControlExWithMarkup(GetFocus(),msgPreviousMonth)
	elif (iControlId ==CID_PrevYear) then
		SayControlExWithMarkup(GetFocus(),msgPreviousYear)
	elif (iControlId == CID_NextMonth) then
		SayControlExWithMarkup(GetFocus(),msgNextMonth)		
	elif (iControlId == CID_NextYear) then
		SayControlExWithMarkup(GetFocus(),msgNextYear)
	elif (iControlId == CID_Today) then
		SayWindowTypeAndText(GetFocus())
		SayFormattedMessage (OT_help, msgButton)	
    else 			
	   SayFocusedWindow()
	endIf
	return
Endif

if(GetWindowName(GetRealWindow (GetFocus()) ) == WN_MAILBOX_SIZE_INFO && iControlId == IDC_DSM_MAILBOX_INFO) then
		var 
			handle hwndCurrentSizeText,
			handle hwndStorageLimitText,
			handle hwndExceededLimitText
		let hwndCurrentSizeText = FindWindowWithClassAndId(hwndParent,"Static",IDC_DSM_CURRENT_SIZE_TEXT)
		SayControlEx(hwndCurrentSizeText,"","","","","","","","")
		SayControlEx(GetNextWindow(hwndCurrentSizeText),"","",""," ","","","","")
		let hwndStorageLimitText = FindWindowWithClassAndId(hwndParent,"Static",IDC_DSM_STORAGE_LIMIT_TEXT)
		SayControlEx(hwndStorageLimitText,"","",""," ","","","","")
		SayControlEx(GetNextWindow(hwndStorageLimitText),"","",""," ","","","","")
		let hwndExceededLimitText = FindWindowWithClassAndId(hwndParent,"Static",IDC_DSM_EXCEEDED_LIMIT_TEXT)
		if (IsWindowVisible(hwndExceededLimitText)) then
			SayControlEx(hwndExceededLimitText,"","",""," ","","","","")
			SayControlEx(GetNextWindow(hwndExceededLimitText),"","",""," ","","","","")
		endif
		SayFormattedMessage(OT_NO_DISABLE,  msgMoveToNextControl)
		return
endif

;Message for Edit Categories Color panel dialog, to identify and name colors from palette
If((sControlClassName == WCN_TOOLBARCLASSNAME)       && ;;; ControlClassName
   (GetWindowTypeCode(hwndControl) == WT_TOOLBAR)    && ;;; Type code
   (GetWindowSubTypeCode(hwndControl) == WT_TOOLBAR) && ;;; Subtype code
   (sParentClassName == WCN_Dialog)                  && ;;; ParentClass
   (GetWindowTypeCode(hwndParent) == WT_DIALOG)      && ;;; ParentType code
   (GetWindowSubTypeCode(hwndParent) == WT_DIALOG)   && ;;; ParentSubType code
   (GetWindowClass(GetRealWindow(hwndControl)) == WCN_Dialog) && ;;; RealClass name
   (GetItemCount(hwndControl) == iStaticColorMax)) then
      SayFormattedMessage (OT_NO_DISABLE, "Color ")
      SayFormattedMessage (OT_NO_DISABLE, GetColorName(GetColorAtPoint(GetCursorCol(), GetCursorRow())))
      SayFormattedMessage (OT_NO_DISABLE, " selected")
      ;;;TrcExit("SayFocusedWindow24")
      Return
Endif

;Message for Speak colors in checkbox buttons, this would identify and name colors
If((sAppTitle  == "Options") &&
   (iControlId == IDC_CBC_ADE_BKG_COLOR || iControlId == IDC_CBC_APPT_BKG_COLOR ||
    iControlId == IDC_CBC_NOTE_BKG_COLOR || iControlId == IDC_CBC_TODO_BKG_COLOR) &&
   (sControlClassName == WCN_BUTTON)                 && ;;; ControlClassName
   (GetWindowTypeCode(hwndControl) == WT_BUTTON)     && ;;; Type code
   (GetWindowSubTypeCode(hwndControl) == WT_BUTTON)  && ;;; Subtype code
   (sParentClassName == WCN_Dialog)                  && ;;; ParentClass
   (GetWindowTypeCode(hwndParent) == WT_DIALOG)      && ;;; ParentType code
   (GetWindowSubTypeCode(hwndParent) == WT_DIALOG_PAGE)       && ;;; ParentSubType code
   (GetWindowClass(GetRealWindow(hwndControl)) == WCN_Dialog) && ;;; RealClass name
   (GetItemCount(hwndControl) == -1)) then
      SayFormattedMessage (OT_NO_DISABLE, "Color ")
      SayFormattedMessage (OT_NO_DISABLE, GetColorName(GetColorAtPoint(GetCursorCol(), GetCursorRow())))
      SayFormattedMessage (OT_NO_DISABLE, " selected")
      ;;;TrcExit("SayFocusedWindow25")
Endif

If (iControlId == CID_BrowseForFolder
	&&	GetDialogPageName() == WN_FILE_LOCATION
	&&	GetWindowName(GetRealWindow(GetFocus())) == WN_ENVIRONMENT) Then
		SayFormattedMessage(OT_NO_DISABLE,  msgBrowseFolder)
		IndicateControlType(WT_BUTTON)
   	return
EndIf

If (GetWindowName(GetRealWindow(GetFocus())) == WN_ALARM
		&& iControlId == CID_BrowseForFolder) Then		
			SayFormattedMessage(OT_NO_DISABLE,  msgSelectFile)
			IndicateControlType(WT_BUTTON)
			return
EndIf

If (iControlId == CID_BrowseForFolder
	&&	GetDialogPageName() == WN_SIGNATURE
	&&	GetWindowName(GetRealWindow(GetFocus())) == WN_ENVIRONMENT) Then
		SayFormattedMessage(OT_NO_DISABLE,  msgSelectFile)
		IndicateControlType(WT_BUTTON)
   	return
EndIf



;;;OutputDebugString("--SayFocusedObject")
SayFocusedObject ()
;;;TrcExit("SayFocusedWindow0")
EndFunction

Script SayNextLine ()
Var
	String sClass,
	String sRealWnd,
	Int iTypecode,
	int iControlId

let sClass = GetWindowClass (GlobalFocusWindow)
let ITypeCode = GetWindowTypeCode (globalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
let sRealWnd = GetWindowClass (GetRealWindow (GLobalFocusWindow))

If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (iTypeCode == WT_ListView) Then
		NextLine ()
		SayLine ()
		return
	endIf ;(TheTypeCode == WT_ListView)
	;Announce the New date when focus is on the Calendar in the Day Calendar view.
	If (GetAppTitle () == wn_Daywindow || GetAppTitle () == WN_MainGWCalendarWindow) Then 
		NextLine ()
		If (sClass == WCN_Calendar || sClass == WCN_CalendarPane) Then 
			SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		EndIf
		Return
	EndIf
	If (sClass == WCN_TimeCalendarGrid ) then
		if (GWVersion <= 600) then
			if (GetDialogPageName () == ssc3) Then
				NextLine ()
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (FALSE))
				Return
			endif
		else
			NextLine()
			if (iControlId == CID_CAT_AVL_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_TIME | SBI_SAY_FREEBUSY )
			elif (iControlId == CID_CAT_IND_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_RECIPIENT | SBI_SAY_FREEBUSY)
			endif
			return
		Endif
	EndIf
	If (GetWindowTypeCode(GetParent(GlobalFocusWindow)) == WT_LISTVIEW) && (iControlId == CID_POPUP_EDIT) Then
		If (SayItemInContactPropertiesList(GlobalFocusWindow)==FALSE) Then
			NextLine()
			Return
		EndIf
	EndIf
	If ((GetControlId(GlobalFocusWindow) == CID_BOOKSELECT) && (GetWindowName(GetRealWindow(GlobalFocusWindow)) == "Address Selector")) Then
		NextLine()
		Delay(2)
		SayMessage (OT_POSITION, PositionInGroup ())
		return
	EndIf
EndIf

If (iControlId == CID_MultiUserListCheck) then
SayFormattedMessage(OT_help,MSG_LISTCHECK)
EndIf

; Say every Contact within the TO: field in the Mail Box 
If( (GetControlId(GetCurrentWindow() ) == Cid_UsersToListBox) &&  (sRealWnd == WCN_GWABListFrame10 ) ) Then
	NextLine()
   SayString(GetWindowText( GetFocus(), TRUE)) 
	return
EndIf

PerformScript SayNextLine()
EndScript

Script SayPriorLine()
Var
	String TheClass,
	String sRealWnd,
	Int TheTypecode,
	int iControlId

;Let TheClass = GetWindowClass (GetParent (GlobalFocusWindow))
let TheClass = GetWindowClass (GlobalFocusWindow)
let TheTypeCode = GetWindowTypeCode (globalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
let  sRealWnd = GetWindowClass (GetRealWindow (GLobalFocusWindow))

If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (TheTypeCode == WT_ListView) Then
		PriorLine ()
		SayLine ()
			Return
	endIf ;(TheTypeCode == WT_ListView)
	If (GetAppTitle ()== wn_Daywindow || GetAppTitle () == WN_MainGWCalendarWindow) Then 
		PriorLine ()
		If (GetWindowclass (GetFocus ()) == WCN_Calendar || GetWindowclass (GetFocus ()) == WCN_CalendarPane) Then 
			SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		EndIf
		Return
	EndIf
	If (TheClass == WCN_TimeCalendarGrid) then
		if (GWVersion <= 600) then
			if (GetDialogPageName () == ssc3) Then
				PriorLine ()
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (FALSE))
				Return
			endif
		else
			PriorLine()
			if (iControlId == CID_CAT_AVL_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_TIME | SBI_SAY_FREEBUSY )
			elif (iControlId == CID_CAT_IND_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_RECIPIENT | SBI_SAY_FREEBUSY)
			endif
			Return		
		endif
	EndIf
	If (GetWindowTypeCode(GetParent(GlobalFocusWindow)) == WT_LISTVIEW) && (iControlId == CID_POPUP_EDIT) Then
		If (SayItemInContactPropertiesList(GlobalFocusWindow)==FALSE) Then
			PriorLine()
			Return
		EndIf
	EndIf
	If ((GetControlId(GlobalFocusWindow) == CID_BOOKSELECT) && (GetWindowName(GetRealWindow(GlobalFocusWindow)) == "Address Selector")) Then
		PriorLine()
		Delay(2)
		SayMessage (OT_POSITION, PositionInGroup ())
		return
	EndIf
EndIf

If (iControlId == CID_MultiUserListCheck) then
SayFormattedMessage(OT_help,MSG_LISTCHECK)
EndIf

; Say every name within "To"  Field in Mail Box
If( GetControlId(GetCurrentWindow() ) == Cid_UsersToListBox  && sRealWnd == WCN_GWABListFrame10 ) Then	
      If( GetWindowText( GetFocus(), TRUE) == g_sFirstItemList) Then
  			PerformScript SayPriorLine()      
			return 		
		else
			PriorLine()
	   		SayString(GetWindowText( GetFocus(), TRUE))      
			return    
		Endif
EndIf

PerformScript SayPriorLine()
EndScript

Script JawsPageDown ()
Var
	String TheClass,
	String RealWindowClass,
	Int TheTypecode

let TheClass = GetWindowClass (GetParent (GlobalFocusWindow))
let RealWindowClass = GetWindowClass (GetRealWindow (GlobalFocuswindow))
let TheTypeCode = GetWindowTypeCode (globalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (TheTypeCode == WT_ListView) Then
		JawsPageDown ()
		SayLine ()
		Return
	endIf ;(TheTypeCode == WT_ListView)
	If (GetAppTitle ()== wn_Daywindow || GetAppTitle () == WN_MainGWCalendarWindow) Then 
		JAWSPageDown ()
		If (GetWindowclass (GetFocus ()) == WCN_Calendar || GetWindowclass (GetFocus ()) == WCN_CalendarPane) Then 
			SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		EndIf
		Return
	EndIf
	If (RealWindowClass == WCN_MailWindow) ||
	(RealWindowClass == WCN_TaskWindow) ||
(RealWindowClass == WCN_PhoneWindow) ||
(RealWindowClass == WCN_AppointmentWindow) ||
(RealWindowClass == WCN_NoteWindow) Then
				JawsPageDown ()
		SayFormattedMessageBoxWindow ()
		Return
	endIf
EndIf
PerformScript JawsPageDown ()
EndScript

Script JawsPageUP ()
Var
	String TheClass,
	String RealWindowClass,
	Int TheTypecode

let TheClass = GetWindowClass (GetParent (GlobalFocusWindow))
let RealWindowClass = GetWindowClass (GetRealWindow (GlobalFocuswindow))
let TheTypeCode = GetWindowTypeCode (globalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (TheTypeCode == WT_ListView) Then
		JawsPageup ()
		SayLine ()
		Return
	endIf ;(TheTypeCode == WT_ListView)
	If (GetAppTitle ()== wn_Daywindow || GetAppTitle () == WN_MainGWCalendarWindow) Then 
		JAWSPageUp ()
		If (GetWindowclass (GetFocus ()) == WCN_Calendar || GetWindowclass (GetFocus ()) == WCN_CalendarPane) Then 
			SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		EndIf
		Return
	EndIf
If (RealWindowClass == WCN_MailWindow) ||
(RealWindowClass == WCN_TaskWindow) ||
(RealWindowClass == WCN_PhoneWindow) ||
(RealWindowClass == WCN_AppointmentWindow) ||
(RealWindowClass == WCN_NoteWindow) Then
		JawsPageUp ()
		SayFormattedMessageBoxWindow ()
		Return
	endIf
EndIf
PerformScript JawsPageUp()
EndScript

Script SayNextCharacter ()
Var
	String TheClass,
	Int CursorType,
	int iControlId

let TheClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (GetAppTitle () == wn_Daywindow || GetAppTitle () == WN_MainGWCalendarWindow) Then 
		NextCharacter ()
		SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		Return
	EndIf
	If (TheClass == WCN_TimeCalendarGrid) Then
		NextCharacter ()
		If (GWVersion < 600) then
			If (GetDialogPageName () == DPN_AvailableTime) Then
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TRUE))
			Else
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (FALSE))
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TrUE))
			EndIf
			Return
		else
			if (iControlId == CID_CAT_AVL_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_DATE | SBI_SAY_FREEBUSY)
			elif (iControlId == CID_CAT_IND_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_CHANGED_DATE | SBI_SAY_TIME | SBI_SAY_FREEBUSY )
			endif
			Return
		endif
	EndIf
	If (Theclass == WCN_AttachmentWindow) Then
		SaveCursor ()
	let CursorType = GetActiveCursor ()
	RestrictCursor (On)
	RouteJAWSToPc ()
	JawsCursor ()
	NextChunk ()
	LeftMouseButton ()
	RestrictCursor (Off)
	RestoreCursor ()
	SetActiveCursor (CursorType)
	EndIf
endIf
PerformScript SayNextCharacter()
EndScript

Script SayPriorCharacter ()
Var
	Int Cursortype,
	String TheClass,
	int iControlId

let TheClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (GetAppTitle () == wn_DayWindow || GetAppTitle () == WN_MainGWCalendarWindow) Then 
		PriorCharacter ()
		SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		Return
	EndIf
	If (TheClass == WCN_TimeCalendarGrid) Then
		PriorCharacter ()
		if (GWVersion < 600) Then
			If (GetDialogPageName () == ssc3) Then
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TRUE))
			Else
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (FALSE))
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TRUE))
			EndIf
			Return
		else
			if (iControlId == CID_CAT_AVL_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_DATE | SBI_SAY_FREEBUSY)
			elif (iControlId == CID_CAT_IND_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_CHANGED_DATE | SBI_SAY_TIME | SBI_SAY_FREEBUSY )
			endif
			Return
		endif
	EndIf
	If (TheClass == WCN_AttachmentWindow) Then
		SaveCursor ()
	let CursorType = GetActiveCursor ()
	RestrictCursor (On)
	RouteJAWSToPc ()
	JawsCursor ()
	PriorChunk ()
	LeftMouseButton ()
	RestrictCursor (off)
	RestoreCursor ()
	SetActiveCursor (CursorType)
	EndIf
endIf
PerformScript SayPriorCharacter()
EndScript

Script SayCharacter ()
Var
	Int Cursortype,
	String TheClass,
	int iControlId

let TheClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (GetAppTitle () == wn_DayWindow || GetAppTitle () == WN_MainGWCalendarWindow) Then 
		SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		Return
	EndIf
	If (TheClass == WCN_TimeCalendarGrid) Then
		if (GWVersion < 600) then
			If (GetDialogPageName () == ssc3) Then
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TRUE))
			Else
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (FALSE))
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TRUE))
			EndIf
			Return
		else
			SayBusyInfo( iControlId, SBI_SAY_ALL );
			return
		endif
	EndIf
endIf
PerformScript SayCharacter()
EndScript

Script JawsHome ()
Var
	int TheTypeCode
let TheTypeCode = GetWindowTypeCode (globalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (TheTypeCode == WT_ListView) Then
		JawsHome ()

		SayLine ()
		Return
	endIf ;(TheTypeCode == WT_ListView)
EndIf
PerformScript JawsHome ()
EndScript

Script JawsEnd ()
Var
	int TheTypeCode

let TheTypeCode = GetWindowTypeCode (globalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (TheTypeCode == WT_ListView) Then
		JawsEnd ()
		SayLine ()
			Return
		endIf ;(TheTypeCode == WT_ListView)
EndIf
PerformScript JawsEnd ()
EndScript

Script ScreenSensitiveHelp ()
; to respect the new AppFileTopic differences
If (IsSameScript ()) then
	AppFileTopic (topic_Groupwise)
	Return
EndIf
If (GetWindowClass(GlobalFocusWindow) == WCN_TimeCalendarGrid ) then
	var string sMessageLong,
		string sMessageShort
	if (GetControlId(GlobalFocusWindow) == CID_CAT_AVL_GRID) then
		let sMessageLong = FormatString( msgSSH_AvailGrid_L )
		let sMessageShort = FormatString( msgSSH_AvailGrid_S )
	else
		let sMessageLong = FormatString( msgSSH_DetailGrid_L )
		let sMessageShort = FormatString( msgSSH_DetailGrid_S )
	endif
	SayFormattedMessage( ot_User_Buffer, sMessageLong, sMessageShort )
	Return
endif

PerformScript ScreenSensitiveHelp ()
EndScript

Script SayWindowPromptAndText ()
var
	handle hWnd,
	int iSubType,
	int nMode
Let hWnd = GetCurrentWindow ()
Let iSubType = GetWindowSubTypeCode (hWnd)
If ! iSubType then
	Let iSubType = GetObjectSubTypeCode ()
EndIf
let nMode=smmTrainingModeActive()
smmToggleTrainingMode(TRUE)
SayFocusedWindow ()
SayTutorialHelp (iSubType, TRUE)
SayTutorialHelpHotKey (hWnd, TRUE)
smmToggleTrainingMode(nMode)
EndScript

Function SayCalendarDate ()
;;;TrcEnter("SayCalendarDate")
SayFormattedMessage (ot_control_name, MSG_Prompt12_L) ;MSG_Prompt12_L "Date: "
SayFormattedMessage (ot_no_disable, GetCalendarViewDate  ())
;;;TrcExit("SayCalendarDate")
EndFunction

Script ReplyToMessage ()
SpeechOff ()
TypeKey (ks12)
TypeKey (ks13)
SpeechOn ()
EndScript
Script ForwordMail ()
SpeechOff ()
TypeKey(ks12)
TypeKey (ks14)
SpeechOn ()
EndScript

Script ScriptFileName ()
ScriptAndAppNames(msgScriptKeyHelp1_L)
EndScript

Void Function GeneralGroupwiseHelp ()
If UserBufferIsActive () then
	UserBufferDeactivate ()
EndIf
	SayFormattedMessage (ot_USER_BUFFER, msgHotKeyHelp1_L, msgHotKeyHelp1_S)
EndFunction

Script msgHotKeyHelp ()
If Not DialogActive () Then
	GeneralGroupwiseHelp ()
	Return
EndIf
msgHotKeyHelpDefault ()
EndScript

Script MoveToNextMessage ()
TypeKey (ks15) ;moves to the next message.
EndScript

Script MoveToPriorMessage ()
TypeKey (ks16) ;moves to the prior message.
EndScript

Script WindowKeysHelp  ()
Var
	String RealWindowClass

let RealWindowClass = GetWindowClass (GetRealWindow (GlobalFocuswindow))
If UserBufferIsActive () then
	UserBufferDeactivate ()
EndIf
If (RealWindowClass == WCN_MailWindow) ||
(RealWindowClass == WCN_TaskWindow) ||
(RealWindowClass == WCN_PhoneWindow) ||
(RealWindowClass == WCN_AppointmentWindow) ||
(RealWindowClass == WCN_NoteWindow) Then
	SayFormattedMessage (ot_USER_BUFFER, msgWindowKeysHelp1_L, msgWindowKeysHelp1_S)
	Return
EndIf
If (RealWindowclass == WCN_MainWindow) Then
	SayFormattedMessage (ot_USER_BUFFER, msgWindowKeysHelp2_L, msgWindowKeysHelp2_S)
	Return
endIf
WindowKeysHelpDefault ()
endScript

Script AutoSelect ()
TypeCurrentScriptKey ()
Pause() ; !!Let GroupWIse process the button and update the screen text.  Otherwise, JAWS speaks old information.
If (GetWindowName (GetRealWindow (GlobalFocusWindow)) == wn_ChooseAppointmentTime) Then
	if (GWVersion < 600) then
		SayFormattedMessage (ot_no_disable, GetBusyAppointmentDateTime (TRUE))
		SayFormattedMessage (ot_no_disable, GetBusyAppointmentDateTime (FALSE))
		Return
	else
		var int iControlId
		let iControlId = GetControlId(GlobalFocusWindow)
		SayBusyInfo( iControlId, SBI_SAY_TIME | SBI_SAY_CHANGED_DATE | SBI_SAY_FREEBUSY )
		return
	endif
endIf
EndScript


Script DelegateMessage ()
SpeechOff ()
TypeKey(ks12)
TypeKey(ks10)
SpeechOn ()
EndScript

Script MoveMessageToFolder ()
SpeechOff ()
TypeKey (ks20)
TypeKey (ks21)
SpeechOn ()
EndScript

Script JawsDelete ()
Var
	String TheClass,
	int TheTypeCode,
	handle hwnd

let hwnd = GetFocus()
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
let TheClass = GetWindowClass (GetParent (getCurrentwindow ()))
If (TheTypeCode == WT_ListView) Then
	TypeKey (ks22)
	Delay (2)
	SayLine ()
	Return
EndIf
If (GetWindowclass (globalFocusWindow) == WCN_QUICKVIEWER) Then
TypeKey(ks22)
	Delay (5)
	SayFormattedMessageBoxWindow ()
	Return
endIf

; GWHdrCtl's have window class "GWHdrCtl" or have a parent that is "GWHdrCtl"
	if (GetWindowClass(hwnd) == WCN_GWHDRCTL) || (GetWindowClass(GetParent(hwnd)) == WCN_GWHDRCTL) then
		if (GetControlId(hwnd) == CID_HDR_FILTER_EDITBOX_CTLID) then
			PerformScript JAWSDelete()
			Delay (1)
			var
				string strCurrentSearchCriteria
			let strCurrentSearchCriteria = GetTextInWindow(hwnd)
			if (StringLength(strCurrentSearchCriteria) == 0) then
				Delay(7)
				if (!IsWindowVisible(FindWindow(hwnd,"OWL_Window"))) then
					SayFormattedMessage(OT_NO_DISABLE, msgFilterCleared)
				else
					SayFormattedMessage(OT_NO_DISABLE, msgClearFilter)
				endif
				let g_strLastSearchCriteria = ""
			endif
			return
		endif
	endif

PerformScript JawsDelete()
EndScript

function ScreenSensitiveHelpForKnownClasses (Int WinTypeCode)
If UserBufferIsActive () then
	UserBufferDeactivate ()
EndIf
If (GetWindowClass (GetParent (GetCurrentWindow ())) == WCN_PopupButton) Then
	SayFormattedMessage (ot_USER_BUFFER, msgScreenSensitiveHelp1_L, msgScreenSensitiveHelp1_S)
	AddHotKeyLinks ()
	Return
EndIf
ScreenSensitiveHelpForKnownClasses (WinTypeCode)
EndFunction

Script RecipientFocus ()
Var
	int PriorCursor,
	String RealWindowClass

let RealWindowClass = GetWindowClass (GetRealWindow (GlobalFocuswindow))
If (RealWindowClass == WCN_MailWindow) ||
(RealWindowClass == WCN_FrameListBox) ||
(RealWindowClass == WCN_TaskWindow) ||
(RealWindowClass == WCN_PhoneWindow) ||
(RealWindowClass == WCN_AppointmentWindow) ||
(RealWindowClass == WCN_NoteWindow) Then
	If (GetWindowClass (GlobalFocusWindow) == WCN_Edit) ||
	(GetWindowClass (GlobalFocusWindow) == WCN_NewListbox10) Then
		let PriorCursor = GetActiveCursor ()
		SaveCursor ()
		If (GetWindowClass (GlobalFocusWindow) != WCN_NewListbox10) Then
			RouteInvisibleToPc ()
			RouteJAWSToInvisible ()
			InvisibleCursor ()
			NextLine ()
			;Checks to see if the recipient list box is present.
			If (GetWindowClass (GetCurrentWindow ()) == WCN_NewListbox10) Then
				;Moves the focus to the recipient list box.
				SetFocus (GetCurrentWindow ())
			Else
				SayFormattedMessage (OT_error, Msg1_L, Msg1_S) ;Msg1_L "Recipient list box not found."
		endIf
		Else
			RouteInvisibleToJaws ()
			InvisibleCursor ()
			SetFocus (GetCurrentWindow ())
		endIf
		RestoreCursor ()
		SetActiveCursor (PriorCursor)
	EndIf
endIf
EndScript

Int Function SaveApplicationSettings ()
Var
	int iReturn

let iReturn = IniWriteInteger (Section_ApplicationVerbositySettings, hKey_ColumnLabels, iToggleColumnLabelReading, jsiFileName)
let iReturn = IniWriteInteger (Section_ApplicationVerbositySettings, hKey_QuickView, iToggleQuickViewReading	, jsiFileName)
let iReturn = IniWriteInteger (Section_ApplicationVerbositySettings, hKey_ReadMessage, iTogglePageReading, jsiFileName)
return iReturn
EndFunction

String Function ToggleColumnLabelReading (int iRetCurVal)
if not iRetCurVal then
	;update the value
	let iToggleColumnLabelReading=!iToggleColumnLabelReading
EndIf
If iToggleColumnLabelReading Then
	return MSG_ON	; Column Labels Read
else
	return MSG_OFF	; Column Labels Not Read
EndIf
EndFunction

string function TogglePageReading (int iRetCurVal)
if not iRetCurVal then
	;update the value
	let iTogglePageReading=!iTogglePageReading
EndIf
If iTogglePageReading Then
	return Msg2_S	;announce the whole message window.
else
	return Msg3_S	;anounce lines only.
EndIf
EndFunction

string function ToggleQuickView (int iRetCurVal)
if not iRetCurVal then
	;update the value
	let iToggleQuickViewReading=!iToggleQuickViewReading
EndIf
If iToggleQuickViewReading Then
	return MSG5_S
else
	return MSG6_S
endIf
EndFunction

Script AdjustJAWSVerbosity ()
var
	string list,
	int PrevQuickView,
	int PrevMessageRead,
	int PrevColumnLabelRead

if InHJDialog () then
	SayFormattedMessage (ot_error, cMSG337_L)
	return
endIf
if (IsSpeechOff ()) then
	PerformScript MuteSynthesizer()
	return
endif
;Store the current settings to compare after the verbosity dlg has closed.
let prevQuickView = iToggleQuickViewReading
let PrevMessageRead = iTogglePageReading
let PrevColumnLabelRead = iToggleColumnLabelReading

let list = StrGrpwiseVerbosityItems + cStrDefaultList() 
DlgSelectFunctionToRun (list, AdjustJawsVerbosityDialogName, false)
If (PrevMessageRead != iTogglePageReading) ||
   (PrevQuickView != iToggleQuickViewReading) ||
   (PrevColumnLabelRead != iToggleColumnLabelReading) Then
	if saveApplicationSettings() then
		SayFormattedMessage (ot_jaws_message, msgAppSettingsSaved1_L, cmsgSilent)
	else
		SayFormattedMessage (ot_error, msgAppSettingsNotSaved1_L, cmsgSilent)
	endIf
EndIf
EndScript

Script RightMouseButton ()
SayFormattedMessage (OT_status, cmsg151_L) ;"right mouse button"
If IsPCCursor () Then
	SaveCursor ()
	RouteJawsToPc ()
	JawsCursor ()
	RightMouseButton ()
	RestoreCursor ()
	PcCursor ()
	Return
EndIf
RightMouseButton()
EndScript

Script downcell ()
If (GetWindowClass (GetRealWindow (globalFocuswindow)) ==	WCN_MainWindow) &&
(GetWindowTypeCode (GlobalFocusWindow) == WT_LISTVIEW) Then
	TypeKey (ks23)
	Delay (2)
	SayLine ()
Else
	PerformScript DownCell()
EndIf
EndScript

Script upcell ()
If (GetWindowClass (GetRealWindow (globalFocuswindow)) ==	WCN_MainWindow) &&
(GetWindowTypeCode (GlobalFocusWindow) == WT_LISTVIEW) Then
	TypeKey (ks24)
	Delay (2)
	SayLine ()
Else
	PerformScript DownCell()
EndIf
EndScript

Script QuickViewNextAttachment ()
If (GetWindowClass (globalFocusWindow) == WCN_QuickViewer) Then
	TypeKey (ks25)
		SayFormattedMessageBoxWindow ()
EndIf
EndScript

Script QuickViewNextMessage ()
If (GetWindowClass (globalFocusWindow) == WCN_QuickViewer) Then
	TypeKey (ks26)
	Delay (5)
	SayFormattedMessageBoxWindow ()
	Return
EndIf
PerformScript OpenListBox()

EndScript

Script QuickViewPriorMessage ()
If (GetWindowClass (globalFocusWindow) == WCN_QuickViewer) Then
	TypeKey (ks27)
	Delay (5)
	SayFormattedMessageBoxWindow ()
	Return
EndIf
PerformScript CloseListBox()
EndScript


Int Function BrailleAddObjectContainerName (int iSubTypeCode)
var
	int iReturnValue,
	string sWindowName,
	int iControlId,
	int iParentControlId
;let sWindowName =GetWindowName (GetRealwindow (GlobalFocuswindow)) ;assigns the window name to variable
;let iControlId = getControlId (GlobalFocusWindow)
;let iParentControlId = getControlId (GetParent (GlobalFocusWindow))
; displays the correct groupBox for the edit spin boxes in the environment dialogue, contained within the Option dialogue.
;If (sWindowName == wn_Environment) &&
If (iSubTypeCode == WT_EDIT_SPINBOX) Then
	BrailleAddString (GetGroupBoxName (), 0, 0, 0)
	let iReturnValue = TRUE
else
	let iReturnValue = FALSE
EndIf
return iReturnValue
EndFunction


int Function BrailleAddObjectName (int iSubTypeCode)
var
	int iReturnValue,
	string sWindowText,
	handle hWnd,
	string sWindowName,
	int iControlId,
	int iParentControlId

let iParentControlId = getControlId (GetParent (GlobalFocusWindow))
let sWindowName =GetWindowName (GetRealwindow (GlobalFocuswindow)) ;assigns the window name to variable
let iControlId = getControlId (GlobalFocusWindow)
; displays the correct prompt for the edit spin boxes in the environment dialogue, contained within the Option dialogue.
If (sWindowName == wn_Environment) &&
(iSubTypeCode == WT_EDIT_SPINBOX) Then
	If (iParentControlId == cid_GeneralRefreshMins) ||
	(iParentControlId == cid_GeneralRefreshSecs) Then
		let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
		let sWindowText = GetWindowText (hWnd, READ_EVERYTHING)
		let hWnd = FindDescendantWindow (GetParent (Hwnd), cid_GeneralRefreshStatic)
		let sWindowText = FormatString (GWMsgJoinString, GetWindowText (hWnd, Read_EveryThing), sWindowText)
		BrailleAddString (sWindowText, 0, 0, 0)
		let iReturnValue = TRUE
	elIf (iParentControlId == cid_CleanUpMail) ||
	(iParentControlId == cid_CleanupAppointment) Then
		let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
		BrailleAddString (GetWindowText (hWnd, READ_EVERYTHING), 0, 0, 0)
	let iReturnValue = TRUE
	EndIf
ElIf (sWindowName == wn_SecurityOptions) Then
	If (iParentControlid == cid_SecurityNameEdit) Then
		BrailleAddString (GetWindowText (GetPriorWindow (GetParent (GlobalFocusWindow)), FALSE), 0, 0, 0)
		let iReturnValue = True
	ElIf (iControlId == cid_SecurityListView) Then
		BrailleAddString (GetWindowText (GetPriorWindow (GlobalFocusWindow), FALSE), 0, 0, 0)
		let iReturnValue = True
	ElIf (GetDialogPageName () == dpn_SecurityProxyAccess) Then
		If (iControlId == cid_ProxyAccessMailPhoneRead) ||
		(iControlId == cid_ProxyAccessAppointmentRead) ||
		(iControlId == cid_ProxyAccessReminderNoteRead) ||
		(iControlId == cid_ProxyAccessTaskRead) Then
			let sWindowText = FormatString (GWMsgJoinString, getWindowText (GetPriorWindow (GlobalFocusWindow), READ_EVERYTHING), getControlName ())
			BrailleAddString (SWindowText, 0, 0, 0)
			let iReturnValue = True
		ElIf (iControlId == cid_ProxyAccessMailPhoneWrite) ||
		(iControlId == cid_ProxyAccessAppointmentWrite) ||
		(iControlId == cid_ProxyAccessReminderNoteWrite) ||
		(iControlId == cid_ProxyAccessTaskWrite) Then
			let sWindowText = FormatString (GWMsgJoinString, getWindowText (GetPriorWindow (GetPriorWindow (GlobalFocusWindow)), READ_EVERYTHING), getControlName ())
			BrailleAddString (SWindowText, 0, 0, 0)
			let iReturnValue = TRUE
		EndIf
EndIf
	ElIf (sWindowName == wn_DateTimeOptions ) Then
	; displays prompts that are not shown by default within the Date Time Options dialogue.
; display the correct prompts for the spin boxes that are found in the Busy dialogue or calendar page.
		If (GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) Then
		If (iParentControlId == cid_BusyHourSpinBox) ||
		(iParentControlId == cid_CalendarHourSpinBox) ||

(iParentControlId == cid_CalendarMinuteSpinBox) ||
		(iParentControlId == cid_BusyMinuteSpinBox) Then
			let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
			BrailleAddString (GetWindowText (hWnd, READ_EVERYTHING), 0, 0, 0)
			let iReturnValue = TRUE
		ElIf (iParentControlId == cid_BusyDaySpinBox) Then
			let sWindowText = FormatString (GWMSGJoinString, GetObjectName (), GetWindowText (GetNextWindow (GetParent (GlobalFocusWindow)), READ_EVERYTHING))
			BrailleAddString (sWindowText, 0, 0, 0)
			let iReturnValue = TRUE
		elIf (iParentControlId == cid_CalendarAlarmMinuteSpinBox) Then
			let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
			let sWindowText = GetWindowText (hWnd, READ_EVERYTHING)
			BrailleAddString (sWindowText, 0, 0, 0)
			let iReturnValue = TRUE
		EndIf
	Elif (GetDialogPageName () == dpN_Calendar) Then
		If (iControlId >= cid_AppointmentColourCheckBox) &&
		(iControlId == cid_TaskColourCheckBox) Then
			let hWnd = FindDescendantWindow (GetParent (GlobalFocusWindow), cid_AppointmentColourCheckBox)
			let sWindowText = GetWindowText (GetPriorWindow (GetPriorWindow (GetPriorWindow (hWnd))), Read_Everything)
			let sWindowText = FormatString (GWMsgJoinString, GetWindowText (GetPriorWindow (GlobalFocusWindow), read_Everything), sWindowText)
			BrailleAddString (sWindowText, 0, 0, 0)
			let iReturnValue = TRUE
		ElIf (iControlid == cid_ReminderNoteLineCheckBox) ||
		(iControlId == cid_TaskLineCheckBox) Then
			let hWnd = FindDescendantWindow (GetParent (GlobalFocusWindow), cid_AppointmentColourCheckBox)
			let sWindowText = GetWindowText (GetPriorWindow (GetPriorWindow (hWnd)), Read_Everything)
			let sWindowText = FormatString (GWMsgJoinString, GetWindowText (GetPriorWindow (GetPriorWindow (GlobalFocusWindow)), read_Everything),sWindowText)
		BrailleAddString (sWindowText, 0, 0, 0)
			let iReturnValue = TRUE
		EndIf
		EndIf
Else
	let iReturnValue = FALSE
EndIf
return iReturnValue
EndFunction

int Function BrailleAddObjectValue (int iSubTypeCode)
var
	int iReturnValue,
	int iParentControlId,
	handle hWnd

let iParentControlId = getControlId (GetParent (GlobalFocusWindow))
; Retrieve contents of the comboBox of the Classification Combobox in the Send dialogue, within the Option dialogue.
If (iParentControlId == cid_CLASSIFICATIONCOMBO) Then
	BrailleAddString (GetWindowText (GlobalFocusWindow, TRUE), 0, 0, 0)
	let iReturnValue = TRUE
Else
	let iReturnValue = False
EndIf
return iReturnValue
EndFunction

Script  DeleteWord()
; delete current word and speak the word the PC cursor lands on.
TypeCurrentScriptKey() ;pass it through, even if user applies keystroke in wrong situation
SaveCursor ()
PCCursor ()
Pause()
if CaretVisible() then
	SayWord()
else
	SayCurrentScriptKeyLabel ()
EndIf
RestoreCursor ()
EndScript

Script DeleteOpenItem()
; For 6.5.3 and later, "Alt+Delete" deletes the open item.
; However, it is also the key sequence for JAWS "SayActiveCursor".
; In GroupWise.jkm, the "Alt_Delete" sequence is routed to this routine.
; We simply pass it through to the application.
TypeCurrentScriptKey()
EndScript
;=======================================================================
;=======================================================================
; New functions for 6.5.3 go below here
;=======================================================================
;=======================================================================

int function HandleGWHdrCtl(handle hwndControl)
;;;TrcEnter("HandleGWHdrCtl")
var
	int iControlID,
	int iParentID,
	string sWCNControl,
	string sWCNParent,
	handle hwndParent

	let hwndParent = GetParent(hwndControl)
	let iControlID = GetControlID(hwndControl)
	let iParentID = GetControlID(hwndParent)
	let sWCNControl = GetWindowClass(hwndControl)
	let sWCNParent = GetWindowClass(hwndParent)

	; GWHdrCtl's have window class "GWHdrCtl" or have a parent that is "GWHdrCtl"
	;
	;exMessageBox( GetWindowClass(hwnd), "hwnd class", MB_OK)
	;exMessageBox( GetWindowClass(GetParent(hwnd)), "parent class", MB_OK)
	if (sWCNControl == WCN_GWHDRCTL) ||
	   (sWCNParent  == WCN_GWHDRCTL) then
		if (iControlID == CID_HDR_BITMAP_CLOSE_CTLID) then
			SayFormattedMessage( OT_CONTROL_NAME, "Hide the Folder List") ; string same as tooltip
			SayFormattedMessage( OT_SMART_HELP, "To Activate Press Enter Key")
		elif (iControlID == CID_HDR_BITMAP_FILTER_CTLID) then
			SayString("Filter the contents of the view.")		;string same as tooltip
			SayString("Press down arrow for options.")
		elif ((iControlID >= CID_HDR_PROXY_DROPDOWN_CTLID) && 
				(iControlID <= CID_HDR_ACCTPROXY_DROPDOWN_CTLID)) then
			SayWindow( hwndControl, READ_EVERYTHING)
			SayString("Press down arrow to list")
		elif(iControlID == CID_HDR_FOLDER_OPTIONS_DROPDOWN_CTLID ) then
			SayString("Folder List Options")			;string same as tooltip
			SayString("Press down arrow to list")			
		elif (iControlID == CID_HDR_PROP_STYLESHEET_DROPDOWN_CTLID) then
			SayWindow( hwndControl, READ_EVERYTHING)
			SayString("Press down arrow to list")
		elif (iControlID == CID_HDR_FIND_DROPDOWN_CTLID) then
			SayWindow( hwndControl, READ_EVERYTHING)
			SayString("Press down arrow to list")
		elif (iControlID == CID_HDR_FILTER_EDITBOX_CTLID) then
			SayFocusedObject ()
			SayString("Find:")
			if (IsWindowVisible(FindWindow(hwndControl,"OWL_Window"))) then
					SayFormattedMessage(OT_NO_DISABLE, msgClearFilter)
			endif
		elif (iControlID == CID_HDR_ATTACHMENT_TEXT_ID)then
			SayWindow( hwndControl, READ_EVERYTHING)
			SayString("Press down arrow to change")
		elif ((iControlID == CID_HDR_TO_RECIPIENTS_TEXT_ID)||
				(iControlID == CID_HDR_CC_RECIPIENTS_TEXT_ID) ||
				(iControlID == CID_HDR_BC_RECIPIENTS_TEXT_ID) ||
				(iControlID == CID_HDR_ALL_RECIPIENTS_TEXT_ID)) then
			if (sWCNControl == WCN_GWHDRCTL) then
				; This is an address that has a popdown list
				SayString("Press Down Arrow to list all recipients")
				SayWindow( hwndControl, READ_EVERYTHING)
			else
				; This an address without a popdown list
				SayControlEx( hwndControl, "", " ") ;Suppress saying window type
;				SayWindow( hwndControl, READ_EVERYTHING)
			endif
		elif (iControlID == CID_HDR_DATE_TEXT_ID) then
;			SayControlExWithMarkup(hwndControl)
			SayWindow( hwndControl, READ_EVERYTHING)
		elif (iControlID == CID_HDR_ICONTEXT_MAILBOX_CTLID) then
			SayWindow( hwndControl, READ_EVERYTHING)
			SayFormattedMessage( OT_SMART_HELP, "To change header properties Press Shift and Enter Keys")
		else
			; Default for "GWHdrCtl"
			SayControlEx(hwndControl,""," ")	;Suppress saying window type (ie read only edit)
		endif
		;;;TrcExit("HandleGWHdrCtl:1 - return=true")
		return TRUE
	endif
;;;TrcExit("HandleGWHdrCtl:0 - return=false")
return FALSE
EndFunction



int Function HandleOther( Handle hwnd )
;;;TrcEnter("HandleOther")

var
	string		sRealWindowClass,
	string		sClassName,
	string		sParentClassName,
	string		sPrompt,
	string		sType,
	int			iControlId,
	int			iPropertiesStringLength

let sClassName = GetWindowClass( hwnd )
let sRealWindowClass = GetWindowClass(GetRealWindow(hwnd))
let iControlId = GetControlID (hwnd)
let sParentClassName = GetWindowClass(GetParent(hwnd))

if (sClassName == WCN_BMPPUSHBTNCLASS32) then
var	string sButtonName,
	string sParentName
	let sParentName = GetWindowName( GetParent(hwnd))
	if (sParentName == WN_GOTODATE ||
		 sParentName == WN_DATEINPUT) then
		if   (iControlId == ID_DGI_YEARPLUS)   then let sButtonName = msgNextYear
		elif (iControlId == ID_DGI_MONTHPLUS)  then let sButtonName = msgNextMonth
		elif (iControlId == ID_DGI_YEARMINUS)  then let sButtonName = msgPreviousYear
		elif (iControlId == ID_DGI_MONTHMINUS) then let sButtonName = msgPreviousMonth
		endif
	elif (sParentName == WN_DATEDIFFERENCE) then
		if   (iControlId == ID_DTDIFF_SNYEAR) then let sButtonName = msgNextYear
		elif (iControlId == ID_DTDIFF_SNMON)  then let sButtonName = msgNextMonth
		elif (iControlId == ID_DTDIFF_SPYEAR) then let sButtonName = msgPreviousYear
		elif (iControlId == ID_DTDIFF_SPMON)  then let sButtonName = msgPreviousMonth
		endif
		if   (iControlId == ID_DTDIFF_ENYEAR) then let sButtonName = msgNextYear
		elif (iControlId == ID_DTDIFF_ENMON)  then let sButtonName = msgNextMonth
		elif (iControlId == ID_DTDIFF_EPYEAR) then let sButtonName = msgPreviousYear
		elif (iControlId == ID_DTDIFF_EPMON)  then let sButtonName = msgPreviousMonth
		endif
	elif (sParentName == WN_MULTIUSERLIST) then
		if   (iControlId == IDC_MUL_ORDER_DOWN) then let sButtonName = msgMoveSelectedItemDown
		elif (iControlId == IDC_MUL_ORDER_UP)   then let sButtonName = msgMoveSelectedItemUp
		endif
	endif
	if (sButtonName != "") then
		SayControlExWithMarkup( hwnd, sButtonName)
		;;;TrcExit("HandleOther-1a return=true")
		return TRUE
	endif
endif

if (sClassName == WCN_GWSMALLMONTH) then
	if(sParentClassName == "Appt View" || sParentClassName == "OFTodoView"  || sParentClassName == "OFNoteView"    ) then
		SayString("Date Picker. Press TAB to select recurring autodate")
	endif
	SayWindow(hwnd, READ_HIGHLIGHTED)
	SayFormattedMessage(OT_NO_DISABLE, msgMoveThroughCalendar)
	;;;TrcExit("HandleOther-1b return=true")	
	return TRUE
endif
if (sClassName == WCN_EDIT) then
	if(iControlId == CID_CATEGORY_ID) then
		SayString(GetWindowName(hwnd))
		SaySentence ()		; this will cause the data in the control to be read
		SayFormattedMessage( OT_SMART_HELP, "To Activate Press Any Key")
		;;;TrcExit("HandleOther-2a return=true")	
		return TRUE
	endif

	if(iControlId == IDC_IM_TEXT) then
		SayFormattedMessage( OT_CONTROL_NAME, "Instant Messaging ID Edit")
		;;;TrcExit("HandleOther-2b return=true")	
		return TRUE
	endif

	if(iControlId == ID_PRPFOL_GEN_NAME) then
		let sParentName = GetWindowName( GetParent(GetParent(hwnd)))
		let iPropertiesStringLength = StringLength(WN_PROPERTIES)

		; Only say this if we're reasonably sure we're on a Folder Properties page.
		; We just look at the last 10 characters of the dialog title since the folder name will
		; be the first word on the title bar, and varies depending on the folder.
		if (StringLength(sParentName) >= iPropertiesStringLength && StringRight(sParentName, iPropertiesStringLength) == WN_PROPERTIES) then
			SayFormattedMessage( OT_CONTROL_NAME, "Folder Name")
			SayFocusedObject()
			;;;TrcExit("HandleOther-2c return=true")	
			return TRUE
		endif
	endif

	; On the Send Options - General, there are spin boxes that need assistance by
	; saying "days" after the number in the spin box.
	;
	if(GetWindowSubTypeCode(hwnd) == WT_EDIT_SPINBOX) then
		if (iControlId == cid_EditSpinBox) then
			return HandleSpinControl (hwnd)
		endif
	endif
endif

if (sClassName == WCN_BUTTON) then
;; NOTE: Checkbox control is now like regular checkbox.  No special handling required.
;;
;	if (iControlId == CID_CHKBOX_ALL_DAY_EVENT) then
;		IndicateControlType(WT_CHECKBOX)
;		IndicateControlState(WT_CHECKBOX,CTRL_CHECKED)
;
;		var int iStatus
;		let iStatus = SendMessage( hwnd, 242)	; BM_GETSTATE
;		;;;OutputDebugString(FormatString("--Status=%1",IntToString(iStatus)))
;		;;;OutputDebugString(FormatString("--Attributes=%1",IntToString(GetControlAttributes())))
;		;;;OutputDebugString(FormatString("--IsChecked=%1",IntToString(ControlIsChecked())))
;
;		SayControl(hwnd)
;		;;;TrcExit("HandleOther-2c return true")
;		return TRUE
;	endif
	if (iControlId == CID_ENUM_ACCEPT_LEVEL) then
		;;;OutputDebugString("--ACCEPTLEVEL")
		SayFormattedMessage( OT_CONTROL_NAME, "Show as")
		SayFocusedObject()
		;;;TrcExit("HandleOther-3a return=TRUE")
		return TRUE
	elif (iControlId == IDC_CACHE_BROWSE) then
		;;;OutputDebugString("--CACHEBROWSE")
		SayString("Browse to path for caching mailbox Button")
		;;;TrcExit("HandleOther-3b return=TRUE")
		;SayFocusedObject()
		return TRUE
	elif (iControlId == IDC_REMOTE_BROWSE) then
		;;;OutputDebugString("--REMOTEBROWSE")
		SayString("Browse to path for remote mailbox Button")
		;SayFocusedObject()
		;;;TrcExit("HandleOther-3c return=TRUE")
		return TRUE
	elif (iControlId == IDC_ADDRESS_SELECTOR_BUTTON) then
		;;;OutputDebugString("--ADDRESSSELECTOR")
		SayFormattedMessage( OT_CONTROL_NAME, "Address Selector")
		SayFocusedObject()
		;;;TrcExit("HandleOther-3d return=TRUE")
		return TRUE
	endif
endif

;
; NOTE! JAWS considers "RichEdit" and "RichEdit20W" to be equal.
; We need to make a distinction.  To accomplish this, WCN_RICHEDIT is set to
; "RichEditx".  This allows "RichEdit" compare equal to WCN_RICHEDIT and
; "RichEdit20w" to be not equal.
;

if	(sClassName == WCN_RICHEDIT) &&
	(sParentClassName == WCN_OWL_WINDOW) &&
	(GetControlId(GetParent(hwnd)) == CID_ADDR_PRIORITY) then
;	if (sRealWindowClass == WCN_TASKWINDOW) then
		let sPrompt = "Priority:"
elif (sClassName == WCN_RICHEDIT20) then
	if (sParentClassName == WCN_OWL_WINDOW) then
		if (iControlId == CID_ADDR_SUBJ) then
			let sPrompt = "Subject:"
		elif (iControlId == CID_ADDR_PLACE) then
			let sPrompt = "Place:"
		elif (iControlId == CID_MESSAGE_RTF) then
			let sPrompt = "Message:"
		endif
	elif (sParentClassName == WCN_GWQUICKVIEWERCONTENTPANE ) then
		let sPrompt = "Message:"			; This will be the view "rich text" message window
	endif
elif (sClassName ==  "Message") then
	let sPrompt = "Message:"		; This will be the compose "Rich Text" message window
	let sType = "Edit"
elif (sClassName == cwcIEServer) then	; classname=="Internet Explorer_Server"
	SayFormattedMessageBoxWindow()
	;;;TrcExit("HandleOther-4a return=TRUE")
	return TRUE
;	let sPrompt = "Message:"		; This is the "rich text" composer for GW70
;	let sType = "Edit"
endif

if (sClassName == WCN_ComboBoxEx32) then
	if(iControlId == IDC_IM_PROVIDER) then
		SayFormattedMessage( OT_CONTROL_NAME, "Instant messaging service")
		SayFocusedObject()
		;;;TrcExit("HandleOther-4b return=true")	
		return TRUE
	endif
endif

if (sPrompt != "") then
;	SayControlExWithMarkup( hwnd, sPrompt, sType )
	SayFormattedMessage( OT_CONTROL_NAME, sPrompt )
	;;;TrcExit("HandleOther-5; return=true")
	return TRUE
endif

;;;TrcExit("HandleOther0; return=false")
return FALSE
EndFunction

int Function HandleSpinControl (Handle hwnd)
;;;TrcEnter("HandleSpinControl")
	var	handle hNext,
			handle	hParent,
			int			nNextId

	; get the next window
	let hNext		= GetNextWindow (hwnd)
	let nNextId = GetControlId (hNext)

	; make sure it's the updown control
	if (nNextId == IDC_SPIN_UPDOWN) then
		var string		sParentClass

		; get the parent window
		let hParent = GetParent (hNext)

		; get the class name
		let sParentClass	= GetWindowClass (hParent)

		; make sure it's "SPINCTRL"
		if (sParentClass == WCN_SPINCTRL) then
			var	handle	hTemp,
					int			nParentId

			; get the control id of the parent (the spin control)
			let nParentId = GetControlId (hParent)

			if (nParentId == CID_SendOptionReplyWithin		||
				 nParentId == CID_SendOptionAfter						||
				 nParentId == CID_EnvCleanupAppt						||
				 nParentId == CID_SendOptionFor							||
				 nParentId == CID_DateTimeBusyApptRange	||
				 nParentId == CID_EnvCleanupEmptyTrash) then

				; for these values say the object and then "days"
				SayFocusedObject()
				SayString ("Days")			

			elif (nParentId == CID_EnvSecurityLogoff ||
					 nParentId == CID_EnvGeneralRefreshMinutes) then

				; for these values say the object and then "minutes"
				SayFocusedObject()
				SayString ("Minutes")

			elif (nParentId == CID_BusyInvToMtgSearch) then

				; for this value, say the label, then say the value
				let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_BusyInvToMtgSearchLbl)

				SayString (GetWindowName (hTemp))
				SayFocusedObject()
		
			elif (nParentId == CID_EnvGeneralRefreshSeconds && 
						GetDialogPageName() == WN_GENERAL) then			
				; for this value say the object and then "Seconds"
				SayWindow (hwnd, READ_EVERYTHING)
				SayString ("Seconds")


			elif (nParentId == CID_DateTimeBusyApptHours) then

				; for this value, say the label, then say the value
				let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_DateTimeBusyApptGroup)

				SayString (GetWindowName (hTemp))
				SayFocusedObject()
				SayString ("Hours")

			elif (nParentId == CID_EnvDefaultActKB) then

				; for this value say the object and then "kilobytes"
				SayWindow (hwnd, READ_EVERYTHING)
				SayString ("Kilobytes")

			elif (nParentId == CID_DateTimeCalApptMinutes ||
					 nParentId == CID_DateTimeCalAllDayMinutes) then

				; for these values, say the string, the value, then "minutes"
				SayString ("Default alarm time:")
				SayWindow (hwnd, READ_EVERYTHING)
				SayString ("Minutes")

			elif (nParentId == CID_DateTimeCalApptHours ||
					 nParentId == CID_DateTimeCalAllDayHours) then

				; for these values, say the string, the value, then "hours"
				SayString ("Default alarm time:")
				SayWindow (hwnd, READ_EVERYTHING)
				SayString ("Hours")

			elif (nParentId == CID_DateTimeCalDefApptHours) then

				; for this value say the object and then "hours"
				SayFocusedObject()
				SayString ("Hours")

			elif (nParentId == CID_DateTimeBusyApptMinutes		||
					 nParentId == CID_DateTimeCalDefApptMinutes	||
					 nParentId == 301) then

				; for these values say the object and then "minutes"
				SayWindow (hwnd, READ_EVERYTHING)
				SayString ("Minutes")

			elif (nParentId == CID_SelDispSettingsDaysIn) then

				; for this value say the label and then say the value
				let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_SelDispSettingsDaysInLbl)

				SayString (GetWindowName (hTemp))
				SayFocusedObject()

			elif (nParentId == CID_SelDispSettingsDaysAgo) then

				; for this value say the label and then say the value
				let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_SelDispSettingsDaysAgoLbl)

				SayString (GetWindowName (hTemp))
				SayFocusedObject()

			elif (nParentId == CID_JunkMailDaysAfter) then

				; for this value say the value and then say the label
				SayFocusedObject()

				let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_JunkMailDaysAfterLbl)

				SayString (GetWindowName (hTemp))

			elif (nParentId == CID_WaitToDetectApp) then

				; for this value say the object and then "seconds"
				SayFocusedObject()
				SayString ("Seconds")

			elif (nParentId == CID_DownloadMax) then

				; for this value say the object and then "messages at a time"
				SayWindow (hwnd, READ_EVERYTHING)
				SayString ("messages at a time")

			elif (nParentId == CID_RemoveMessages) then

				; for this value say the value and then say the label
				SayFocusedObject()

				let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_RemoveMessagesDaysOld)

				SayString (GetWindowName (hTemp))
			else
				; default case
				SayFocusedObject()
			endif
		endif
	endif

	;;;TrcExit("HandleSpinControl-0 return true")
	return TRUE
EndFunction


int function GetFieldCount( handle hwnd )
; this function returns the number of occurances of this window among its siblings
; the occurance is based on class name
var
	string sClassName,
	handle hTmp,
	int iCnt
let iCnt = 0
let sClassName = GetWindowClass( hwnd )
;exMessageBox( sClassName, "InGetFieldOccurance", MB_OK)
let hTmp = GetFirstWindow (hwnd)	; Get First Sibling
while (hTmp != 0)
	if (GetWindowClass(hTmp) == sClassName) then
		let iCnt = iCnt + 1
	endIf
	let hTmp = GetNextWindow (hTmp)
endWhile
return iCnt
EndFunction

int function GetFieldOccurance( handle hwnd )
; this function returns the occurance of this window among its siblings
; the occurance is based on class name
; the first occurance returns "1", the second returns "2", etc.
var
	string sClassName,
	handle hTmp,
	int iPos
let ipos = 1
let sClassName = GetWindowClass( hwnd )
;exMessageBox( sClassName, "InGetFieldOccurance", MB_OK)
let hTmp = GetFirstWindow (hwnd)	; Get First Sibling
while (hTmp != hwnd)
	if (GetWindowClass(hTmp) == sClassName) then
		let iPos = iPos + 1
	endIf
	let hTmp = GetNextWindow (hTmp)
endWhile
return iPos
EndFunction


int Function HandleAddressField(handle hwndControl)
;;;TrcEnter("HandleAdressFieldPrompt")
var
	string sPrompt

if (GetWindowClass(GetParent(hwndControl)) == WCN_ENTRYFIELD) then
	var
	int iParentId
	let iParentId = GetControlId(GetParent(hwndControl))
	if (iParentId == CID_ADDR_TO) then
		let sPrompt = MSG_TO_FIELD
	elif (iParentId == CID_ADDR_CC) then
		let sPrompt = MSG_CC_FIELD
	elif (iParentId == CID_ADDR_BC) then
		let sPrompt = MSG_BC_FIELD
	elif (iParentId == CID_ADDR_FROM) then
		let sPrompt = MSG_FROM_FIELD
	endif
endif

if (sPrompt != "") then
	SayFormattedMessage( OT_CONTROL_NAME, sPrompt )
	;;;TrcExit("HandleAddressField:1 return=true")
	return TRUE
endif

;;;TrcExit("HandleAddressField:0 return=false")
return FALSE
EndFunction


int function HandleDatePicker( handle hwnd )
;;;TrcEnter("HandleDatePicker")

; This function checks to see if hwnd is one of the Date Picker controls.
; If it is, it says the appropriate "prompt" for the control
; If not, it returns a null string.
;
; The "date picker" controls are a sequence of four windows:
;  
;  |
;  +-GWDatePicker	
;  | +--Edit		Start Date / End Date
;  +-RICHEDIT		Start Time / End Time or Duration.
;  +-Button			Button that brings up time dialog
;  |
;
; The first occurence will be Start Date-Time.  
; The second set will be End Date-Time (or duration, or Due Date).
;
Var
	string		sClass,
	string		sPrompt,
	string		sType,
	string		sRealWindowClass,
	handle		hDP,
	handle		hParent,
	handle 		hPrev,
	int			iPos

let sPrompt = ""
let sType = ""
let sClass = GetWindowClass(hwnd)
let sRealWindowClass = GetWindowClass(GetRealWindow(hwnd))


if (sClass == WCN_EDIT) then
	let hDP = GetParent( hwnd )
	if (GetWindowClass(hDP)==WCN_GWDATEPICKER) then
		let iPos = GetFieldOccurance( hDP )
		if (iPos == 1) then
			let hPrev = GetPriorWindow(hDP)
			if(GetWindowClass(hPrev) == "Static") then
				let sPrompt = GetWindowText(hPrev, FALSE)
				SayControlExWithMarkup( hwnd, sPrompt, sType )
; GW655			SayString("Press Grave Accent to toggle. Press Return or Down Arrow to Open Calendar")
				SayString("Press Return or Down Arrow to Open Calendar")
				;;;TrcExit("HandleDatePicker-3; return=true")
				return TRUE
			else
				if(GetWindowClass(GetFocus()) != WCN_GWSMALLMONTH) then
					let sPrompt = "Start Date:"
					SayControlExWithMarkup( hwnd, sPrompt, sType )
					SayString("Press Down Arrow to Open Calendar")
					return TRUE
				endif
			endif
		elif (iPos == 2) then
			if (sRealWindowClass == WCN_TaskWindow) then
				let sPrompt = "Due on:"
			elif (sRealWindowClass == WCN_ApptWindow) then
				let sPrompt = "End Date:"
			else 
				if(GetWindowClass(GetFocus()) != WCN_GWSMALLMONTH) then
					let sPrompt = "End Date:"
					SayControlExWithMarkup( hwnd, sPrompt, sType )
					SayString("Press Down Arrow to Open Calendar")
					return TRUE
				endif
			endif
		endif
	endif
elif (sClass == WCN_RICHEDIT) then
	let hDP = GetPriorWindow( hwnd )
	if (GetWindowClass(hDP)==WCN_GWDATEPICKER) then
		let iPos = GetFieldOccurance( hDP )
		if (iPos == 1) then
			let sPrompt = "Start Time:"
		elif (iPos == 2) then
			if (IsWindowVisible(hDP)) then
				let sPrompt = "End Time:"
			else
				if (sRealWindowClass == WCN_TaskWindow) then
					let sPrompt = "Due in:"
				else
					let sPrompt = "Duration:"
				endif
			endif
		endif
	endif
elif (sClass == WCN_BUTTON) then
	let hDP = GetPriorWindow(GetPriorWindow(hwnd))
	if (GetWindowClass(hDP) == WCN_GWDATEPICKER) then
		; not sure why we do this, but we shouldn't do it for the checkbox in the find dialog
		var	int	nId

		let nId = GetControlId (hwnd)

		if (nid == CID_FindOnlyOfficial) then
			return FALSE
		endif

		let sPrompt = "Select Time Button"
		let sType = "Button"
	endif
endif

if (sPrompt != "") then
;	SayFormattedMessage( OT_CONTROL_NAME, sPrompt )
	SayControlExWithMarkup( hwnd, sPrompt, sType )
;;;	TrcExit("HandleDatePicker-1; return=true")
	return TRUE
endif
;;;TrcExit("HandleDatePicker-0; return=false")
return FALSE
EndFunction



Void Function ClearBusy()
	let g_strLastDate = ""
	let g_strLastTime = ""
	let g_strLastDuration = ""
	let g_strLastFreeBusy = ""
EndFunction

int Function SayBusyInfo( int iControlId, int sbi_flags)
;;;TrcEnter("SayBusyInfo")
var int cid_StartDateLbl,
	int cid_StartDate,
	int cid_StartTimeLbl,
	int cid_StartTime,
	int cid_DurationLbl,
	int cid_Duration,
	int cid_FreeBusy

if (iControlId == CID_CAT_IND_GRID) then
	; These are the controls on the Individual Schedule Page.
	let cid_StartDateLbl	=	CID_CAT_IND_STARTDATE_LBL
	let cid_StartDate		=	CID_CAT_IND_STARTDATE	 
	let cid_StartTimeLbl	=	CID_CAT_IND_STARTTIME_LBL
	let cid_StartTime		=	CID_CAT_IND_STARTTIME	 
	let cid_DurationLbl		=	CID_CAT_IND_DURATION_LBL 
	let cid_Duration		=	CID_CAT_IND_DURATION	 
	let cid_FreeBusy		=	CID_CAT_IND_FREEBUSY	 
elif (iControlId == CID_CAT_AVL_GRID) then
	; These are the controls on the Available Times Page.
	let cid_StartDateLbl	=	CID_CAT_AVL_STARTDATE_LBL
	let cid_StartDate		=	CID_CAT_AVL_STARTDATE	 
	let cid_StartTimeLbl	=	CID_CAT_AVL_STARTTIME_LBL
	let cid_StartTime		=	CID_CAT_AVL_STARTTIME	 
	let cid_DurationLbl		=	CID_CAT_AVL_DURATION_LBL 
	let cid_Duration		=	CID_CAT_AVL_DURATION	 
	let cid_FreeBusy		=	CID_CAT_AVL_FREEBUSY	 
else 
	return FALSE
endif

if (sbi_flags & (SBI_SAY_RECIPIENT) && (iControlId == CID_CAT_IND_GRID)) then
	; The following 'saywindow' causes the recipient's name to be 
	; spoken before the other information.
	SayWindow( FindDescendantWindow(GetParent(GlobalFocusWindow), CID_CAT_IND_RECIPIENT_LISTBOX ), READ_HIGHLIGHTED )
endif

if (sbi_flags & (SBI_SAY_DATE | SBI_SAY_CHANGED_DATE)) then
	var string str_Date
	let str_Date = GetWindowText( FindDescendantWindow( GetParent(GlobalFocusWindow), cid_StartDate ), FALSE)
	if (sbi_flags & SBI_SAY_DATE || str_Date != g_strLastDate) then
		if (g_strLastDate == "") then
			SayString( GetWindowText( FindDescendantWindow( GetParent(GLobalFocusWindow), cid_StartDateLbl ), FALSE))
		endif
		SayString( str_Date )
		let g_strLastDate = str_Date
	endif
endif

if (sbi_flags & (SBI_SAY_TIME | SBI_SAY_CHANGED_TIME)) then
	var string str_Time
	let str_Time = GetWindowText( FindDescendantWindow( GetParent(GlobalFocusWindow), cid_StartTime ), FALSE)
	if (sbi_flags & SBI_SAY_TIME || str_Time != g_strLastTime) then
		if (g_strLastTime == "") then
			SayString( GetWindowText( FindDescendantWindow( GetParent(GLobalFocusWindow), cid_StartTimeLbl ), FALSE))
		endif
		SayString( str_Time )
		let g_strLastTime = str_Time
	endif
endif

if (sbi_flags & (SBI_SAY_DURATION | SBI_SAY_CHANGED_DURATION)) then
	var string str_Duration
	let str_Duration = GetWindowText( FindDescendantWindow( GetParent(GlobalFocusWindow), cid_Duration ), FALSE)
	if (sbi_flags & SBI_SAY_DURATION || str_Duration != g_strLastDuration) then
		if (g_strLastDuration == "") then
			SayString( GetWindowText( FindDescendantWindow( GetParent(GLobalFocusWindow), cid_DurationLbl ), FALSE))
		endif
		SayString( str_Duration )
		let g_strLastDuration = str_Duration
	endif
endif

if (sbi_flags & (SBI_SAY_FREEBUSY | SBI_SAY_CHANGED_FREEBUSY)) then
	var string str_FreeBusy
	let str_FreeBusy = GetWindowText( FindDescendantWindow( GetParent(GlobalFocusWindow), cid_FreeBusy ), FALSE)
	if (sbi_flags & SBI_SAY_FREEBUSY || str_FreeBusy != g_strLastFreeBusy) then
		SayString( str_FreeBusy )
		let g_strLastFreeBusy = str_FreeBusy
	endif
endif

; When we are on the Available Time Grid we want to say how many have responded.
; Also say this when SBI_SAY_ALL has been specified.
if ((iControlId == CID_CAT_AVL_GRID) || (sbi_flags == SBI_SAY_ALL)) then
	SayWindow( FindDescendantWindow(GetRealWindow(GlobalFocusWindow), CID_CAT_STATUSLINE), READ_EVERYTHING )
endif

return
EndFunction


Script SelectNextLine()	; shift down-arrow
var 	int iControlId,
			string sClass	
let sClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (sClass == WCN_TimeCalendarGrid ) then
	SelectNextLine()
	SayBusyInfo( iControlId, SBI_SAY_DURATION + SBI_SAY_CHANGED_FREEBUSY )
	Return;
Endif
PerformScript SelectNextLine()
EndScript

Script SelectPriorLine()		; shift up-arrow
var 	int iControlId,
			string sClass	
let sClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (sClass == WCN_TimeCalendarGrid ) then
	SelectPriorLine()
	SayBusyInfo( iControlId, SBI_SAY_DURATION  + SBI_SAY_CHANGED_FREEBUSY)
	Return;
Endif
PerformScript SelectPriorLine()
EndScript

Script SelectNextCharacter()		; shift right-arrow
var 	int iControlId,
			string sClass	
let sClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (sClass == WCN_TimeCalendarGrid ) then
	SelectNextCharacter()
	SayBusyInfo( iControlId, SBI_SAY_DURATION  + SBI_SAY_CHANGED_FREEBUSY)
	Return;
Endif
PerformScript SelectNextCharacter()
EndScript

Script SelectPriorCharacter()		; shift left-arrow
var 	int iControlId,
			string sClass	
let sClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (sClass == WCN_TimeCalendarGrid ) then
	SelectPriorCharacter()
	SayBusyInfo( iControlId, SBI_SAY_DURATION  + SBI_SAY_CHANGED_FREEBUSY)
	Return;
Endif
PerformScript SelectPriorCharacter()
EndScript

String Function GetInfoWindowText( handle hwnd_parent, int cid_window )
return GetWindowText( FindDescendantWindow( hwnd_parent, cid_window), FALSE )
EndFunction

Void Function SayInfoWindow( int cid_window, handle hwnd_parent )
;;;TrcEnter("SayInfoWindow")
SayString( GetInfoWindowText( hwnd_parent, cid_window))
EndFunction

Script SayParagraph()
var 	int iControlId,
			string sClass	
if (GetWindowClass(GlobalFocusWindow) == WCN_TimeCalendarGrid) Then
	var handle hwnd_Parent
	let hwnd_parent = GetParent(GlobalFocusWindow)
	if (GetControlId(GlobalFocusWindow) == CID_CAT_AVL_GRID) then
		var handle hwnd
;		SayInfoWindow( CID_CAT_AVL_OUTOFOFFICE_LBL, hwnd_parent )
;		SayInfoWindow( CID_CAT_AVL_OUTOFOFFICE_CBX, hwnd_parent )
		let hwnd = FindDescendantWindow( hwnd_parent, CID_CAT_AVL_OUTOFOFFICE_CBX )
		SayWindowTypeandText(hwnd)
;		SayInfoWindow( CID_CAT_AVL_BUSY_LBL, hwnd_parent )
;		SayInfoWindow( CID_CAT_AVL_BUSY_CBX, hwnd_parent )
		let hwnd = FindDescendantWindow( hwnd_parent, CID_CAT_AVL_BUSY_CBX )
		SayWindowTypeandText(hwnd)
;		SayInfoWindow( CID_CAT_AVL_TENTATIVE_LBL, hwnd_parent )
;		SayInfoWindow( CID_CAT_AVL_TENTATIVE_CBX, hwnd_parent )
		let hwnd = FindDescendantWindow( hwnd_parent, CID_CAT_AVL_TENTATIVE_CBX )
		SayWindowTypeandText(hwnd)
	else
;		SayInfoWindow( CID_CAT_IND_STARTDATE_LBL2, hwnd_parent)
		if (	GetInfoWindowText( hwnd_parent, CID_CAT_IND_STARTDATE2) != 
			GetInfoWindowText( hwnd_parent, CID_CAT_IND_STARTDATE)) then
			SayInfoWindow( CID_CAT_IND_STARTDATE2, hwnd_parent)
		endif
;		SayInfoWindow( CID_CAT_IND_STARTTIME_LBL2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_STARTTIME2, hwnd_parent)
;		SayInfoWindow( CID_CAT_IND_Duration_Lbl2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_Duration2, hwnd_parent)

		SayInfoWindow( CID_CAT_IND_ShowAs2, hwnd_parent)

		SayInfoWindow( CID_CAT_IND_Subject_Lbl2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_Subject2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_From_Lbl2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_From2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_Place_Lbl2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_Place2, hwnd_parent)
	endif
	return
endif
; Do the default SayParagraph.
PerformScript SayParagraph()
EndScript


Void Function FocusChangedEvent ( handle FocusWindow, handle PrevWindow )
; If a ChooseApptTime grid control is getting focus for the first time, 
;   clear busy variables so labels will be spoken.
;
if (GetWindowClass(FocusWindow) == WCN_TimeCalendarGrid) then
	if (GetTopLevelWindow(FocusWindow) != g_hwndPrevChooseDlg) then
		ClearBusy()
		let g_hwndPrevChooseDlg = GetTopLevelWindow(FocusWindow)
	endif
endif

If ((GetWindowName(GetRealWindow(GlobalFocusWindow)) == "Address Selector") && (GetControlId(FocusWindow) == CID_BOOKSELECT)
	&& (FocusWindow != PrevWindow) && (GetWindowClass(PrevWindow)!= "ComboLBox")) Then
	PerformScript OpenListBox()
EndIf

; Invoke the default FocusChangedEvent.
FocusChangedEvent( FocusWindow, PrevWindow )
EndFunction

;==========================================================================
;==========================================================================
; Below this are debug functions.
;==========================================================================
;==========================================================================

Function SayControlExWMDebug( handle hwnd )
SayString("SayControlExWithMarkup:")
SayString("Param 1")
SayControlExWithMarkup( hwnd, "", " ", " ", " ", " ", " ", " ", " ")
SayString("Param 2")
SayControlExWithMarkup( hwnd, " ", "", " ", " ", " ", " ", " ", " ")
SayString("Param 3")
SayControlExWithMarkup( hwnd, " ", " ", "", " ", " ", " ", " ", " ")
SayString("Param 4")
SayControlExWithMarkup( hwnd, " ", " ", " ", "", " ", " ", " ", " ")
SayString("Param 5")
SayControlExWithMarkup( hwnd, " ", " ", " ", " ", "", " ", " ", " ")
SayString("Param 6")
SayControlExWithMarkup( hwnd, " ", " ", " ", " ", " ", "", " ", " ")
SayString("Param 7")
SayControlExWithMarkup( hwnd, " ", " ", " ", " ", " ", " ", "", " ")
SayString("Param 8")
SayControlExWithMarkup( hwnd, " ", " ", " ", " ", " ", " ", " ", "")
EndFunction

Function SayControlExDebug( handle hwnd )
MessageBox("")
SayString("SayControlEx:")
SayString("Param 1")
SayControlEx( hwnd, "", " ", " ", " ", " ", " ", " ", " ")
MessageBox("")
SayString("Param 2")
SayControlEx( hwnd, " ", "", " ", " ", " ", " ", " ", " ")
MessageBox("")
SayString("Param 3")
SayControlEx( hwnd, " ", " ", "", " ", " ", " ", " ", " ")
MessageBox("")
SayString("Param 4")
SayControlEx( hwnd, " ", " ", " ", "", " ", " ", " ", " ")
MessageBox("")
SayString("Param 5")
SayControlEx( hwnd, " ", " ", " ", " ", "", " ", " ", " ")
MessageBox("")
SayString("Param 6")
SayControlEx( hwnd, " ", " ", " ", " ", " ", "", " ", " ")
MessageBox("")
SayString("Param 7")
SayControlEx( hwnd, " ", " ", " ", " ", " ", " ", "", " ")
MessageBox("")
SayString("Param 8")
SayControlEx( hwnd, " ", " ", " ", " ", " ", " ", " ", "")
MessageBox("done")
EndFunction

Function SayVariousDebug()
MessageBox("")
SayString("GetWindowName:")
SayString(GetWindowName(GlobalFocusWindow))

MessageBox("")
SayString("GetObjectName:")
SayString(GetObjectName())

MessageBox("")
SayString("GetWindowType:")
SayString(GetWindowType(GlobalFocusWindow))

MessageBox("")
SayString("GetObjectType:")
SayString(GetObjectType())

MessageBox("")
SayString("GetWindowTypeCode:")
SayInteger(GetWindowTypeCode(GlobalFocusWIndow))

MessageBox("")
SayString("GetWindowTypeSubCode:")
SayInteger(GetWindowSubTypeCode(GlobalFocusWIndow))

MessageBox("")
SayString("GetObjectState:")
SayString(GetObjectState())

MessageBox("")
SayString("SayFocusedWindow--")
SayFocusedWindow()

MessageBox("")
SayString("SayFocusedObject--")
SayFocusedObject()

MessageBox("")
SayString("SayObjectTypeAndText--")
SayObjectTypeAndText( )
Delay(40,TRUE)

MessageBox("")
SayString("SayWindowTypeAndText--")
SayWindowTypeAndText( GlobalFocuswindow )

MessageBox("")
SayString("SayControl--")
SayControl( GlobalFocuswindow)

MessageBox("")
SayString("SayWindow--")
SayWindow( GlobalFocuswindow, READ_EVERYTHING )

SayString("DONE!!!")

EndFunction


Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes,
		int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
;;if( GetWindowName(GetTopLevelWindow(hwnd)) == WN_ChooseAppointmentTime) then
;;	;;;OutputDebugString	(
;;		FormatString	("NewText >>%1<<%2\r\n", buffer, IntToString( nAttributes ))
;;				)
;;endif

	var	string		sClassName

	let sClassName	= GetWindowClass (hwnd)

	If (sClassName == WCN_PopupButton) then
		if (GetParent (GlobalFocusWindow) == hwnd) then
			SayString (GetWindowText (hwnd, READ_EVERYTHING))

			; handle the format menu buttons in the date format dialog
			NteHandleDateFormatButtons (hwnd)
		endif
	endif

	if (sClassName == "button") then
		if (GlobalFocusWindow == hwnd) then
			let sClassName = GetWindowClass (GetParent (hwnd))

			If (sClassName == WCN_PopupButton) then
				SayString (GetWindowText (hwnd, READ_EVERYTHING))
			endif
		endif
	endif

	NewTextEvent (hwnd, buffer, nAttributes, nTextColor, nBackgroundColor, nEcho, sFrameName)
EndFunction


Void Function NteHandleDateFormatButtons (handle hwnd)
	var	handle	hParent,
			handle	hTemp,
			int			nControlId,
			int			nFocusId

	let hParent			= GetParent (GlobalFocusWindow)
	let nFocusId		= GetControlId (hParent)
	let nControlId	= GetControlId (hwnd)

	if (nControlId == CID_DateFormat_Date) then
		if (nFocusId == CID_DateFormat_Date) then
			let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_DateFormat_Date_Format)

			SayString (GetWindowName (hTemp))
		endif
	elif (nControlId == CID_DateFormat_MainWnd) then
		if (nFocusId == CID_DateFormat_MainWnd) then
			let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_DateFormat_MainWnd_Format)

			SayString (GetWindowName (hTemp))
		endif
	elif (nControlId == CID_DateFormat_Properties) then
		if (nFocusId == CID_DateFormat_Properties) then
			let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_DateFormat_Properties_Format)

			SayString (GetWindowName (hTemp))
		endif
	elif (nControlId == CID_DateFormat_FileInfo) then
		if (nFocusId == CID_DateFormat_FileInfo) then
			let hTemp = FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_DateFormat_FileInfo_Format)

			SayString (GetWindowName (hTemp))
		endif
	endif
EndFunction


Void Function TutorMessageEvent (handle hwndFocus, int nMenuMode)
	var	int	nControlId

	let nControlId = GetControlId (hwndFocus)

	If (nControlId == CID_ToolbarDescBtn) then
		return
	endif

	TutorMessageEvent ( hwndFocus, nMenuMode)
EndFunction


int Function SayItemInContactPropertiesList(handle hwndControl)
	;TrcEnter("SayItemInContactPropertiesList")
	If (GetJFWVersion()<510000) Then
		;TrcExit("SayItemInContactPropertiesList-return FALSE-0")
		return FALSE;
	EndIf 
	var
		int iControlId,
		int iParentId,
		handle hwndParent,
		int iParentTypeCode

	let hwndParent = GetParent(hwndControl)
	let iControlId = GetControlId(hwndControl)
	let iParentId = GetControlId(hwndParent)
	let iParentTypeCode = GetWindowTypeCode (hwndParent)

	;;;OutputDebugString(FormatString("--ControlId=%1",IntToString(iControlId)))
	;;;OutputDebugString(FormatString("--Type=%1",IntToString(GetWindowTypeCode(hwndControl))))
	;;;OutputDebugString(FormatString("--Subtype=%1",IntToString(GetWindowSubTypeCode(hwndControl))))
	;;;OutputDebugString(FormatString("--ParentId=%1",IntToString(iParentId)))
	;;;OutputDebugString(FormatString("--ParentType=%1",IntToString(GetWindowTypeCode(hwndParent))))
	;;;OutputDebugString(FormatString("--ParentSubtype=%1",IntToString(GetWindowSubTypeCode(hwndParent))))
	;;;OutputDebugString(FormatString("--RealClassName=%1",GetWindowClass(GetRealWindow(hwndControl))))
	;;;OutputDebugString(FormatString("----GetItemCount=%1",IntToString(GetItemCount(hwndControl))))

	If (iParentTypeCode == WT_LISTVIEW) && 	(iControlId == CID_POPUP_EDIT) Then
		var
				int i,
				int iFocusedItem,
				int iColumns,
				int iLeft,
				int iRight,
				int iTop,
				int iBottom,
				string sItemText,
				string sColHeader,
				string sGraphicName
		let iColumns = lvGetNumOfColumns (hwndParent)
		let iFocusedItem = lvGetFocusItem (hwndParent)

		;If the focus have not changed of selected item then return
		If (g_iLastFocusedItem== iFocusedItem) Then
			;TrcExit("SayItemInContactPropertiesList-return FALSE-1")
			return FALSE;
		EndIf
		
		;When the focus is in a new item, remember this item using g_iLastFocusedItem
		let g_iLastFocusedItem = iFocusedItem

		;Say the graphic that is in the item
		if (lvGetItemRect(hwndParent,iFocusedItem,iLeft,iRight,iTop,iBottom)) Then
			let sGraphicName=GetGraphicNameAtPoint(iLeft+(iBottom-iTop)/2,iTop+(iBottom-iTop)/2)
			SayFormattedMessage (OT_NO_DISABLE, sGraphicName)
		EndIf
		;Say the info that is in the columns of the item
		let i = 1
		while(i <= iColumns)
			let sColHeader = lvGetColumnHeader (hwndParent,i )
			let sItemText =  lvGetItemText (hwndParent,iFocusedItem,i ) 
			if (sColHeader && sItemText) then
				SayFormattedMessage (OT_NO_DISABLE, sColHeader)	
				SayFormattedMessage (OT_NO_DISABLE, sItemText)
			endif
			let i = i + 1
		endwhile
		;Say the number of item that has been selected
		SayFormattedMessage (OT_NO_DISABLE, FormatString("Item %1 of %2",IntToString( iFocusedItem ),IntToString(lvGetItemCount (hwndParent))))
		
		;TrcExit("SayItemInContactPropertiesList-return TRUE")
		return TRUE
	EndIf
	;TrcExit("SayItemInContactPropertiesList-return FALSE-2")
	return FALSE
EndFunction


Script ControlBackSpace ()
	var
		handle hwnd

	let hwnd = GetFocus()

	if (GetWindowClass(hwnd) == WCN_GWHDRCTL) || (GetWindowClass(GetParent(hwnd)) == WCN_GWHDRCTL) then
		if (GetControlId(hwnd) == CID_HDR_FILTER_EDITBOX_CTLID) then
			PerformScript ControlBackSpace()
			var 
				handle hwndOWL
			let hwndOWL = FindWindow(hwnd,"OWL_Window")
			if (IsWindowVisible(hwndOWL)) then
				var
					int iLeft,
					int iRight,
					int iTop,
					int iBottom
				GetWindowRect(hwndOWL,iLeft,iRight,iTop,iBottom)
				ClickAtPoint(iLeft+(iRight-iLeft)/2,iTop+(iBottom-iTop)/2,FALSE)
			endif
			SayFormattedMessage(OT_NO_DISABLE, msgFilterCleared)
			return
		endif
	endif

PerformScript ControlBackSpace()
EndScript


Script JAWSBackspace ()
	var
		handle hwnd

	let hwnd = GetFocus()

	; GWHdrCtl's have window class "GWHdrCtl" or have a parent that is "GWHdrCtl"
	if (GetWindowClass(hwnd) == WCN_GWHDRCTL) || (GetWindowClass(GetParent(hwnd)) == WCN_GWHDRCTL) then
		if (GetControlId(hwnd) == CID_HDR_FILTER_EDITBOX_CTLID) then
			PerformScript JAWSBackspace()
			Delay (1)
			var
				string strCurrentSearchCriteria
			let strCurrentSearchCriteria = GetTextInWindow(hwnd)
			if (StringLength(strCurrentSearchCriteria) == 0) then
				Delay(7)
				if (!IsWindowVisible(FindWindow(hwnd,"OWL_Window"))) then
					SayFormattedMessage(OT_NO_DISABLE, msgFilterCleared)
				else
					SayFormattedMessage(OT_NO_DISABLE, msgClearFilter)
				endif
				let g_strLastSearchCriteria = ""
			endif
			return
		endif
	endif

PerformScript JAWSBackspace()
EndScript


;; This routine used for debugging
;; It gets called when a script is invoked.
;; Very useful to find what scripts need to be modified (or implemented)
;;  for different key strokes.
;; 
int Function GWScriptHook (string ScriptName)
	;;;OutputDebugString(FormatString("Script>%1", ScriptName))
	return TRUE
EndFunction

;; These routines used for debugging
;; Called on entry/exit to functions and scripts
;;
void Function TrcEnter (string str)
	;;;OutputDebugString(FormatString(">%1", str))
EndFunction

void Function TrcExit(string str)
	;;;OutputDebugString(FormatString("<%1", str))
EndFunction
