; Scripts for Groupwise 5.2, 5.5 and 6.5.
; Works best with GW653 and greater.
;If Groupwise 5.2 is being used, then these scripts switch to gw52.
;
;Copyright (c) 2004 Freedom Scientific, Inc.
;
;Permission is hereby granted, free of charge, to any person obtaining a copy
;of this software and associated documentation files (the Software), to deal
;in the Software without restriction, including without limitation the rights
;to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
;copies of the Software, and to permit persons to whom the Software is
;furnished to do so, subject to the following
;conditions:
;
;The above copyright notice and this permission notice shall be included in
;all copies or substantial portions of the Software.
;
;THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
;DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
;OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
;USE OR OTHER DEALINGS IN THE SOFTWARE.

Include "Hjglobal.jsh"
Include "hjconst.jsh"
include "HjHelp.jsh"
Include "Grpwise.jsm"
Include "Grpwise.jsh"
Include "common.jsm"

globals
	int	GWVersion,
	int g_bSuppressHighlightedText,
	string g_strLastDuration,
	string g_strLastDate,
	string g_strLastTime,
	string g_strLastFreeBusy,
	handle g_hwndPrevChooseDlg,
	handle g_hwndLastSayFocusWindow,
	handle g_hwndNull


int Function GetGWVersion ()
; This function builds an integer value from the program version information.
; This value is used with in the scripts to determine which version of groupwise is being executed.
var
	int iValue,
	string sVersion

let sVersion = GetVersionInfoString (GetAppFilePath (), cmsg283_L)
let iValue = stringToInt (StringSegment (sVersion, SC_PROGRAMVERSION, 1))
let iValue = stringToInt (StringSegment (sVersion, SC_PROGRAMVERSION, 2)) + iValue * 10 
let iValue = stringToInt (StringSegment (sVersion, SC_PROGRAMVERSION, 3)) + iValue * 10
return iValue;
endFunction


string function GetAppVersion ()
var
	string sProduct,
	string sVersion,
	string sMessage
let sProduct = GetVersionInfoString (GetAppFilePath (), cmsg282_L)
let sVersion = GetVersionInfoString (GetAppFilePath (), cmsg283_L)
let sMessage = FormatString (cmsg239_L, sProduct, sVersion)
return sMessage
EndFunction


Function AutoStartEvent ()
var
	string sMessageLong,
	string sMessageShort
;
let GWVersion = GetGWVersion()
; 
; Versions 5.0.0 thru 5.2.x should use gw52 script
; Versions 5.5.x thru 6.x.x use this script.
; Version 6.5.0 thru 6.5.2 don't work well with this script.
; Version 6.5.3 works much better (this script looks for 6.5.3)
;
if (GWVersion >= 500) &&
   (GWVersion <= 529) then
	SwitchToScriptFile ("gw52", "GroupWise")
	return
EndIf
let GlobalMousePixel = 3
let iToggleColumnLabelReading = iniReadInteger(Section_applicationVerbositySettings,hKey_ColumnLabels, FALSE,jsiFileName)
let iTogglePageReading = iniReadInteger(Section_applicationVerbositySettings,hKey_ReadMessage, FALSE,jsiFileName)
let iToggleQuickViewReading = iniReadInteger(Section_applicationVerbositySettings,hKey_QuickView, TRUE,jsiFileName)
FrameClearValues ()
VirtualStart ()
if (! GWFirstTime) then
  let GWFirstTime = TRUE
	let sMessageShort = FormatString (msgAutoStart0_S, GetAppVersion ())
	SayFormattedMessage (ot_app_start, sMessageLong, sMessageShort)
EndIf

;;AddHook (HK_SCRIPT, "GWScriptHook")		;;! Debug only

EndFunction

Void Function AutoFinishEvent ()
;Put code here that will be triggered when the application is finished.
;It also gets performed when the application is switched from or looses focus, as with ALT+TAB.
;SayFormattedMessage (ot_debug, cmsgDebugAppFinish1_L)

let g_hwndLastSayFocusWindow = g_hwndNull

;;RemoveHook(HK_SCRIPT,"GWScriptHook")		;;! Debug only



EndFunction


Void Function SayLine ()
Var
	String TheRealWindow, ;stores the real window name.
	Handle hwnd,
	Int TheTypecode ;stores the window type code.

;Assigns the window type code to variable.
let hwnd = GetFocus()
let TheTypeCode = GetWindowTypeCode (globalFocusWindow)

;Assigns the window real name to variable.
let TheRealWindow = GetWindowName (GetRealWindow (GlobalFocusWindow))

;This will say the column header before the info that is in the column
;The lvFunctions are only available with JAWS 5.10 and greater.
if (GetJFWVersion() >= 510000) && (iToggleColumnLabelReading) then
	If  (TheTypeCode == WT_LISTVIEW && GetControlId(hwnd) == 1 && 	GetMenuMode () == INACTIVE) then
		var
			int i,
			int selected,
			int count,
			string info,
			string header

		let count = lvGetNumOfColumns (hwnd)
		let selected = lvGetFocusItem (hwnd)
		let i = 3
		if (lvGetItemText (hwnd,selected,i ) == lvGetItemText (hwnd,selected,i+1 )) then
			;this is a folder
			return
		endif

		while(i < count + 4)
			let header = lvGetColumnHeader (hwnd,i )
			let info =  lvGetItemText (hwnd,selected,i ) 
			if (header && info) then
				saystring(header)
				sayString(info)
			endif
			let i = i + 1
		endwhile
		SayMessage (OT_POSITION, PositionInGroup ())
		; Because we didn't call 'sayline' the internal JAWS stuff will call
		; SayHighlightedText which repeats a portion of what we spoke above.
		; We will suppress the next "SayHighlightedText" event.
		;
		let g_bSuppressHighlightedText = 1;
		return
	endif
endif

; This says if the category is checked or not
If  (TheTypeCode == WT_LISTVIEW && GetControlId(hwnd) == CID_CATEGORY_LV) then
	var
		int state
	let state = lvGetItemState (hwnd,lvGetFocusItem (hwnd))
	if (state == CATEGORY_CHECKED) then
		IndicateControlState(WT_CHECKBOX, CTRL_CHECKED)
	else
		IndicateControlState(WT_CHECKBOX, CTRL_UNCHECKED)
	endif
	SayLine()
	SayString("Press SPACE bar to toggle")
	return
endif



;
;If the window with focus is a list box in the address dialogue,
;Then only read out the highlighted text.
;this function has been modified to fix a problem that JAWS has with detecting the address list box.
;
If (TheTypeCode == WT_listBox) &&
 (TheRealWindow == wn_AddressBook) then
	SayWindow (GetFocus(), READ_HIGHLIGHTED )
	Return
endIf

;Announce the New date when focus is on the Calendar in the Day Calendar view.
If (GetAppTitle ()== wn_Daywindow) &&
   (GetWindowclass (GetFocus ()) == WCN_Calendar) Then
	Return
EndIf
sayLine ()
EndFunction

String Function GetDayViewHeader ()
Var
	String Buffer, ;Stores a string value.
	Handle Hwnd, ;Stores the window handle.
	Int Loop ;Stores the loop counter
let HWnd = GetParent (GlobalFocusWindow) ;assigns the parent window handle to variable.
let HWnd = GetFirstWindow (HWnd) ;assigns the first window handle of the same logical level to variable.
;The while statement moves through the window handles on the same logical level to see if
;the first child window handle equals the window handle with focus.
;If not, then the while loop increases the loop counter by one and
;gets the next window handle on the same logical level.
;the purpose of the loop is to determine the position of the parent window of the window with focus.
;Once the logical position is worked out, then the correct header information can be given.
While (GetFirstChild (Hwnd) != GlobalFocusWindow)
	let Loop = loop + 1 ;adds 1 to the loop counter.
	let Hwnd = GetNextWindow (HWnd) ;gets the next window handle on the same logical level
endWhile
;Tests to see the logical position of the parent window.
;1 equals the Appointment panel.
;2 equals the Notes panel
;3 = The Tasks panel.
If (Loop == AppointmentPanel) Then
	let Buffer = MSG_Prompt7_L ; "Appointments: "
ElIf (Loop == NotesPanel) Then
	let Buffer = MSG_Prompt8_L ;"Notes: "
ElIf (Loop == TasksPanel) Then
	let Buffer = MSG_Prompt9_L ;"Tasks: "
EndIf	
Return Buffer
EndFunction

string Function GetCalendarViewDate ()
var
	string sWindowText

; Extracts the date of the Calendar Day Window.
let sWindowText = GetWindowTextex (GetAppMainWindow (GlobalFocusWindow), READ_EVERYTHING, false)
let sWindowText = stringChopRight (stringChopLeft (sWindowText, 83), 6)
Return sWindowText
EndFunction

Int Function GetMessageViewType (handle hWnd)
var
	int iValue

let hWnd = GetFirstChild (GetAppMainWindow (hWnd))
While hWnd
	If (GetWindowClass (hWnd) == WCN_EntryField) Then
		let iValue = iValue + 1
	EndIf
	let hWnd = GetNextWindow (hWnd)
EndWhile
Return iValue
EndFunction

int function GetAddressFieldPos ()
; this function returns the position of the address field (To, CC, BC or From)
; of the current message view.
var
	handle hWnd,
	int iPos

let hWnd = GetFirstWindow (GetParent (GetFocus ()))
let ipos = 1
while (hWnd != GetParent (GetFocus ()))
	if (GetWindowClass (hWnd) == WCN_EntryField) Then
		let iPos = iPos + 1
	endIf
	let hwnd = getNextWindow (hWnd)
endWhile
return iPos
EndFunction

void Function SaySenderFieldPrompt ()
Var
	int iPos

let iPos = GetAddressFieldPos ()
if (iPos == To_Field) Then
	SayFormattedMessage (OT_CONTROL_NAME, MSG_TO_FIELD)
ElIf (iPos == CC_Field) Then
	SayFormattedMessage (OT_CONTROL_NAME, MSG_CC_FIELD)
elif (iPos == BC_Field) Then
	SayFormattedMessage (OT_CONTROL_NAME, MSG_BC_FIELD)
elif (iPos == From_Field) Then
	;SayString ("From: ")
EndIf
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
; NonHighlightedText  Function for speaking all newly written nonhighlighted
; text.
var
	string TheClass
let TheClass = GetWindowClass(hwnd)
if ((GetScreenEcho() > 1) || (TheClass == wn1 )) then
	SayFormattedMessage (OT_NO_DISABLE, buffer)
EndIf
;Speaks the quick viewer message window, when selected from the view menu.
If (TheClass == WCN_QuickViewer) && iToggleQuickViewReading Then
	If !QuickViewHasFocus Then
		SayFormattedMessage (OT_NO_DISABLE, buffer)
	EndIf
endIf
EndFunction

String Function GetBusyAppointmentDateTime (int Flag)
Var
	String StatusLine, ;Stores the status line
	String buffer, ;stores a string of text
	Int STRTimeLen ;stores the length of the time

Delay (2)

;Assigns the status line from the Choose Appointment Time dialogue to the variable
let StatusLine = GetWindowText (FindDescendantWindow (GetRealWindow (GlobalFocuswindow), CID_BusyStatusLine), Read_Everything)

;If the flag is true, get the new date.
;Otherwise get the time from the status line.
If Flag Then
	;StatusSrch1  = "Start Time:"
	let Buffer = StringLeft (StatusLine, StringContains (StatusLine, StatusSrch1) - 1)
else
	;StatusSrch1  = "Start Time:"
	;StatusSrch2 = "Duration"
	;Calculates the length of the time portion of the status line.	let STRTimeLen = StringContains (StatusLine, StatusSrch2) - StringContains (StatusLine, StatusSrch1)
	;Extracts the time portion of the status line.
	let Buffer = SubString (StatusLine, StringContains (StatusLine, StatusSrch1), STRTimeLen)
EndIf
Return Buffer
EndFunction

Void Function SayHighlightedText (handle HWnd, string Buffer)
Var
	String TheParentClass ;stores the parent class

if (g_bSuppressHighlightedText) then
	let g_bSuppressHighlightedText = 0
	return
endif
let TheParentClass = GetWindowClass (GetParent (HWnd)) ;assigns the parent class to variable
; HighlightedText Function for speaking all newly written highlighted
; text.
if (GetWindowSubTypeCode (hwnd) == WT_TREEVIEW) Then
		SayTreeViewLevel ()
		Return
	EndIf
;The following if test prevents the highlighted text from being spoken twice in certain list views.
;Such as the Mail box item list and the Find result window.
If (TheParentClass	== WCN_MainWindow) ||
(TheParentClass == WCN_FindResultWindow) ||
(GetControlId (hWnd) == 1034)  Then
	If (GetWindowTypecode (HWnd) == WT_ListView) Then
		return
	EndIf ;(GetWindowTypecode (HWnd) == WT_ListView)
EndIf ;(TheParentClass  == WCN_MainWindow) || (TheParentClass == WCN_FindResultWindow)
;the following if test prevents highlighted text eing spoken,
;when the calendar control of the Day Calendar view is highlighted.
If  (GetAppTitle ()== wn_DayWindow) Then
	If (GetWindowclass (HWnd) == WCN_StaticMonth) Then
	Return
	ElIf (GetWindowclass (HWnd) == WCN_CalendarPane) Then
				SayLine ()
		Return
	EndIf
EndIf
If (GetWindowName (GetRealWindow (HWnd)) == wn_WritingToolsDialogue) &&
(GetCurrentControlid () == CID_SpellChecker) Then
	Return
endIf
if (GetScreenEcho() > 0) then
	SayFormattedMessage (OT_NO_DISABLE, buffer)
EndIf
EndFunction

string Function getGroupBoxName ()
var
	Handle hWnd,
	int iControlId,
	string sWindowText,
	String sWindowName

let sWindowName = GetWindowName (GetRealwindow (GlobalFocuswindow)) ;assigns the window name to variable
let iControlId = getControlId (GlobalFocusWindow)
/*If ((sWindowName == wn_Environment) ||
(sWindowName == wn_DateTimeOptions) ||
(sWindowName == wn_SendOption)) &&*/
If (GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) Then
	let hWnd = GetParent (GlobalFocusWindow)
	While (GetWindowSubtypeCode (hWnd) != WT_GROUPBOX) && HWnd
		let hWnd = getPriorWindow (hWnd)
	EndWhile
	let sWindowText = GetWindowTextEx (hWnd, read_Everything, false)
else
	let sWindowText = GetGroupBoxName ()
EndIf
return sWindowText
EndFunction

int function checkMessageType (string sWindowName, handle hWnd, string sRealWindowClass )
; checks to see if the focus is in an Appointment, Task, Phone or Mail message window.
; Also checks to see if the message is a Posted or Group message view.
; Posted messages are messages to yourself.
; Group Messages are messages that are sent to another individual.
var
	int iValue,
	int iFieldPos,
string sClass

let iValue = FALSE
let sClass = GetWindowClass (GlobalFocusWindow)
if (sClass == WCN_RichEdit) Then
; Only checks the window Hierarchy position when the class is a Rich Edit.
let iFieldPos = GetWindowHierarchyX (GlobalFocusWindow)
	EndIf
If ((sWindowName == WN_PostedAppointmentWindow) ||
(sWindowName == WN_PostedTaskWindow)) &&
(iFieldPos  == 11) Then
	SayFormattedMessageBoxWindow ()
let iValue = TRUE
ElIf (sWindowName == WN_PostedNoteWindow) &&
(iFieldPos  == 6) Then
	SayFormattedMessageBoxWindow ()
let iValue = TRUE
ElIf (sWindowName == WN_PostedPhoneWindow) &&
(iFieldPos == 12) Then
	SayFormattedMessageBoxWindow ()
let iValue = TRUE
ElIf (sWindowName == WN_PostedMailWindow) &&
(iFieldPos == 2) Then
	SayFormattedMessageBoxWindow ()
let iValue = TRUE
ElIf (sRealWindowClass == WCN_AppointmentWindow) ||
(sRealWindowClass == WCN_TaskWindow) Then
	If (iFieldPos	 == 12) Then

		SayFormattedMessageBoxWindow ()
		let iValue = True
	ElIf (sClass == WCn_EDIT) Then
		SaySenderFieldPrompt ()
		let iValue = True
	EndIf
ElIf (sRealWindowClass == WCN_NoteWindow) Then
	If (iFieldPos	 == 7) Then
		SayFormattedMessageBoxWindow ()
		let iValue = True
	ElIf (sClass == WCN_EDIT) Then
		SaySenderFieldPrompt ()
		let iValue = True
	EndIf
elIf (sRealWindowClass == WCN_PhoneWindow) Then
	If (FindWindow (GetForegroundWindow (), WCN_PopupButton, CSCNull)) &&
	(iFieldPos   == 13) Then
		SayFormattedMessageBoxWindow ()
		let iValue = True
	ElIf (iFieldPos   == 12) Then
		SayFormattedMessageBoxWindow ()
		let iValue = True
	ElIf (sClass == WCN_EDIT) Then
		SaySenderFieldPrompt ()
		let iValue = True
	EndIf
elif (sRealWindowClass == WCN_MailWindow) then
	If (sClass == WCN_EDIT) Then
		SaySenderFieldPrompt ()
		let iValue = True
	EndIf
	; The subject field of the Mail Small view does not have any prompt.
	; The following test checks for this view and adds the prompt.
	If (GetWindowHierarchyX (GlobalFocusWindow) == 2) &&
	(GetMessageViewType (GlobalFocusWindow) == MSGVW_SmallView) Then
		SayControlExWithMarkup (GlobalFocusWindow, MSG_Prompt4_L) ;MSG_Prompt4_L "Subject: "
		let iValue = True
	EndIf
	; The Message box window is always the third window of the same logical level of the Hierarchy.
	If (GetWindowHierarchyX (GlobalFocusWindow) == 3) Then
		; Call the function that determines if to perform a SayAll or read the current line of a message
		SayFormattedMessageBoxWindow ()
		let iValue = TRUE
	EndIf
endIf
If (sClass == cwcIEServer) Then
; Stores the current setting of the Quick key navigation for HTML pages.
	Let giGWQuickKeyNavigation= GetJcfOption (opt_quick_key_navigation_mode)
	SayFormattedMessageBoxWindow ()
	return TRUE
EndIf
; Sets the Quick Key Navigation back to the default setting, when not in the Internet_Server window.
SetJcfOption (opt_quick_key_navigation_mode,giGWQuickKeyNavigation)
return iValue

EndFunction

Function SayFormattedMessageBoxWindow ()
Var
	string sTitle

let sTitle = GetAppTitle ()
If StringContains (sTitle, wn_to) Then
	If (GetWindowClass (GlobalFocusWindow) == cwcIEServer) Then
	; Turns off the Quick Key Navigation when editing a html message.
		SetJcfOption (opt_quick_key_navigation_mode,0)
	EndIf
	SayControlExWithMarkup (GlobalFocusWindow, MSG_Prompt1_L) ;MSG_Prompt1Prompt1_L "Message "
Else
	If iTogglePageReading then
		SayAll ()
	Else
		SayLine ()
	endIf
EndIf
EndFunction

Function ProxyDialogue ()
Var
	Handle TheParent ;Stores the parent handle

let TheParent = GetParent (GlobalFocusWindow) ;Assigns the parent window handle to variable.
;Checks to see if the current control is the proxy name.
If (GetControlId (TheParent) == CID_ProxyName) Then
	;Announce the static text which is the prior window.
	SayFormattedMessage (OT_control_name, GetWindowText (GetPriorwindow (TheParent), Read_Everything))
EndIf
;Checks to see if the focus is on the list box or not.
If (GetCurrentControlId () == CID_ProxyListBox) Then
	;Anounces the static text which is the previous window.
	SayFormattedMessage (OT_control_name, GetWindowText (GetPriorwindow (GlobalFocuswindow), Read_Everything))
EndIf
EndFunction

Function Find55Dialogue ()
Var
	Handle TheParent, ;Assigns the parent handle.
	Handle HWnd, ;tempory window handle variable
	string sMessage

let TheParent = GetParent (GlobalFocusWindow) ;Assigns the parent handle to variable
;Checks to see if the parent control id is the combo box of the find dialogue.
If (GetControlId (TheParent) == CID_FindComboBox) Then
	;Announces the prompt associated with the full text search combo box
	let sMessage = FormatString (ssc1, GetWindowText (GetPriorWindow (TheParent), Read_Everything))
	SayFormattedMessage (OT_control_name, sMessage)
EndIf
;Checks to see if the control id is the Advance find button.
;If so, then the static text associated with the button is announced.
If (GetCurrentControlId () == CID_FindAdvanceButton) then
	;Announces the current rule for the advance find button.
	let sMessage = FormatString (MSG_Prompt6_L, GetWindowText (GetNextWindow (GetNextWindow (GlobalFocusWindow)), Read_Everything))
		SayFormattedMessage (OT_control_name, sMessage)
endIf
If (GetCurrentControlID () == CID_FIND55SUBJECT) Then
	let sMessage = FormatString (ssc1, GetWindowText (GetFirstChild (GetPriorwindow (getPriorWindow (globalFocuswindow))), Read_Everything))
	SayFormattedMessage (OT_control_name, sMessage)
EndIf
If (GetCurrentControlID () == CID_FIND55AUTHOR) Then
	let sMessage = FormatString (ssc1, GetWindowText (GetPriorWindow (globalFocuswindow), Read_Everything))
	SayFormattedMessage (OT_control_name, sMessage)
endIf
If (GetCurrentControlID () >= CID_FIND55MAILITEM) && (GetCurrentControlID () <= CID_FIND55DOCUMENTITEM) Then
	let Hwnd = FindDescendantWindow (TheParent, CID_FIND55ITEM)
	SayFormattedMessage (OT_control_name, GetWindowText (HWnd, Read_Everything))
endIf
If (GetCurrentControlID () >= CID_FIND55RECEIVED) && (GetCurrentControlID () <= CID_FIND55DRAFT) Then
	let Hwnd = FindDescendantWindow (TheParent, CID_FIND55ITEMSOURCE)
	SayFormattedMessage (OT_control_name, GetWindowText (HWnd, Read_Everything))
endIf
If (GetCurrentControlID () == CID_FIND55DATERANGE) ||
(GetCurrentControlID () == CID_FIND55LOOKIN) THEN
	SayFormattedMessage (OT_control_name, GetWindowText (GetPriorwindow (GlobalFocuswindow), Read_Everything))
endIf
EndFunction

Void Function FilterAdvanceDialogue ()
Var
	Int FilterNo, ;Stores the filter number.
	string sMessage

;Checks to see if the control id falls between the Filter (condition) combo box and the operator button.
;Each time a condition is created and the user uses a logical operator, Groupwise assigns a new control id
;to the condition combo box.	As far as I know, the condition combo boxes stay in the 1300 range and since the
;operator button starts at 1400, therefore the possible maximum number of conditions are about 99.
If (GetCurrentControlId () >= CID_FilterAdvanceComboBox) &&
(GetCurrentcontrolid () < CID_FilterAdvanceOperatorButton) Then		;If the current control id is the same as 1300, assign 1 to the variable.
;Checks to see if the CID_FilterAdvanceComboBox (control id 1300) is present on the screen.
;This is done because when you create a new condition, the first control id is 1300 and every condition combo box from
;that point is increased by one.  E.G.	The second condition combo box has a control id of 1301, etc.
;If you are editing a condition, then the first condition combo box is 1301, therefore a different calculation has to be used.
	If FindDescendantWindow (GetRealWindow (GlobalFocusWindow), CID_FilterAdvanceComboBox) Then
		;Subtract the CID_FilterAdvanceComboBox from the current control id and add one to get the condition number.
		let FilterNo = (GetCurrentcontrolId () - CID_FilterAdvanceComboBox) + 1
	Else
		;Subtract the CID_FilterAdvanceComboBox from the current control id to get the condition number.
		let FilterNo = GetCurrentcontrolId () - CID_FilterAdvanceComboBox
	endIf
	let sMessage = FormatString (MSG_Prompt5_L, IntToString (filterNo))
	SayFormattedMessage (OT_CONTROL_NAME, sMessage) ;MSG_Prompt5_L "Condition: "
EndIf
	EndFunction

Int Function DefineRule ()
Var
	int iValue,
	Handle Hwnd,
	String TheParentClass,
	Int TheControlId,
	Int TheParentControlId,
	Handle TheParent

let iValue = FALSE
let TheParent = GetParent (GlobalFocusWindow)
let TheParentClass = GetWindowClass (TheParent)
let TheControlId = GetCurrentControlId ()
let TheParentControlId = GetControlId (TheParent)
; the following if tests fixes problems with group boxes or prompts not being correctly spoken.
If (TheParentControlId == CID_NewRuleEventButton) Then
	SayControlExWithMarkup (GlobalFocusWindow, GetObjectName (), GetObjectType (), GetObjectState (), GetWindowText (GetPriorwindow (TheParent), Read_Everything))
	let iValue = TRUE
EndIf
If (TheControlId >= CID_MailItemButton) && (TheControlId <= CID_NoteItemButton) Then
	let Hwnd = FindDescendantWindow (TheParent, CID_MailItemButton)
	SayControlExWithMarkup (GlobalFocusWindow, GetObjectName (), GetObjectType (), GetObjectState (), GetWindowText (GetPriorwindow (Hwnd), Read_Everything))
	let iValue = TRUE
endIf
If (TheControlId >= CID_RecievedButton) && (ThecontrolId <= CID_DraftsButton) Then
	let Hwnd = FindDescendantWindow (TheParent, CID_RecievedStaticText)
	SayControlExWithMarkup (GlobalFocusWindow, GetObjectName (), GetObjectType (), GetObjectState (), GetWindowText (Hwnd, Read_Everything))
	let iValue = TRUE
endIf
If TheControlId == CID_ConditionButton Then
	let HWnd = FindDescendantWindow (TheParent, CID_ConditionPrompt)
	SayControlExWithMarkup (GlobalFocusWindow, GetObjectName (), GetObjectType (), GetObjectState (), GetWindowText (GetNextWindow (HWnd), Read_Everything))
	SayFormattedMessage (OT_control_name, GetWindowText (GetNextWindow (GlobalFocuswindow), Read_Everything))
	let iValue = TRUE
EndIf
If (ThecontrolId == 25) Then
	let HWnd = FindDescendantWindow (TheParent, CID_AppointmentConflictButton)
	SayControlExWithMarkup (GlobalFocusWindow, GetObjectName (), GetObjectType (), GetObjectState (), GetWindowText (GetNextWindow (HWnd), Read_Everything))
	let iValue = TRUE
endIf
return iValue
EndFunction

Function BusySearchDialogue ()
Var
	Int TheControlId

let TheControlId = GetControlId (GetParent (GlobalFocuswindow))
If (ThecontrolId == CID_BusySearchTo) Then
	SayFormattedMessage (OT_control_name, MSG_Prompt2_L) ;MSG_Prompt2_L "To: "
EndIf
If (TheControlId == CID_BusySearchDateButton) Then
	SayFormattedMessage (OT_control_name, MSG_Prompt2_L) ;MSG_Prompt2_L "To: "
EndIf
EndFunction

Function PhoneMessageWindow ()
Var
	Int TheControlId, ;contains the control id
	Handle HWnd, ;contains window handle
	String TheTitle ;Contains the window title

;Stores the window title into the TheTitle variable.
let TheTitle = GetWindowName (GetRealWindow (globalFocuswindow))

;The following if test checks to see if the current window with focus is a Window class of edit.
;If so, then the focus is on either the To, CC and BC fields of a message.

if (GWVersion>=653) then
	SayFieldPrompt( GlobalFocusWindow, " ");sWindowName )
else
	if (GetWindowClass (GlobalFocusWindow) == WCN_Edit) Then
		SaySenderFieldPrompt ()
	endif
endif

;Store the control id into the TheControlId variable.
let TheControlId = GetControlId (GlobalFocusWindow)
If (!FindDescendantWindow (GetRealwindow (GlobalFocusWindow), CID_StandardButton)) Then
	If FindDescendantWindow (GetRealWindow (GlobalFocusWindow), Cid_PhoneTo) Then
		let TheControlId = TheControlId - 1
	EndIf
EndIf
If (TheControlId == CID_PhoneMessageBox) Then
;	SayControlExWithMarkup (GlobalFocusWindow, MSG_Prompt1_L) ;MSG_Prompt1Prompt1_L "Message "
	SayFormattedMessageBoxWindow ()
	Return
EndIf
SayWindowTypeAndText (globalFocusWindow)
EndFunction

Function SayFocusedWindow ()

; If this window is the same as the last window we 'spoke', set flag TRUE
;
var int bSayFocusWindowSameAsLast
if (GlobalFocusWindow == g_hwndLastSayFocusWindow) then
	let bSayFocusWindowSameAsLast = TRUE
else
	let bSayFocusWindowSameAsLast = FALSE
endif
let g_hwndLastSayFocusWindow = GlobalFocusWindow	; Save for next time we are called

; If using version 6.5.3 then handle it with the 6.5.3 routine.
; if not handled, fall back to older stuff
if (GWVersion>=653) then
	if (HandleGW653(GlobalFocusWindow)) then
		return
	endif
endif

;	SayControlExDebug( GlobalFocusWindow )
;	SayControlExWMDebug( GlobalFocusWindow )
;	SayVariousDebug(  )

Var
	String TheWindowName, ;Gets the current window name.
	String TheRealWindowClass, ;Stores the real window class
	Handle HWnd, ;stores the handle of the window
	String TheClass, ;stores the window class
	int iControlId, ; control id of the current control id
	int iParentControlId, ; control id of the parent control.
	string sGroupBox, ; stores the groupBox name
	string sWindowText ; stores the window text.

let TheWindowName = GetWindowName (GetRealwindow (GlobalFocuswindow)) ;assigns the window name to variable
let TheClass = GetWindowClass (GlobalFocusWindow) ;assigns the window class to variable
let HWnd = GetRealwindow (GlobalFocusWindow) ;Assigns the real window handle to variable
let TheRealWindowClass = GetWindowclass (HWnd) ;assigns the real window class to variable

; Checks to see which message view is active, if any.
if (GWVersion>=653) then
	if (CheckFieldPrompt( GlobalFocusWindow, TheRealWindowClass )) then
		return
	EndIf
else
	if CheckMessageType (TheWindowName, HWnd,TheRealWindowClass) Then
		return
	endif
endif

;checks to see if the current control is a menu button or not.
If (GetWindowClass (GetParent (GlobalFocusWindow)) == WCN_PopupButton) Then
	let sWindowText = GetWindowName(GetPriorWindow(GetParent(GlobalFocusWindow))) + " " + Msg_Prompt11_L + " " + GetWindowText (GlobalFocusWindow, FALSE) + " selected"
	SayString (sWindowText)
	Return
EndIf

;The purpose for the following if test, is to read out buttons labels correctly.
;JAWS does not read out the graphic label attached to Bit map buttons automatically in Groupwise.
;But JAWS has no problems with Text labelled Buttons.
;all bit map buttons have graphic labels associated with them.
;The first condition of the If test, checks to see if the control is a button.
;If it is, then checks the length of the character.
;all text labelled buttons will return a lenght of one when you use the GetCharacter function, making the test false.
If (GetWindowTypeCode (GlobalFocusWindow)  == WT_Button) &&
(StringLength (GetCharacter ()) > 1)	Then
;	Pause ()
	SayControlExWithMarkup (GlobalFocusWindow, GetCharacter ()) ;announces the graphic attached to the bit map button.
	Return
EndIf
if (GWVersion >= 653) Then
	;Checks to see if the focus is in the appointment, task or note panes.
	If (TheClass ==  WCN_CalendarPane) Then
			SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
			Return
	endIf
else
	;Checks to see if the window title is the Calendar Day view.
	If (GetAppTitle () == wn_DayWindow) Then
		;Checks to see if the focus is in the appointment, task or note pains.
		If (TheClass ==  WCN_CalendarPane) Then
			SayFormattedMessage (OT_control_name, GetDayViewHeader ())
			Return
		endIf
		;Checks to see if the focus is in the calendar or not.
		If (TheClass == WCN_Calendar) Then
			SayCalendarDate ()
			Return
		EndIf
	EndIf
Endif

;Checks to see if the busy search dialogue is opened.
If (TheWindowName == wn_BusySearch) Then
	BusySearchDialogue ()
endIf

;Checks to see if the Find Advance, Filter or define condition  dialogues have been opened.
If (TheWindowName == wn_FindAdvanceDialogue) ||
(TheWindowName == wn_FilterDialogue) ||
(TheWindowName == wn_DefineConditionDialogue) Then
	FilterAdvanceDialogue ()
endIf

;Checks to see if the Proxy dialogue has been opened.
If (TheWindowName == wn_ProxyDialogue) Then
	ProxyDialogue ()
EndIf

;checks to see if the rule dialogue has been opened.
If (TheWindowName == wn_RulesDialogue) Then
	; the GetControlId function has to be used in the below if test,
	; because the GetCurrentControlId doesn't return the control id of the List box when it is empty.
	If (GetControlId (GlobalFocusWindow) == CID_rulesListbox) Then
		SayFormattedMessage (OT_control_name, GetWindowText (GetPriorwindow (GlobalFocuswindow), Read_Everything))
	EndIf
EndIf
;Checks to see if the New or Edit rule dialogues have been opened.
If (TheWindowName == wn_NewRuleDialogue) ||
(TheWindowName == wn_EditRuleDialogue) Then
	If DefineRule () Then
		; Control with focus required special handling and has been already announced.
		return
	EndIf
EndIf
;Checks to see if the spell checker dialogue has been opened.
If (TheWindowName == wn_WritingToolsDialogue) &&
(GetCurrentControlId () == CID_Spellchecker) Then
	SayFormattedMessage (OT_control_name, Msg_Prompt10_L) ;Msg_Prompt10_L "Spell Checker"
	SayFormattedMessage (OT_control_name, GetWindowText (FindDescendantWindow (GetRealWindow (GlobalFocusWindow), CID_NotFoundPrompt), Read_Everything))
	SayFormattedMessage (OT_control_name, GetWindowText (FindDescendantWindow (GetRealWindow (GlobalFocusWindow), CID_NotFoundWord), Read_Everything))
	Delay (5)
	TypeKey (ks1)
	Return
endIf

let iControlId = getControlId (GlobalFocusWindow)
let iParentControlId = getControlId (GetParent (GlobalFocusWindow))

;Checks to see if the Choose Appointment dialogue has been opened.
If (TheWindowName == wn_ChooseAppointmentDialogue) &&
(TheClass == WCN_TimeCalendarGrid) Then
	If (GWVersion < 600) Then
		SayFormattedMessage (OT_control_name, GetBusyAppointmentDateTime (TRUE))
		SayFormattedMessage (OT_control_name, GetBusyAppointmentDateTime (FALSE))
	else
		; Weird problem: When using arrow keys, SayFocusedWindow gets called again on first up/down arrow after getting focus
		if (!bSayFocusWindowSameAsLast) then
			SayFormattedMessage( OT_CONTROL_NAME, GetWindowText(GetPriorWindow(GlobalFocusWindow),FALSE))
			SayBusyInfo( iControlId, SBI_SAY_ALL | SBI_SAY_RECIPIENT);
		endif
	endif
	Return
endIf

;When Groupwise opens for the first time, the first item in the mailbox was not being spoken.
;The following code fixes this problem by introducing a delay.  To prevendelays in other areas of the program,
;The delay statement is only executed when the application window handle changes.
;This does not effect any other groupwise window.
	If (GetWindowTypecode (GlobalFocuswindow) == WT_ListView) &&
	(GlobalPrevApp != GetAppMainWindow (GlobalFocusWindow)) Then
;	Delay (5)
	EndIf

/*
;checks to see if the current message is a HTML message.
If (TheClass == wc_shell) ||
(TheClass == WCN_HTMLMessageWindow) Then
	SayFormattedMessage (OT_control_name, MSG_Prompt1_L)
	InvisibleCursor ()
	MoveToWindow (FindWindow (GlobalFocusWindow, cwcIEServer , cscNull))
	routePcToInvisible ()
	Return
EndIf
*/
; Handles when the quick view windows have focus.
let QuickViewHasFocus = FALSE
If (TheClass == WCN_QuickViewer) Then
;Checks to see if you are in the Quick View window.
	SayFormattedMessage (OT_control_name, msgQuickViewWindow)
	SayFormattedMessageBoxWindow	()
	let QuickViewHasFocus = TRUE
EndIf
If (TheRealWindowClass == WCN_MainWindow) &&
	(GetCurrentControlId () == 333) Then
	;Checks to see if you are in the Quick view Attachment list box.
	SayFormattedMessage(OT_CONTROL_NAME, MSG_Prompt3_S)
EndIf

If (TheWindowName == wn_Environment) &&
(GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) Then
	; Correctly announces the prompt for the edit spin boxes in the environment dialogue, contained within the Option dialogue.
	If (iParentControlId == cid_GeneralRefreshMins) ||
	(iParentControlId == cid_GeneralRefreshSecs) Then
		let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
		let sWindowText = GetWindowText (hWnd, READ_EVERYTHING)
		let hWnd = FindDescendantWindow (GetParent (hWnd), cid_GeneralRefreshStatic)
		let sWindowText = FormatString (GWMsgJoinString, GetWindowText (hWnd, Read_EveryThing), sWindowText)
		SayControlExWithMarkup (globalFocusWindow, sWindowText, cscNull, cscNull, GetGroupBoxName ())
		Return
	elIf (iParentControlId == cid_CleanUpMail) ||
	(iParentControlId == cid_CleanupAppointment) Then
		let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
		let sWindowText = GetWindowText (hWnd, READ_EVERYTHING)
		SayControlExWithMarkup (globalFocusWindow, sWindowText, cscNull, cscNull, GetGroupBoxName ())
		Return
	EndIf
EndIF

If (TheWindowName == wn_SendOption) &&
(GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) &&
(iControlId == cid_EditSpinBox) Then
	SayObjectTypeAndText ()
	SayFormattedMessage (OT_NO_DISABLE, GetWindowText (GetNextWindow (GetParent (GlobalFocusWindow)), READ_EVERYTHING), cmsgSilent )
	Return
EndIf

If StringContains (TheWindowName, wn_DocumentSetup ) &&
(GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) &&
(iControlId == cid_EditSpinBox) Then
	; announces the prompt for the edit spinBox in the Property dialogue
	let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
	SayControlExWithMarkup (globalFocusWindow, GetWindowText (hWnd, READ_EVERYTHING), cscNull, cscNull, GetGroupboxName ())
	Return
EndIf

If (TheWindowName == wn_DateTimeOptions ) Then
; Announces prompts that are not spoken by default within the Date Time Options dialogue.
; Announce the correct prompts for the spin boxes that are found in the Busy dialogue or calendar page.
	If (GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) Then
		If (iParentControlId == cid_BusyHourSpinBox) ||
		(iParentControlId == cid_CalendarHourSpinBox) ||
		(iParentControlId == cid_CalendarMinuteSpinBox) ||
		(iParentControlId == cid_BusyMinuteSpinBox) Then
			let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
			SayControlExWithMarkup (globalFocusWindow, GetWindowText (hWnd, READ_EVERYTHING), cscNull, cscNull, getGroupBoxName ())
			Return
		ElIf (iParentControlId == cid_BusyDaySpinBox) Then
			SayObjectTypeAndText ()
			SayFormattedMessage (OT_NO_DISABLE, GetWindowText (GetNextWindow (GetParent (GlobalFocusWindow)), READ_EVERYTHING), cmsgSilent )
			Return
		elIf (iParentControlId == cid_CalendarAlarmMinuteSpinBox) Then
			let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
			let sWindowText = GetWindowText (hWnd, READ_EVERYTHING)
			SayControlExWithMarkup (globalFocusWindow, sWindowText, cscNull, cscNull, sGroupBox)
			SayFormattedMessage (OT_NO_DISABLE, GetWindowText (GetNextWindow (GetParent (GlobalFocusWindow)), READ_EVERYTHING), cmsgSilent )
			Return
		EndIf
	Elif (GetDialogPageName () == dpN_Calendar) Then
		If (iControlId >= cid_AppointmentColourCheckBox) &&
		(iControlId == cid_TaskColourCheckBox) Then
			let hWnd = FindDescendantWindow (GetParent (GlobalFocusWindow), cid_AppointmentColourCheckBox)
			let sWindowText = GetWindowText (GetPriorWindow (GetPriorWindow (GetPriorWindow (hWnd))), Read_Everything)
			let sWindowText = FormatString (GWMsgJoinString, GetWindowText (GetPriorWindow (GlobalFocusWindow), read_Everything), sWindowText)
			SayControlExWithMarkup (GlobalFocusWindow, sWindowText)
			Return
		ElIf (iControlid == cid_ReminderNoteLineCheckBox) ||
		(iControlId == cid_TaskLineCheckBox) Then
			let hWnd = FindDescendantWindow (GetParent (GlobalFocusWindow), cid_AppointmentColourCheckBox)
			let sWindowText = GetWindowText (GetPriorWindow (GetPriorWindow (hWnd)), Read_Everything)


			let sWindowText = FormatString (GWMsgJoinString, GetWindowText (GetPriorWindow (GetPriorWindow (GlobalFocusWindow)), read_Everything),sWindowText)
			SayControlExWithMarkup (GlobalFocusWindow, sWindowText)
			Return
		EndIf
	EndIf
EndIf

If (TheWindowName == wn_SecurityOptions)  Then
	; Announces prompts for the security Options dialogue.
	If (iParentControlid == cid_SecurityNameEdit) Then
		SayControlExWithMarkup (GlobalFocusWindow, GetWindowText (GetPriorWindow (GetParent (GlobalFocusWindow)), FALSE))
		Return
	ElIf (iControlId == cid_SecurityListView) Then
		SayControlExWithMarkup (GlobalFocusWindow, GetWindowText (GetPriorWindow (GlobalFocusWindow), FALSE))
		Return
	elIf (GetDialogPageName () == dpn_SecurityProxyAccess) Then
		If (iControlId == cid_ProxyAccessMailPhoneRead) ||
		(iControlId == cid_ProxyAccessAppointmentRead) ||
		(iControlId == cid_ProxyAccessReminderNoteRead) ||
		(iControlId == cid_ProxyAccessTaskRead) Then
			let sWindowText = FormatString (GWMsgJoinString, getWindowText (GetPriorWindow (GlobalFocusWindow), READ_EVERYTHING), getControlName ())
			SayControlExWithMarkup (GlobalFocusWindow, SWindowText)
			Return
		ElIf (iControlId == cid_ProxyAccessMailPhoneWrite) ||
		(iControlId == cid_ProxyAccessAppointmentWrite) ||
		(iControlId == cid_ProxyAccessReminderNoteWrite) ||
		(iControlId == cid_ProxyAccessTaskWrite) Then
			let sWindowText = FormatString (GWMsgJoinString, getWindowText (GetPriorWindow (GetPriorWindow (GlobalFocusWindow)), READ_EVERYTHING), getControlName ())
			SayControlExWithMarkup (GlobalFocusWindow, SWindowText)
			Return
		EndIf
	EndIf
EndIf

If (TheWindowName == wn_FindDialogue) Then
;Checks to see if the find dialogue is opened (not the find text dialogue).
	Find55Dialogue ()
EndIf
SayFocusedObject ()
EndFunction

Script SayNextLine ()
Var
	String sClass,
	Int iTypecode,
	int iControlId

let sClass = GetWindowClass (GlobalFocusWindow)
let ITypeCode = GetWindowTypeCode (globalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)

If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (iTypeCode == WT_ListView) Then
		NextLine ()
		SayLine ()
		return
	endIf ;(TheTypeCode == WT_ListView)
	;Announce the New date when focus is on the Calendar in the Day Calendar view.
	If (GetAppTitle () == wn_Daywindow) Then
		NextLine ()
		If (sClass == WCN_Calendar) Then
			SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		EndIf
		Return
	EndIf
	If (sClass == WCN_TimeCalendarGrid ) then
		if (GWVersion <= 600) then
			if (GetDialogPageName () == ssc3) Then
				NextLine ()
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (FALSE))
				Return
			endif
		else
			NextLine()
			if (iControlId == CID_CAT_AVL_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_TIME | SBI_SAY_FREEBUSY )
			elif (iControlId == CID_CAT_IND_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_RECIPIENT | SBI_SAY_FREEBUSY)
			endif
			return
		Endif
	EndIf
EndIf
PerformScript SayNextLine()
EndScript

Script SayPriorLine()
Var
	String TheClass,
	Int TheTypecode,
	int iControlId

;Let TheClass = GetWindowClass (GetParent (GlobalFocusWindow))
let TheClass = GetWindowClass (GlobalFocusWindow)
let TheTypeCode = GetWindowTypeCode (globalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)

If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (TheTypeCode == WT_ListView) Then
		PriorLine ()
		SayLine ()
			Return
	endIf ;(TheTypeCode == WT_ListView)
	If (GetAppTitle ()== wn_Daywindow) Then
		PriorLine ()
		If (GetWindowclass (GetFocus ()) == WCN_Calendar) Then
			SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		EndIf
		Return
	EndIf
	If (TheClass == WCN_TimeCalendarGrid) then
		if (GWVersion <= 600) then
			if (GetDialogPageName () == ssc3) Then
				PriorLine ()
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (FALSE))
				Return
			endif
		else
			PriorLine()
			if (iControlId == CID_CAT_AVL_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_TIME | SBI_SAY_FREEBUSY )
			elif (iControlId == CID_CAT_IND_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_RECIPIENT | SBI_SAY_FREEBUSY)
			endif
			Return		
		endif
	EndIf
EndIf
PerformScript SayPriorLine()
EndScript

Script JawsPageDown ()
Var
	String TheClass,
	String RealWindowClass,
	Int TheTypecode

let TheClass = GetWindowClass (GetParent (GlobalFocusWindow))
let RealWindowClass = GetWindowClass (GetRealWindow (GlobalFocuswindow))
let TheTypeCode = GetWindowTypeCode (globalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (TheTypeCode == WT_ListView) Then
		JawsPageDown ()
		SayLine ()
		Return
	endIf ;(TheTypeCode == WT_ListView)
	If (GetAppTitle ()== wn_Daywindow) Then
		JAWSPageDown ()
		If (GetWindowclass (GetFocus ()) == WCN_Calendar) Then
			SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		EndIf
		Return
	EndIf
	If (RealWindowClass == WCN_MailWindow) ||
	(RealWindowClass == WCN_TaskWindow) ||
(RealWindowClass == WCN_PhoneWindow) ||
(RealWindowClass == WCN_AppointmentWindow) ||
(RealWindowClass == WCN_NoteWindow) Then
				JawsPageDown ()
		SayFormattedMessageBoxWindow ()
		Return
	endIf
EndIf
PerformScript JawsPageDown ()
EndScript

Script JawsPageUP ()
Var
	String TheClass,
	String RealWindowClass,
	Int TheTypecode

let TheClass = GetWindowClass (GetParent (GlobalFocusWindow))
let RealWindowClass = GetWindowClass (GetRealWindow (GlobalFocuswindow))
let TheTypeCode = GetWindowTypeCode (globalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (TheTypeCode == WT_ListView) Then
		JawsPageup ()
		SayLine ()
		Return
	endIf ;(TheTypeCode == WT_ListView)
	If (GetAppTitle ()== wn_Daywindow) Then
		JAWSPageUp ()
		If (GetWindowclass (GetFocus ()) == WCN_Calendar) Then
			SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		EndIf
		Return
	EndIf
If (RealWindowClass == WCN_MailWindow) ||
(RealWindowClass == WCN_TaskWindow) ||
(RealWindowClass == WCN_PhoneWindow) ||
(RealWindowClass == WCN_AppointmentWindow) ||
(RealWindowClass == WCN_NoteWindow) Then
		JawsPageUp ()
		SayFormattedMessageBoxWindow ()
		Return
	endIf
EndIf
PerformScript JawsPageUp()
EndScript

Script SayNextCharacter ()
Var
	String TheClass,
	Int CursorType,
	int iControlId

let TheClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (GetAppTitle () == wn_Daywindow) Then
		NextCharacter ()
		SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		Return
	EndIf
	If (TheClass == WCN_TimeCalendarGrid) Then
		NextCharacter ()
		If (GWVersion < 600) then
			If (GetDialogPageName () == DPN_AvailableTime) Then
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TRUE))
			Else
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (FALSE))
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TrUE))
			EndIf
			Return
		else
			if (iControlId == CID_CAT_AVL_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_DATE | SBI_SAY_FREEBUSY)
			elif (iControlId == CID_CAT_IND_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_CHANGED_DATE | SBI_SAY_TIME | SBI_SAY_FREEBUSY )
			endif
			Return
		endif
	EndIf
	If (Theclass == WCN_AttachmentWindow) Then
		SaveCursor ()
	let CursorType = GetActiveCursor ()
	RestrictCursor (On)
	RouteJAWSToPc ()
	JawsCursor ()
	NextChunk ()
	LeftMouseButton ()
	RestrictCursor (Off)
	RestoreCursor ()
	SetActiveCursor (CursorType)
	EndIf
endIf
PerformScript SayNextCharacter()
EndScript

Script SayPriorCharacter ()
Var
	Int Cursortype,
	String TheClass,
	int iControlId

let TheClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (GetAppTitle () == wn_DayWindow) Then
		PriorCharacter ()
		SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		Return
	EndIf	
	If (TheClass == WCN_TimeCalendarGrid) Then
		PriorCharacter ()
		if (GWVersion < 600) Then
			If (GetDialogPageName () == ssc3) Then
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TRUE))
			Else
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (FALSE))
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TRUE))
			EndIf
			Return
		else
			if (iControlId == CID_CAT_AVL_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_DATE | SBI_SAY_FREEBUSY)
			elif (iControlId == CID_CAT_IND_GRID) then
				SayBusyInfo( iControlId, SBI_SAY_CHANGED_DATE | SBI_SAY_TIME | SBI_SAY_FREEBUSY )
			endif
			Return
		endif
	EndIf
	If (TheClass == WCN_AttachmentWindow) Then
		SaveCursor ()
	let CursorType = GetActiveCursor ()
	RestrictCursor (On)
	RouteJAWSToPc ()
	JawsCursor ()
	PriorChunk ()
	LeftMouseButton ()
	RestrictCursor (off)
	RestoreCursor ()
	SetActiveCursor (CursorType)
	EndIf
endIf
PerformScript SayPriorCharacter()
EndScript

Script SayCharacter ()
Var
	Int Cursortype,
	String TheClass,
	int iControlId

let TheClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (GetAppTitle () == wn_DayWindow) Then
		SayFormattedMessage (OT_NO_DISABLE, GetCalendarViewDate ())
		Return
	EndIf
	If (TheClass == WCN_TimeCalendarGrid) Then
		if (GWVersion < 600) then
			If (GetDialogPageName () == ssc3) Then
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TRUE))
			Else
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (FALSE))
				SayFormattedMessage (OT_NO_DISABLE, GetBusyAppointmentDateTime (TRUE))
			EndIf
			Return
		else
			SayBusyInfo( iControlId, SBI_SAY_ALL );
			return
		endif
	EndIf
endIf
PerformScript SayCharacter()
EndScript

Script JawsHome ()
Var
	int TheTypeCode

let TheTypeCode = GetWindowTypeCode (globalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (TheTypeCode == WT_ListView) Then
		JawsHome ()

		SayLine ()
		Return
	endIf ;(TheTypeCode == WT_ListView)
EndIf
PerformScript JawsHome ()
EndScript

Script JawsEnd ()
Var
	int TheTypeCode

let TheTypeCode = GetWindowTypeCode (globalFocusWindow)
If (GetActiveCursor () == CURSOR_PC) &&
(GetMenuMode () == INACTIVE) Then
	If (TheTypeCode == WT_ListView) Then
		JawsEnd ()
		SayLine ()
			Return
		endIf ;(TheTypeCode == WT_ListView)
EndIf
PerformScript JawsEnd ()
EndScript

Script ScreenSensitiveHelp ()
; to respect the new AppFileTopic differences
If (IsSameScript ()) then
	AppFileTopic (topic_Groupwise)
	Return
EndIf
If (GetWindowClass(GlobalFocusWindow) == WCN_TimeCalendarGrid ) then
	var string sMessageLong,
		string sMessageShort
	if (GetControlId(GlobalFocusWindow) == CID_CAT_AVL_GRID) then
		let sMessageLong = FormatString( msgSSH_AvailGrid_L )
		let sMessageShort = FormatString( msgSSH_AvailGrid_S )
	else
		let sMessageLong = FormatString( msgSSH_DetailGrid_L )
		let sMessageShort = FormatString( msgSSH_DetailGrid_S )
	endif
	SayFormattedMessage( ot_User_Buffer, sMessageLong, sMessageShort )
	Return
endif

PerformScript ScreenSensitiveHelp ()
EndScript

Script SayWindowPromptAndText ()
var
	handle hWnd,
	int iSubType,
	int nMode
Let hWnd = GetCurrentWindow ()
Let iSubType = GetWindowSubTypeCode (hWnd)
If ! iSubType then
	Let iSubType = GetObjectSubTypeCode ()
EndIf
let nMode=smmTrainingModeActive()
smmToggleTrainingMode(TRUE)
SayFocusedWindow ()
SayTutorialHelp (iSubType, TRUE)
SayTutorialHelpHotKey (hWnd, TRUE)
smmToggleTrainingMode(nMode)
EndScript

Function SayCalendarDate ()
SayFormattedMessage (ot_control_name, MSG_Prompt12_L) ;MSG_Prompt12_L "Date: "
SayFormattedMessage (ot_no_disable, GetCalendarViewDate  ())
EndFunction

Script ReplyToMessage ()
SpeechOff ()
TypeKey (ks12)
TypeKey (ks13)
SpeechOn ()
EndScript
Script ForwordMail ()
SpeechOff ()
TypeKey(ks12)
TypeKey (ks14)
SpeechOn ()
EndScript

Script ScriptFileName ()
ScriptAndAppNames(msgScriptKeyHelp1_L)
EndScript

Void Function GeneralGroupwiseHelp ()
If UserBufferIsActive () then
	UserBufferDeactivate ()
EndIf
	SayFormattedMessage (ot_USER_BUFFER, msgHotKeyHelp1_L, msgHotKeyHelp1_S)
EndFunction

Script msgHotKeyHelp ()
If Not DialogActive () Then
	GeneralGroupwiseHelp ()
	Return
EndIf
msgHotKeyHelpDefault ()
EndScript

Script MoveToNextMessage ()
TypeKey (ks15) ;moves to the next message.
EndScript

Script MoveToPriorMessage ()
TypeKey (ks16) ;moves to the prior message.
EndScript

Script WindowKeysHelp  ()
Var
	String RealWindowClass

let RealWindowClass = GetWindowClass (GetRealWindow (GlobalFocuswindow))
If UserBufferIsActive () then
	UserBufferDeactivate ()
EndIf
If (RealWindowClass == WCN_MailWindow) ||
(RealWindowClass == WCN_TaskWindow) ||
(RealWindowClass == WCN_PhoneWindow) ||
(RealWindowClass == WCN_AppointmentWindow) ||
(RealWindowClass == WCN_NoteWindow) Then
	SayFormattedMessage (ot_USER_BUFFER, msgWindowKeysHelp1_L, msgWindowKeysHelp1_S)
	Return
EndIf
If (RealWindowclass == WCN_MainWindow) Then
	SayFormattedMessage (ot_USER_BUFFER, msgWindowKeysHelp2_L, msgWindowKeysHelp2_S)
	Return
endIf
WindowKeysHelpDefault ()
endScript

Script AutoSelect ()
TypeCurrentScriptKey ()
Pause() ; !!Let GroupWIse process the button and update the screen text.  Otherwise, JAWS speaks old information.
If (GetWindowName (GetRealWindow (GlobalFocusWindow)) == wn_ChooseAppointmentTime) Then
	if (GWVersion < 600) then
		SayFormattedMessage (ot_no_disable, GetBusyAppointmentDateTime (TRUE))
		SayFormattedMessage (ot_no_disable, GetBusyAppointmentDateTime (FALSE))
		Return
	else
		var int iControlId
		let iControlId = GetControlId(GlobalFocusWindow)
		SayBusyInfo( iControlId, SBI_SAY_TIME | SBI_SAY_CHANGED_DATE | SBI_SAY_FREEBUSY )
		return
	endif
endIf
EndScript


Script DelegateMessage ()
SpeechOff ()
TypeKey(ks12)
TypeKey(ks10)
SpeechOn ()
EndScript

Script MoveMessageToFolder ()
SpeechOff ()
TypeKey (ks20)
TypeKey (ks21)
SpeechOn ()
EndScript

Script JawsDelete ()
Var
	String TheClass,
	int TheTypeCode

let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
let TheClass = GetWindowClass (GetParent (getCurrentwindow ()))
If (TheTypeCode == WT_ListView) Then
	TypeKey (ks22)
	Delay (2)
	SayLine ()
	Return
EndIf
If (GetWindowclass (globalFocusWindow) == WCN_QUICKVIEWER) Then
TypeKey(ks22)
	Delay (5)
	SayFormattedMessageBoxWindow ()
	Return
endIf
PerformScript JawsDelete()
EndScript

function ScreenSensitiveHelpForKnownClasses (Int WinTypeCode)
If UserBufferIsActive () then
	UserBufferDeactivate ()
EndIf
If (GetWindowClass (GetParent (GetCurrentWindow ())) == WCN_PopupButton) Then
	SayFormattedMessage (ot_USER_BUFFER, msgScreenSensitiveHelp1_L, msgScreenSensitiveHelp1_S)
	AddHotKeyLinks ()
	Return
EndIf
ScreenSensitiveHelpForKnownClasses (WinTypeCode)
EndFunction

Script RecipientFocus ()
Var
	int PriorCursor,
	String RealWindowClass

let RealWindowClass = GetWindowClass (GetRealWindow (GlobalFocuswindow))
If (RealWindowClass == WCN_MailWindow) ||
(RealWindowClass == WCN_FrameListBox) ||
(RealWindowClass == WCN_TaskWindow) ||
(RealWindowClass == WCN_PhoneWindow) ||
(RealWindowClass == WCN_AppointmentWindow) ||
(RealWindowClass == WCN_NoteWindow) Then
	If (GetWindowClass (GlobalFocusWindow) == WCN_Edit) ||
	(GetWindowClass (GlobalFocusWindow) == WCN_NewListbox10) Then
		let PriorCursor = GetActiveCursor ()
		SaveCursor ()
		If (GetWindowClass (GlobalFocusWindow) != WCN_NewListbox10) Then
			RouteInvisibleToPc ()
			RouteJAWSToInvisible ()
			InvisibleCursor ()
			NextLine ()
			;Checks to see if the recipient list box is present.
			If (GetWindowClass (GetCurrentWindow ()) == WCN_NewListbox10) Then
				;Moves the focus to the recipient list box.
				SetFocus (GetCurrentWindow ())
			Else
				SayFormattedMessage (OT_error, Msg1_L, Msg1_S) ;Msg1_L "Recipient list box not found."
		endIf
		Else
			RouteInvisibleToJaws ()
			InvisibleCursor ()
			SetFocus (GetCurrentWindow ())
		endIf
		RestoreCursor ()
		SetActiveCursor (PriorCursor)
	EndIf
endIf
EndScript

Int Function SaveApplicationSettings ()
Var
	int iReturn

let iReturn = IniWriteInteger (Section_ApplicationVerbositySettings, hKey_ColumnLabels, iToggleColumnLabelReading, jsiFileName)
let iReturn = IniWriteInteger (Section_ApplicationVerbositySettings, hKey_QuickView, iToggleQuickViewReading	, jsiFileName)
let iReturn = IniWriteInteger (Section_ApplicationVerbositySettings, hKey_ReadMessage, iTogglePageReading, jsiFileName)
return iReturn
EndFunction

String Function ToggleColumnLabelReading (int iRetCurVal)
if not iRetCurVal then
	;update the value
	let iToggleColumnLabelReading=!iToggleColumnLabelReading
EndIf
If iToggleColumnLabelReading Then
	return MSG_ON	; Column Labels Read
else
	return MSG_OFF	; Column Labels Not Read
EndIf
EndFunction
	 string function TogglePageReading (int iRetCurVal)
if not iRetCurVal then
	;update the value
	let iTogglePageReading=!iTogglePageReading
EndIf
If iTogglePageReading Then
	return Msg2_S	;announce the whole message window.
else
	return Msg3_S	;anounce lines only.
EndIf
EndFunction

string function ToggleQuickView (int iRetCurVal)
if not iRetCurVal then
	;update the value
	let iToggleQuickViewReading=!iToggleQuickViewReading
EndIf
If iToggleQuickViewReading Then
	return MSG5_S
else
	return MSG6_S
endIf
EndFunction

Script AdjustJAWSVerbosity ()
var
	string list,
	int PrevQuickView,
	int PrevMessageRead,
	int PrevColumnLabelRead

if InHJDialog () then
	SayFormattedMessage (ot_error, cMSG337_L)
	return
endIf
if (IsSpeechOff ()) then
	PerformScript MuteSynthesizer()
	return
endif
;Store the current settings to compare after the verbosity dlg has closed.
let prevQuickView = iToggleQuickViewReading
let PrevMessageRead = iTogglePageReading
let PrevColumnLabelRead = iToggleColumnLabelReading

let list = StrGrpwiseVerbosityItems + cStrDefaultList()
DlgSelectFunctionToRun (list, AdjustJawsVerbosityDialogName, false)
If (PrevMessageRead != iTogglePageReading) ||
   (PrevQuickView != iToggleQuickViewReading) ||
   (PrevColumnLabelRead != iToggleColumnLabelReading) Then
	if saveApplicationSettings() then
		SayFormattedMessage (ot_jaws_message, msgAppSettingsSaved1_L, cmsgSilent)
	else
		SayFormattedMessage (ot_error, msgAppSettingsNotSaved1_L, cmsgSilent)
	endIf
EndIf
EndScript

Script RightMouseButton ()
SayFormattedMessage (OT_status, cmsg151_L) ;"right mouse button"
If IsPCCursor () Then
	SaveCursor ()
	RouteJawsToPc ()
	JawsCursor ()
	RightMouseButton ()
	RestoreCursor ()
	PcCursor ()
	Return
EndIf
RightMouseButton()
EndScript

Script downcell ()
If (GetWindowClass (GetRealWindow (globalFocuswindow)) ==	WCN_MainWindow) &&
(GetWindowTypeCode (GlobalFocusWindow) == WT_LISTVIEW) Then
	TypeKey (ks23)
	Delay (2)
	SayLine ()
Else
	PerformScript DownCell()
EndIf
EndScript

Script upcell ()
If (GetWindowClass (GetRealWindow (globalFocuswindow)) ==	WCN_MainWindow) &&
(GetWindowTypeCode (GlobalFocusWindow) == WT_LISTVIEW) Then
	TypeKey (ks24)
	Delay (2)
	SayLine ()
Else
	PerformScript DownCell()
EndIf
EndScript

Script QuickViewNextAttachment ()
If (GetWindowClass (globalFocusWindow) == WCN_QuickViewer) Then
	TypeKey (ks25)
		SayFormattedMessageBoxWindow ()
EndIf
EndScript

Script QuickViewNextMessage ()
If (GetWindowClass (globalFocusWindow) == WCN_QuickViewer) Then
	TypeKey (ks26)
	Delay (5)
	SayFormattedMessageBoxWindow ()
	Return
EndIf
PerformScript OpenListBox()

EndScript

Script QuickViewPriorMessage ()
If (GetWindowClass (globalFocusWindow) == WCN_QuickViewer) Then
	TypeKey (ks27)
	Delay (5)
	SayFormattedMessageBoxWindow ()
	Return
EndIf
PerformScript CloseListBox()
EndScript


Int Function BrailleAddObjectContainerName (int iSubTypeCode)
var
	int iReturnValue,
	string sWindowName,
	int iControlId,
	int iParentControlId
;let sWindowName =GetWindowName (GetRealwindow (GlobalFocuswindow)) ;assigns the window name to variable
;let iControlId = getControlId (GlobalFocusWindow)
;let iParentControlId = getControlId (GetParent (GlobalFocusWindow))
; displays the correct groupBox for the edit spin boxes in the environment dialogue, contained within the Option dialogue.
;If (sWindowName == wn_Environment) &&
If (iSubTypeCode == WT_EDIT_SPINBOX) Then
	BrailleAddString (GetGroupBoxName (), 0, 0, 0)
	let iReturnValue = TRUE
else
	let iReturnValue = FALSE
EndIf
return iReturnValue
EndFunction


int Function BrailleAddObjectName (int iSubTypeCode)
var
	int iReturnValue,
	string sWindowText,
	handle hWnd,
	string sWindowName,
	int iControlId,
	int iParentControlId

let iParentControlId = getControlId (GetParent (GlobalFocusWindow))
let sWindowName =GetWindowName (GetRealwindow (GlobalFocuswindow)) ;assigns the window name to variable
let iControlId = getControlId (GlobalFocusWindow)
; displays the correct prompt for the edit spin boxes in the environment dialogue, contained within the Option dialogue.
If (sWindowName == wn_Environment) &&
(iSubTypeCode == WT_EDIT_SPINBOX) Then
	If (iParentControlId == cid_GeneralRefreshMins) ||
	(iParentControlId == cid_GeneralRefreshSecs) Then
		let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
		let sWindowText = GetWindowText (hWnd, READ_EVERYTHING)
		let hWnd = FindDescendantWindow (GetParent (Hwnd), cid_GeneralRefreshStatic)
		let sWindowText = FormatString (GWMsgJoinString, GetWindowText (hWnd, Read_EveryThing), sWindowText)
		BrailleAddString (sWindowText, 0, 0, 0)
		let iReturnValue = TRUE
	elIf (iParentControlId == cid_CleanUpMail) ||
	(iParentControlId == cid_CleanupAppointment) Then
		let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
		BrailleAddString (GetWindowText (hWnd, READ_EVERYTHING), 0, 0, 0)
	let iReturnValue = TRUE
	EndIf
ElIf (sWindowName == wn_SecurityOptions) Then
	If (iParentControlid == cid_SecurityNameEdit) Then
		BrailleAddString (GetWindowText (GetPriorWindow (GetParent (GlobalFocusWindow)), FALSE), 0, 0, 0)
		let iReturnValue = True
	ElIf (iControlId == cid_SecurityListView) Then
		BrailleAddString (GetWindowText (GetPriorWindow (GlobalFocusWindow), FALSE), 0, 0, 0)
		let iReturnValue = True
	ElIf (GetDialogPageName () == dpn_SecurityProxyAccess) Then
		If (iControlId == cid_ProxyAccessMailPhoneRead) ||
		(iControlId == cid_ProxyAccessAppointmentRead) ||
		(iControlId == cid_ProxyAccessReminderNoteRead) ||
		(iControlId == cid_ProxyAccessTaskRead) Then
			let sWindowText = FormatString (GWMsgJoinString, getWindowText (GetPriorWindow (GlobalFocusWindow), READ_EVERYTHING), getControlName ())
			BrailleAddString (SWindowText, 0, 0, 0)
			let iReturnValue = True
		ElIf (iControlId == cid_ProxyAccessMailPhoneWrite) ||
		(iControlId == cid_ProxyAccessAppointmentWrite) ||
		(iControlId == cid_ProxyAccessReminderNoteWrite) ||
		(iControlId == cid_ProxyAccessTaskWrite) Then
			let sWindowText = FormatString (GWMsgJoinString, getWindowText (GetPriorWindow (GetPriorWindow (GlobalFocusWindow)), READ_EVERYTHING), getControlName ())
			BrailleAddString (SWindowText, 0, 0, 0)
			let iReturnValue = TRUE
		EndIf
EndIf
	ElIf (sWindowName == wn_DateTimeOptions ) Then
	; displays prompts that are not shown by default within the Date Time Options dialogue.
; display the correct prompts for the spin boxes that are found in the Busy dialogue or calendar page.
		If (GetWindowSubtypeCode (GlobalFocusWindow) == WT_EDIT_SPINBOX) Then
		If (iParentControlId == cid_BusyHourSpinBox) ||
		(iParentControlId == cid_CalendarHourSpinBox) ||

(iParentControlId == cid_CalendarMinuteSpinBox) ||
		(iParentControlId == cid_BusyMinuteSpinBox) Then
			let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
			BrailleAddString (GetWindowText (hWnd, READ_EVERYTHING), 0, 0, 0)
			let iReturnValue = TRUE
		ElIf (iParentControlId == cid_BusyDaySpinBox) Then
			let sWindowText = FormatString (GWMSGJoinString, GetObjectName (), GetWindowText (GetNextWindow (GetParent (GlobalFocusWindow)), READ_EVERYTHING))
			BrailleAddString (sWindowText, 0, 0, 0)
			let iReturnValue = TRUE
		elIf (iParentControlId == cid_CalendarAlarmMinuteSpinBox) Then
			let hWnd = GetPriorWindow (GetParent (GlobalFocusWindow))
			let sWindowText = GetWindowText (hWnd, READ_EVERYTHING)
			BrailleAddString (sWindowText, 0, 0, 0)
			let iReturnValue = TRUE
		EndIf
	Elif (GetDialogPageName () == dpN_Calendar) Then
		If (iControlId >= cid_AppointmentColourCheckBox) &&
		(iControlId == cid_TaskColourCheckBox) Then
			let hWnd = FindDescendantWindow (GetParent (GlobalFocusWindow), cid_AppointmentColourCheckBox)
			let sWindowText = GetWindowText (GetPriorWindow (GetPriorWindow (GetPriorWindow (hWnd))), Read_Everything)
			let sWindowText = FormatString (GWMsgJoinString, GetWindowText (GetPriorWindow (GlobalFocusWindow), read_Everything), sWindowText)
			BrailleAddString (sWindowText, 0, 0, 0)
			let iReturnValue = TRUE
		ElIf (iControlid == cid_ReminderNoteLineCheckBox) ||
		(iControlId == cid_TaskLineCheckBox) Then
			let hWnd = FindDescendantWindow (GetParent (GlobalFocusWindow), cid_AppointmentColourCheckBox)
			let sWindowText = GetWindowText (GetPriorWindow (GetPriorWindow (hWnd)), Read_Everything)
			let sWindowText = FormatString (GWMsgJoinString, GetWindowText (GetPriorWindow (GetPriorWindow (GlobalFocusWindow)), read_Everything),sWindowText)
		BrailleAddString (sWindowText, 0, 0, 0)
			let iReturnValue = TRUE
		EndIf
		EndIf
Else
	let iReturnValue = FALSE
EndIf
return iReturnValue
EndFunction

int Function BrailleAddObjectValue (int iSubTypeCode)
var
	int iReturnValue,
	int iParentControlId,
	handle hWnd

let iParentControlId = getControlId (GetParent (GlobalFocusWindow))
; Retrieve contents of the comboBox of the Classification Combobox in the Send dialogue, within the Option dialogue.
If (iParentControlId == cid_CLASSIFICATIONCOMBO) Then
	BrailleAddString (GetWindowText (GlobalFocusWindow, TRUE), 0, 0, 0)
	let iReturnValue = TRUE
Else
	let iReturnValue = False
EndIf
return iReturnValue
EndFunction

Script  DeleteWord()
; delete current word and speak the word the PC cursor lands on.
TypeCurrentScriptKey() ;pass it through, even if user applies keystroke in wrong situation
SaveCursor ()
PCCursor ()
Pause()
if CaretVisible() then
	SayWord()
else
	SayCurrentScriptKeyLabel ()
EndIf
RestoreCursor ()
EndScript

Script DeleteOpenItem()
; For 6.5.3 and later, "Alt+Delete" deletes the open item.
; However, it is also the key sequence for JAWS "SayActiveCursor".
; In GroupWise.jkm, the "Alt_Delete" sequence is routed to this routine.
; We simply pass it through to the application.
TypeCurrentScriptKey()
EndScript

;=======================================================================
;=======================================================================
; New functions for 6.5.3 go below here
;=======================================================================
;=======================================================================

int function HandleGW653(handle hwnd)
var
	int iControl

	let iControl = GetControlID (hwnd)

	; Handle GWHdrCtl
	; GWHdrCtl's have window class "GWHdrCtl" or have a parent that is "GWHdrCtl"
	;
	;exMessageBox( GetWindowClass(hwnd), "hwnd class", MB_OK)
	;exMessageBox( GetWindowClass(GetParent(hwnd)), "parent class", MB_OK)
	if (GetWindowClass(hwnd) == WCN_GWHDRCTL) ||
	       (GetWindowClass(GetParent(hwnd)) == WCN_GWHDRCTL) then
		if (iControl == CID_HDR_BITMAP_CLOSE_CTLID) then
			SayFormattedMessage( OT_CONTROL_NAME, "Hide the Folder List") ; string same as tooltip
			SayFormattedMessage( OT_SMART_HELP, "To Activate Press Enter Key")
		elif (iControl == CID_HDR_BITMAP_FILTER_CTLID) then
			SayString("Filter the contents of the view.")		;string same as tooltip
			SayString("Press down arrow for options.")
		elif ((iControl >= CID_HDR_PROXY_DROPDOWN_CTLID) && 
				(iControl <= CID_HDR_ACCTPROXY_DROPDOWN_CTLID)) then
			SayWindow( hwnd, READ_EVERYTHING)
			SayString("Press down arrow to list")
		elif (iControl == CID_HDR_ATTACHMENT_TEXT_ID)then
			SayWindow( hwnd, READ_EVERYTHING)
			SayString("Press down arrow to change")
		elif ((iControl == CID_HDR_TO_RECIPIENTS_TEXT_ID)||
				(iControl == CID_HDR_CC_RECIPIENTS_TEXT_ID) ||
				(iControl == CID_HDR_BC_RECIPIENTS_TEXT_ID) ||
				(iControl == CID_HDR_ALL_RECIPIENTS_TEXT_ID)) then
			if (GetWindowClass(hwnd) == WCN_GWHDRCTL) then
				; This is an address that has a popdown list
				SayString("Press Down Arrow to list all recipients")
				SayWindow( hwnd, READ_EVERYTHING)
			else
				; This an address without a popdown list
				SayControlEx( hwnd, "", " ") ;Suppress saying window type
;				SayWindow( hwnd, READ_EVERYTHING)
			endif
		elif (iControl == CID_HDR_DATE_TEXT_ID) then
;			SayControlExWithMarkup(hwnd)
			SayWindow( hwnd, READ_EVERYTHING)
		elif (iControl == CID_HDR_ICONTEXT_MAILBOX_CTLID) then
			SayWindow( hwnd, READ_EVERYTHING)
			SayFormattedMessage( OT_SMART_HELP, "To change header properties Press Shift and Enter Keys")
		else
			; Default for "GWHdrCtl"
			SayControlEx(hwnd,""," ")	;Suppress saying window type (ie read only edit)
		endif
		return TRUE
	endif
	if (GetWindowClass(hwnd) == WCN_GWSMALLMONTH) then
		SayWindow(hwnd, READ_HIGHLIGHTED)
		return TRUE
	endif
	if (GetWindowClass(hwnd) ==WCN_EDIT) then
		if(iControl == CID_CATEGORY_ID) then
			SayString(GetWindowName(hwnd))
			SayFormattedMessage( OT_SMART_HELP, "To Activate Press Any Key")
			return TRUE
		elif(iControl == CID_DAY_SPINNER && GetWindowTypeCode(GetParent(hwnd)) == WT_STATIC ) then
			SayString("Days")
		endif
	endif
  return FALSE
EndFunction


int Function SayOtherFieldPrompt( Handle hwnd, string sRealWindowClass )
; Handles  prompt for Subject, Place, Priority and Message.
var
	string		sClassName,
	string		sPrompt,
	string		sType,
	int			iPos
let sClassName = GetWindowClass( hwnd )
;
; NOTE! JAWS considers "RichEdit" and "RichEdit20W" to be equal.
; We need to make a distinction.  To accomplish this, WCN_RICHEDIT is set to
; "RichEditx".  This allows "RichEdit" compare equal to WCN_RICHEDIT and
; "RichEdit20w" to be not equal.
;
if (sClassName == WCN_RICHEDIT) then
	if (GetWindowClass(GetParent(hwnd)) == WCN_OWL_WINDOW) then
		if (sRealWindowClass == WCN_TASKWINDOW) then
			let sPrompt = "Priority:"
		elif (sRealWindowClass == WCN_APPTWINDOW) then
			let sPrompt = "Place:"
		endif
	endif
elif (sClassName == WCN_RICHEDIT20) then
	if (GetWindowClass(GetParent(hwnd)) == WCN_OWL_WINDOW) then
		let iPos = GetFieldOccurance( hwnd )
		if (iPos == 1) then
			let sPrompt = "Subject:"			; Subject is always first
		elif (iPos == 2) then
			let sPrompt = "Message:"		; This will be the compose "plain text" message window
		endif
	elif (GetWindowClass(GetParent(hwnd)) == WCN_GWQUICKVIEWERCONTENTPANE ) then
		let sPrompt = "Message:"			; This will be the view "rich text" message window
	endif
elif (sClassName ==  "Message") then
	let sPrompt = "Message:"		   ;; This will be the compose "Rich Text" message window
	let sType = "Edit"
endif
if (sPrompt != "") then
;	SayControlExWithMarkup( hwnd, sPrompt, sType )
	SayFormattedMessage( OT_CONTROL_NAME, sPrompt )
	return TRUE
endif
return FALSE
EndFunction


int Function IsAddressField( handle hwnd )
return (GetWindowClass(GetParent(hwnd))==WCN_ENTRYFIELD)
EndFunction

int function GetFieldCount( handle hwnd )
; this function returns the number of occurances of this window among its siblings
; the occurance is based on class name
var
	string sClassName,
	handle hTmp,
	int iCnt
let iCnt = 0
let sClassName = GetWindowClass( hwnd )
;exMessageBox( sClassName, "InGetFieldOccurance", MB_OK)
let hTmp = GetFirstWindow (hwnd)	; Get First Sibling
while (hTmp != 0)
	if (GetWindowClass(hTmp) == sClassName) then
		let iCnt = iCnt + 1
	endIf
	let hTmp = GetNextWindow (hTmp)
endWhile
return iCnt
EndFunction

int function GetFieldOccurance( handle hwnd )
; this function returns the occurance of this window among its siblings
; the occurance is based on class name
; the first occurance returns "1", the second returns "2", etc.
var
	string sClassName,
	handle hTmp,
	int iPos
let ipos = 1
let sClassName = GetWindowClass( hwnd )
;exMessageBox( sClassName, "InGetFieldOccurance", MB_OK)
let hTmp = GetFirstWindow (hwnd)	; Get First Sibling
while (hTmp != hwnd)
	if (GetWindowClass(hTmp) == sClassName) then
		let iPos = iPos + 1
	endIf
	let hTmp = GetNextWindow (hTmp)
endWhile
return iPos
EndFunction


int Function SayAddressFieldPrompt( handle hwnd, string sRealWindowClass)
Var
	string sPrompt,
   int iCnt,
	int iPos
if (GetWindowClass(GetParent(hwnd)) == WCN_ENTRYFIELD) then
;;	ExMessageBox( GetWindowClass(GetParent(hwnd)), "ParentClassName", MB_OK)
	let iPos = GetFieldOccurance( GetParent(hwnd) );
   let iCnt = GetFieldCount( GetParent(hwnd));
	if (iPos == 1) Then
		let sPrompt = MSG_TO_FIELD
	ElIf (iPos == 2) Then
		if (GetFieldCount( GetParent(hwnd)) > 2) then		; Check for Simple
			let sPrompt = MSG_CC_FIELD
		else
			let sPrompt = "From: "
		endif
	elif (iPos == 3) Then
		let sPrompt = MSG_BC_FIELD
	elif (iPos == 4) Then
		let sPrompt = "From: "
	EndIf
Endif
if (sPrompt != "") then
	SayFormattedMessage( OT_CONTROL_NAME, sPrompt )
	return TRUE
endif
return FALSE
EndFunction


int function SayDatePickerPrompt( handle hwnd, string sRealWindowClass )
; This function checks to see if hwnd is one of the Date Picker controls.
; If it is, it says the appropriate "prompt" for the control
; If not, it returns a null string.
;
; The "date picker" controls are a sequence of three windows:
;  
;  |
;  +-GWDatePicker	
;  | +--Edit		Start Date / End Date
;  +-RICHEDIT		Start Time / End Time or Duration.
;  +-Button			Button that brings up time dialog
;  |
;
; The first occurence will be Start Date-Time.  
; The second set will be End Date-Time (or duration, or Due Date).
;
Var
	string		sClass,
	string		sPrompt,
	string		sType,
	handle	hDP,
	handle	hParent,
	handle hPrev,
	int			iPos

let sPrompt = ""
let sType = ""
let sClass = GetWindowClass(hwnd)
if (sClass == WCN_EDIT) then
	let hDP = GetParent( hwnd )
	if (GetWindowClass(hDP)==WCN_GWDATEPICKER) then
		let iPos = GetFieldOccurance( hDP )
		if (iPos == 1) then
			let hPrev = GetPriorWindow(hDP)
			if(GetWindowClass(hPrev) == "Static") then
				let sPrompt = GetWindowText(hPrev, FALSE)
				SayControlExWithMarkup( hwnd, sPrompt, sType )
				SayString("Press Grave Accent to toggle. Press Return or Down Arrow to Open Calendar")
				return TRUE
			else
				let sPrompt = "Start Date:"
			endif
		elif (iPos == 2) then
			if (sRealWindowClass == WCN_TaskWindow) then
				let sPrompt = "Due on:"
			elif (sRealWindowClass == WCN_ApptWindow) then
				let sPrompt = "End Date:"
			endif
		endif
	endif
elif (sClass == WCN_RICHEDIT) then
	let hDP = GetPriorWindow( hwnd )
	if (GetWindowClass(hDP)==WCN_GWDATEPICKER) then
		let iPos = GetFieldOccurance( hDP )
		if (iPos == 1) then
			let sPrompt = "Start Time:"
		elif (iPos == 2) then
			if (IsWindowVisible(hDP)) then
				let sPrompt = "End Time:"
			else
				if (sRealWindowClass == WCN_TaskWindow) then
					let sPrompt = "Due in:"
				else
					let sPrompt = "Duration:"
				endif
			endif
		endif
	endif
elif (sClass == WCN_BUTTON) then
	let hDP = GetPriorWindow(GetPriorWindow(hwnd))
	if (GetWindowClass(hDP) == WCN_GWDATEPICKER) then
		let sPrompt = "Select Time Button"
		let sType = "Button"
	endif
endif
if (sPrompt != "") then
;	SayFormattedMessage( OT_CONTROL_NAME, sPrompt )
	SayControlExWithMarkup( hwnd, sPrompt, sType )
	return TRUE
endif
return FALSE
EndFunction



int function SayFieldPrompt( handle hwnd, string sRealWindowClass)
var
	int iReturn;
if (SayAddressFieldPrompt( hwnd, sRealWindowClass)) then
	return TRUE
elif (SayDatePickerPrompt( hwnd, sRealWindowClass)) then
	return TRUE
elif (SayOtherFieldPrompt( hwnd, sRealWindowClass)) then
	return TRUE
endif
return FALSE
EndFunction


int function CheckFieldPrompt (handle hWnd, string sRealWindowClass )
; checks to see if the focus is in an Appointment, Task, Note, Phone or Mail message window.
; Also checks to see if the message is a Posted or Group message view.
; Posted messages are messages to yourself.
; Group Messages are messages that are sent to another individual.
var
	int iValue
;;;	int iFieldPos,
;;;	string sClass,
;;;	string sParentClass

;ExMessageBox(sWindowName,"sWindowName",MB_OK)
;ExMessageBox(sRealWindowClass,"sRealWindowClass",MB_OK)

let iValue = SayFieldPrompt( hwnd, sRealWindowClass)
return iValue
EndFunction


Void Function ClearBusy()
	let g_strLastDate = ""
	let g_strLastTime = ""
	let g_strLastDuration = ""
	let g_strLastFreeBusy = ""
EndFunction

int Function SayBusyInfo( int iControlId, int sbi_flags)
var int cid_StartDateLbl,
	int cid_StartDate,
	int cid_StartTimeLbl,
	int cid_StartTime,
	int cid_DurationLbl,
	int cid_Duration,
	int cid_FreeBusy

if (iControlId == CID_CAT_IND_GRID) then
	; These are the controls on the Individual Schedule Page.
	let cid_StartDateLbl	=	CID_CAT_IND_STARTDATE_LBL
	let cid_StartDate		=	CID_CAT_IND_STARTDATE	 
	let cid_StartTimeLbl	=	CID_CAT_IND_STARTTIME_LBL
	let cid_StartTime		=	CID_CAT_IND_STARTTIME	 
	let cid_DurationLbl		=	CID_CAT_IND_DURATION_LBL 
	let cid_Duration		=	CID_CAT_IND_DURATION	 
	let cid_FreeBusy		=	CID_CAT_IND_FREEBUSY	 
elif (iControlId == CID_CAT_AVL_GRID) then
	; These are the controls on the Available Times Page.
	let cid_StartDateLbl	=	CID_CAT_AVL_STARTDATE_LBL
	let cid_StartDate		=	CID_CAT_AVL_STARTDATE	 
	let cid_StartTimeLbl	=	CID_CAT_AVL_STARTTIME_LBL
	let cid_StartTime		=	CID_CAT_AVL_STARTTIME	 
	let cid_DurationLbl		=	CID_CAT_AVL_DURATION_LBL 
	let cid_Duration		=	CID_CAT_AVL_DURATION	 
	let cid_FreeBusy		=	CID_CAT_AVL_FREEBUSY	 
else 
	return FALSE
endif

if (sbi_flags & (SBI_SAY_RECIPIENT) && (iControlId == CID_CAT_IND_GRID)) then
	; The following 'saywindow' causes the recipient's name to be 
	; spoken before the other information.
	SayWindow( FindDescendantWindow(GetParent(GlobalFocusWindow), CID_CAT_IND_RECIPIENT_LISTBOX ), READ_HIGHLIGHTED )
endif

if (sbi_flags & (SBI_SAY_DATE | SBI_SAY_CHANGED_DATE)) then
	var string str_Date
	let str_Date = GetWindowText( FindDescendantWindow( GetParent(GlobalFocusWindow), cid_StartDate ), FALSE)
	if (sbi_flags & SBI_SAY_DATE || str_Date != g_strLastDate) then
		if (g_strLastDate == "") then
			SayString( GetWindowText( FindDescendantWindow( GetParent(GLobalFocusWindow), cid_StartDateLbl ), FALSE))
		endif
		SayString( str_Date )
		let g_strLastDate = str_Date
	endif
endif

if (sbi_flags & (SBI_SAY_TIME | SBI_SAY_CHANGED_TIME)) then
	var string str_Time
	let str_Time = GetWindowText( FindDescendantWindow( GetParent(GlobalFocusWindow), cid_StartTime ), FALSE)
	if (sbi_flags & SBI_SAY_TIME || str_Time != g_strLastTime) then
		if (g_strLastTime == "") then
			SayString( GetWindowText( FindDescendantWindow( GetParent(GLobalFocusWindow), cid_StartTimeLbl ), FALSE))
		endif
		SayString( str_Time )
		let g_strLastTime = str_Time
	endif
endif

if (sbi_flags & (SBI_SAY_DURATION | SBI_SAY_CHANGED_DURATION)) then
	var string str_Duration
	let str_Duration = GetWindowText( FindDescendantWindow( GetParent(GlobalFocusWindow), cid_Duration ), FALSE)
	if (sbi_flags & SBI_SAY_DURATION || str_Duration != g_strLastDuration) then
		if (g_strLastDuration == "") then
			SayString( GetWindowText( FindDescendantWindow( GetParent(GLobalFocusWindow), cid_DurationLbl ), FALSE))
		endif
		SayString( str_Duration )
		let g_strLastDuration = str_Duration
	endif
endif

if (sbi_flags & (SBI_SAY_FREEBUSY | SBI_SAY_CHANGED_FREEBUSY)) then
	var string str_FreeBusy
	let str_FreeBusy = GetWindowText( FindDescendantWindow( GetParent(GlobalFocusWindow), cid_FreeBusy ), FALSE)
	if (sbi_flags & SBI_SAY_FREEBUSY || str_FreeBusy != g_strLastFreeBusy) then
		SayString( str_FreeBusy )
		let g_strLastFreeBusy = str_FreeBusy
	endif
endif

; When we are on the Available Time Grid we want to say how many have responded.
; Also say this when SBI_SAY_ALL has been specified.
if ((iControlId == CID_CAT_AVL_GRID) || (sbi_flags == SBI_SAY_ALL)) then
	SayWindow( FindDescendantWindow(GetRealWindow(GlobalFocusWindow), CID_CAT_STATUSLINE), READ_EVERYTHING )
endif

return
EndFunction


Script SelectNextLine()	; shift down-arrow
var 	int iControlId,
			string sClass	
let sClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (sClass == WCN_TimeCalendarGrid ) then
	SelectNextLine()
	SayBusyInfo( iControlId, SBI_SAY_DURATION + SBI_SAY_CHANGED_FREEBUSY )
	Return;
Endif
PerformScript SelectNextLine()
EndScript

Script SelectPriorLine()		; shift up-arrow
var 	int iControlId,
			string sClass	
let sClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (sClass == WCN_TimeCalendarGrid ) then
	SelectPriorLine()
	SayBusyInfo( iControlId, SBI_SAY_DURATION  + SBI_SAY_CHANGED_FREEBUSY)
	Return;
Endif
PerformScript SelectPriorLine()
EndScript

Script SelectNextCharacter()		; shift right-arrow
var 	int iControlId,
			string sClass	
let sClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (sClass == WCN_TimeCalendarGrid ) then
	SelectNextCharacter()
	SayBusyInfo( iControlId, SBI_SAY_DURATION  + SBI_SAY_CHANGED_FREEBUSY)
	Return;
Endif
PerformScript SelectNextCharacter()
EndScript

Script SelectPriorCharacter()		; shift left-arrow
var 	int iControlId,
			string sClass	
let sClass = GetWindowClass (GlobalFocusWindow)
let iControlId = GetControlId (GlobalFocusWindow)
If (sClass == WCN_TimeCalendarGrid ) then
	SelectPriorCharacter()
	SayBusyInfo( iControlId, SBI_SAY_DURATION  + SBI_SAY_CHANGED_FREEBUSY)
	Return;
Endif
PerformScript SelectPriorCharacter()
EndScript

String Function GetInfoWindowText( handle hwnd_parent, int cid_window )
return GetWindowText( FindDescendantWindow( hwnd_parent, cid_window), FALSE )
EndFunction

Void Function SayInfoWindow( int cid_window, handle hwnd_parent )
SayString( GetInfoWindowText( hwnd_parent, cid_window))
EndFunction

Script SayParagraph()
var 	int iControlId,
			string sClass	
if (GetWindowClass(GlobalFocusWindow) == WCN_TimeCalendarGrid) Then
	var handle hwnd_Parent
	let hwnd_parent = GetParent(GlobalFocusWindow)
	if (GetControlId(GlobalFocusWindow) == CID_CAT_AVL_GRID) then
		var handle hwnd
;		SayInfoWindow( CID_CAT_AVL_OUTOFOFFICE_LBL, hwnd_parent )
;		SayInfoWindow( CID_CAT_AVL_OUTOFOFFICE_CBX, hwnd_parent )
		let hwnd = FindDescendantWindow( hwnd_parent, CID_CAT_AVL_OUTOFOFFICE_CBX )
		SayWindowTypeandText(hwnd)
;		SayInfoWindow( CID_CAT_AVL_BUSY_LBL, hwnd_parent )
;		SayInfoWindow( CID_CAT_AVL_BUSY_CBX, hwnd_parent )
		let hwnd = FindDescendantWindow( hwnd_parent, CID_CAT_AVL_BUSY_CBX )
		SayWindowTypeandText(hwnd)
;		SayInfoWindow( CID_CAT_AVL_TENTATIVE_LBL, hwnd_parent )
;		SayInfoWindow( CID_CAT_AVL_TENTATIVE_CBX, hwnd_parent )
		let hwnd = FindDescendantWindow( hwnd_parent, CID_CAT_AVL_TENTATIVE_CBX )
		SayWindowTypeandText(hwnd)
	else
;		SayInfoWindow( CID_CAT_IND_STARTDATE_LBL2, hwnd_parent)
		if (	GetInfoWindowText( hwnd_parent, CID_CAT_IND_STARTDATE2) != 
			GetInfoWindowText( hwnd_parent, CID_CAT_IND_STARTDATE)) then
			SayInfoWindow( CID_CAT_IND_STARTDATE2, hwnd_parent)
		endif
;		SayInfoWindow( CID_CAT_IND_STARTTIME_LBL2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_STARTTIME2, hwnd_parent)
;		SayInfoWindow( CID_CAT_IND_Duration_Lbl2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_Duration2, hwnd_parent)

		SayInfoWindow( CID_CAT_IND_ShowAs2, hwnd_parent)

		SayInfoWindow( CID_CAT_IND_Subject_Lbl2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_Subject2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_From_Lbl2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_From2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_Place_Lbl2, hwnd_parent)
		SayInfoWindow( CID_CAT_IND_Place2, hwnd_parent)
	endif
	return
endif
; Do the default SayParagraph.
PerformScript SayParagraph()
EndScript


Void Function FocusChangedEvent ( handle FocusWindow, handle PrevWindow )
; If a ChooseApptTime grid control is getting focus for the first time, 
;   clear busy variables so labels will be spoken.
;
if (GetWindowClass(FocusWindow) == WCN_TimeCalendarGrid) then
	if (GetTopLevelWindow(FocusWindow) != g_hwndPrevChooseDlg) then
		ClearBusy()
		let g_hwndPrevChooseDlg = GetTopLevelWindow(FocusWindow)
	endif
endif
; Invoke the default FocusChangedEvent.
FocusChangedEvent( FocusWindow, PrevWindow )
EndFunction


Function SayControlExWMDebug( handle hwnd )
SayString("SayControlExWithMarkup:")
SayString("Param 1")
SayControlExWithMarkup( hwnd, "", " ", " ", " ", " ", " ", " ", " ")
SayString("Param 2")
SayControlExWithMarkup( hwnd, " ", "", " ", " ", " ", " ", " ", " ")
SayString("Param 3")
SayControlExWithMarkup( hwnd, " ", " ", "", " ", " ", " ", " ", " ")
SayString("Param 4")
SayControlExWithMarkup( hwnd, " ", " ", " ", "", " ", " ", " ", " ")
SayString("Param 5")
SayControlExWithMarkup( hwnd, " ", " ", " ", " ", "", " ", " ", " ")
SayString("Param 6")
SayControlExWithMarkup( hwnd, " ", " ", " ", " ", " ", "", " ", " ")
SayString("Param 7")
SayControlExWithMarkup( hwnd, " ", " ", " ", " ", " ", " ", "", " ")
SayString("Param 8")
SayControlExWithMarkup( hwnd, " ", " ", " ", " ", " ", " ", " ", "")
EndFunction

Function SayControlExDebug( handle hwnd )
MessageBox("")
SayString("SayControlEx:")
SayString("Param 1")
SayControlEx( hwnd, "", " ", " ", " ", " ", " ", " ", " ")
MessageBox("")
SayString("Param 2")
SayControlEx( hwnd, " ", "", " ", " ", " ", " ", " ", " ")
MessageBox("")
SayString("Param 3")
SayControlEx( hwnd, " ", " ", "", " ", " ", " ", " ", " ")
MessageBox("")
SayString("Param 4")
SayControlEx( hwnd, " ", " ", " ", "", " ", " ", " ", " ")
MessageBox("")
SayString("Param 5")
SayControlEx( hwnd, " ", " ", " ", " ", "", " ", " ", " ")
MessageBox("")
SayString("Param 6")
SayControlEx( hwnd, " ", " ", " ", " ", " ", "", " ", " ")
MessageBox("")
SayString("Param 7")
SayControlEx( hwnd, " ", " ", " ", " ", " ", " ", "", " ")
MessageBox("")
SayString("Param 8")
SayControlEx( hwnd, " ", " ", " ", " ", " ", " ", " ", "")
MessageBox("done")
EndFunction

Function SayVariousDebug()
MessageBox("")
SayString("GetWindowName:")
SayString(GetWindowName(GlobalFocusWindow))

MessageBox("")
SayString("GetObjectName:")
SayString(GetObjectName())

MessageBox("")
SayString("GetWindowType:")
SayString(GetWindowType(GlobalFocusWindow))

MessageBox("")
SayString("GetObjectType:")
SayString(GetObjectType())

MessageBox("")
SayString("GetWindowTypeCode:")
SayInteger(GetWindowTypeCode(GlobalFocusWIndow))

MessageBox("")
SayString("GetWindowTypeSubCode:")
SayInteger(GetWindowSubTypeCode(GlobalFocusWIndow))

MessageBox("")
SayString("GetObjectState:")
SayString(GetObjectState())

MessageBox("")
SayString("SayFocusedWindow--")
SayFocusedWindow()

MessageBox("")
SayString("SayFocusedObject--")
SayFocusedObject()

MessageBox("")
SayString("SayObjectTypeAndText--")
SayObjectTypeAndText( )
Delay(40,TRUE)

MessageBox("")
SayString("SayWindowTypeAndText--")
SayWindowTypeAndText( GlobalFocuswindow )

MessageBox("")
SayString("SayControl--")
SayControl( GlobalFocuswindow)

MessageBox("")
SayString("SayWindow--")
SayWindow( GlobalFocuswindow, READ_EVERYTHING )

SayString("DONE!!!")

EndFunction


;;Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes,
;;		int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
;;if( GetWindowName(GetTopLevelWindow(hwnd)) == WN_ChooseAppointmentTime) then
;;	OutputDebugString	(
;;		FormatString	("NewText >>%1<<%2\r\n", buffer, IntToString( nAttributes ))
;;				)
;;endif
;;NewTextEvent( hwnd, buffer, nAttributes, nTextColor, nBackgroundColor, nEcho, sFrameName )
;;EndFunction



;; This routine used for debugging
;; It gets called when a script is invoked.
;; Very useful to find what scripts need to be modified (or implemented)
;;  for different key strokes.
;; 
int Function GWScriptHook (string ScriptName)
	OutputDebugString(FormatString("Script>%1", ScriptName))
	return TRUE
EndFunction

;; These routines used for debugging
;; Called on entry/exit to functions and scripts
;;
void Function TrcEnter (string FunctionName)
	OutputDebugString(FormatString(">%1", FunctionName))
EndFunction

void Function TrcExit(string str)
	OutputDebugString(FormatString("<%1", str))
EndFunction

