@echo off
rem $Author: phardwick $
rem $Date: 2011-05-19 08:36:26 -0600 (Thu, 19 May 2011) $
rem $Revision: 95023 $

setlocal
pushd "%~dp0"
for /F "tokens=2,3,4 delims=/- " %%a in ("%DATE%") do set TIMESTAMP_DATE=%%c-%%a-%%%b
for /F "tokens=1,2,3 delims=.: " %%a in ("%TIME%") do set TIMESTAMP_TIME=%%a%%b%%c
set LOG_TIMESTAMP=%TIMESTAMP_DATE%_%TIMESTAMP_TIME%
set LOG_DIR_BASE=%TEMP%\groupwise_client_install_logs
set LOG_DIR=%LOG_DIR_BASE%\%LOG_TIMESTAMP%

set GW_PKG_VCRUNTIMES=vcruntimes.msi
set GW_PKG_DOTNETFX=dotnetfx.exe
set GW_PKG_WSE3=wse3.msi
set GW_PKG_MSXML=msxml.msi
set GW_PKG_O2007PIA=o2007pia.msi
set GW_PKG_GROUPWISE=groupwise.msi
Set GW_LOG_WMIC_BEFORE=07_wmic_before.log
Set GW_LOG_WMIC_AFTER=11_wmic_after.log
Set GW_LOG_WMIC_UNINSTALL=09_wmic_uninstall.log
Set GW_LOG_APPWIZ_BEFORE=08_appwiz_before.log
set GW_REG_ADDRESSBOOK_FILE=groupwise_client_addressbook.reg

if /i [%1]==[/?]      goto lbl_syntax
if /i [%1]==[/help]   goto lbl_syntax
if /i [%1]==[-help]   goto lbl_syntax
if /i [%1]==[--help]  goto lbl_syntax

if /i [%1]==[/silent] (
    set GW_INST_PART=true
    set GW_INST_METHOD=silent

    set GW_OPTS_VCRUNTIMES=/qn
    set GW_OPTS_DOTNETFX=/q:a /c:"install /q"
    set GW_OPTS_WSE3=/qn
    set GW_OPTS_MSXML=/qn
    set GW_OPTS_O2007PIA=/qn
    set GW_OPTS_GROUPWISE=/qn
)

if /i [%1]==[/unattended] (
    set GW_INST_PART=true
    set GW_INST_METHOD=unattended

    set GW_OPTS_VCRUNTIMES=/qn
    set GW_OPTS_DOTNETFX=/q:a /c:"install /q"
    set GW_OPTS_WSE3=/qn
    set GW_OPTS_MSXML=REBOOT=ReallySuppress /qn
    set GW_OPTS_O2007PIA=/qn
    set GW_OPTS_GROUPWISE=/qb!
)

if /i [%1]==[/manual] set GW_INST_PART=true

if /i [%2]==[/log] (
    set GW_INST_LOGGING=true
    set GW_OPTS_VCRUNTIMES=%GW_OPTS_VCRUNTIMES%     /l*v "%LOG_DIR%\01_%GW_PKG_VCRUNTIMES%.log"
    set GW_OPTS_WSE3=%GW_OPTS_WSE3%                 /l*v "%LOG_DIR%\03_%GW_PKG_WSE3%.log"
    set GW_OPTS_MSXML=%GW_OPTS_MSXML%               /l*v "%LOG_DIR%\04_%GW_PKG_MSXML%.log"
    set GW_OPTS_O2007PIA=%GW_OPTS_O2007PIA%         /l*v "%LOG_DIR%\05_%GW_PKG_O2007PIA%.log"
    set GW_OPTS_WMIC=/INTERACTIVE:OFF
    set GW_OPTS_WMIC_UNINSTALL=%GW_OPTS_WMIC% /APPEND:"%LOG_DIR%\%GW_LOG_WMIC_UNINSTALL%"
    set GW_OPTS_WMIC_BEFORE=%GW_OPTS_WMIC% /APPEND:"%LOG_DIR%\%GW_LOG_WMIC_BEFORE%"
    set GW_OPTS_WMIC_AFTER=%GW_OPTS_WMIC% /APPEND:"%LOG_DIR%\%GW_LOG_WMIC_AFTER%"

    set GW_OPTS_GROUPWISE=%GW_OPTS_GROUPWISE%       /l*v "%LOG_DIR%\10_%GW_PKG_GROUPWISE%.log"

    if /i [%GW_INST_METHOD%]==[manual]     set GW_OPTS_DOTNETFX=/q:a /c:"install /l %LOG_DIR%\02_%GW_PKG_DOTNETFX%.log"
    if /i [%GW_INST_METHOD%]==[silent]     set GW_OPTS_DOTNETFX=/q:a /c:"install /l %LOG_DIR%\02_%GW_PKG_DOTNETFX%.log /q"
    if /i [%GW_INST_METHOD%]==[unattended] set GW_OPTS_DOTNETFX=/q:a /c:"install /l %LOG_DIR%\02_%GW_PKG_DOTNETFX%.log /q"

    if /i not [%GW_INST_METHOD%]==[silent] echo Log file directory: %LOG_DIR%

    mkdir %LOG_DIR% 2>nul
)

if /i [%GW_INST_PART%]==[true] call :lbl_inst_prereqs
if /i [%GW_INST_PART%]==[true] goto lbl_inst_groupwise_client

rem if /i not [%GW_INST_PART%]==[true] set SETUP_CMD_OPTS=%*
rem if /i not [%GW_INST_PART%]==[true] goto lbl_main
goto lbl_main
goto lbl_end

:lbl_syntax
    echo Syntax: %0 (/manual OR /unattended OR /silent [/log])
    echo.
    echo         /silent ....... Install the pre-reqs and GroupWise silently
    echo         /unattended ... Install the pre-reqs and GroupWise visually unattended
    echo         /manual ....... Install the pre-reqs and GroupWise visually with
    echo                         interaction from user
    echo         /log .......... Enable logging (specified in addition to above switches)
    echo.
    echo Environment variables:
    echo         GW_INST_TRANSFORM_FILE ...... Set this to point to the .MST file used
    echo                                       for applying a transform to the install
    echo         GW_INST_REMOVE_MSI .......... Set this to 'true' to request WMIC to
    echo                                       uninstall all "GroupWise" MSI instances
    echo.
    echo Note: Log files are located in %LOG_DIR_BASE%
goto :eof

:lbl_main
    start /wait msiexec /i %GW_PKG_GROUPWISE% %SETUP_CMD_OPTS%
    set ERR=%ERRORLEVEL%
goto :eof

:lbl_inst_prereqs
    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Installing MS runtime libraries (%GW_PKG_VCRUNTIMES%)...
    start /wait msiexec /i %GW_PKG_VCRUNTIMES% %GW_OPTS_VCRUNTIMES%

    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Installing MS .NET Framework (%GW_PKG_DOTNETFX%)...
    start /wait %GW_PKG_DOTNETFX% %GW_OPTS_DOTNETFX%

    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Installing MS Web Services Enhancements (%GW_PKG_WSE3%)...
    start /wait msiexec /i %GW_PKG_WSE3% %GW_OPTS_WSE3%

    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Installing MS XML Core Services (%GW_PKG_MSXML%)...
    start /wait msiexec /i %GW_PKG_MSXML% %GW_OPTS_MSXML%

    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Installing MS Office System PIA modules (%GW_PKG_O2007PIA%)...
    start /wait msiexec /i %GW_PKG_O2007PIA% %GW_OPTS_O2007PIA%
goto :eof

:lbl_inst_groupwise_client
    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Gathering environment info...
    if /i [%GW_INST_LOGGING%]==[true] set > "%LOG_DIR%\00_env.log"

    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Gathering MAPI info...
    if /i [%GW_INST_LOGGING%]==[true] dir %windir%\*mapi* /s > "%LOG_DIR%\06_mapi.log"

    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Gathering existing "GroupWise" MSI instance info...
    if /i [%GW_INST_LOGGING%]==[true] echo GroupWise MSI instance info - BEFORE installing: > "%LOG_DIR%\%GW_LOG_WMIC_BEFORE%"
    if /i [%GW_INST_LOGGING%]==[true] wmic %GW_OPTS_WMIC_BEFORE% product where name="GroupWise" 1>NUL 2>NUL

    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Gathering existing AppWiz info...
    if /i [%GW_INST_LOGGING%]==[true] echo AppWiz.cpl Info (Add/Remove Programs): > "%LOG_DIR%\%GW_LOG_APPWIZ_BEFORE%"
    if /i [%GW_INST_LOGGING%]==[true] reg query "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall" /s >> "%LOG_DIR%\%GW_LOG_APPWIZ_BEFORE%"

    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Backing up Registry Settings (Address Book)...
    reg export "HKCU\Software\Novell\GroupWise\Address Book - User Interface" %TEMP%\%GW_REG_ADDRESSBOOK_FILE% /y 1>NUL 2>NUL
    if /i [%GW_INST_LOGGING%]==[true] if exist "%TEMP%\%GW_REG_ADDRESSBOOK_FILE%" type "%TEMP%\%GW_REG_ADDRESSBOOK_FILE%" >> "%LOG_DIR%\%GW_REG_ADDRESSBOOK_FILE%"

    if /i [%GW_INST_LOGGING%]==[true] if /i ["%GW_INST_REMOVE_MSI%"]==["true"] echo Please wait - Uninstalling all previous "GroupWise" MSI instances...
    if /i [%GW_INST_LOGGING%]==[true] echo GroupWise instance info - Uninstalling (GW_INST_REMOVE_MSI=%GW_INST_REMOVE_MSI%): > "%LOG_DIR%\%GW_LOG_WMIC_UNINSTALL%"
    if /i ["%GW_INST_REMOVE_MSI%"]==["true"] wmic %GW_OPTS_WMIC_UNINSTALL% product where name="GroupWise" call uninstall /nointeractive 1>NUL 2>NUL

    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Installing GroupWise Client (%GW_PKG_GROUPWISE%)...
    if /i not ["%GW_INST_TRANSFORM_FILE%"]==[""] set GW_OPTS_GROUPWISE=%GW_OPTS_GROUPWISE% TRANSFORMS=%GW_INST_TRANSFORM_FILE%

    start /wait msiexec /i %GW_PKG_GROUPWISE% %GW_OPTS_GROUPWISE%
    set ERR=%ERRORLEVEL%

    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Gathering new "GroupWise" instance info...
    if /i [%GW_INST_LOGGING%]==[true] echo GroupWise instance info - AFTER installing: > "%LOG_DIR%\%GW_LOG_WMIC_AFTER%"
    if /i [%GW_INST_LOGGING%]==[true] wmic %GW_OPTS_WMIC_AFTER% product where name="GroupWise" 1>NUL 2>NUL

    if /i [%GW_INST_LOGGING%]==[true] echo Please wait - Restoring Registry Settings (Address Book)...
    reg import "%TEMP%\%GW_REG_ADDRESSBOOK_FILE%" 1>NUL 2>NUL 

goto :eof

:lbl_end
popd
exit /B %ERR%