<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
		xmlns:msxsl="urn:schemas-microsoft-com:xslt"
	        xmlns:user="mynamespace"
        	version="1.0">
    
<xsl:variable name="langfile" select="concat('prop_',//@lang,'.xlf')"/>
<xsl:variable name="i18n" select="document($langfile)/xliff/file/body"/>
    
<xsl:template match="/">
<html>
<head>
<title></title>
<link rel="stylesheet" type="text/css" href="gwprops.css" />
</head>
<body>
  <xsl:choose>
    <xsl:when test="//@lang[.='AR' or .='HE']">
      <xsl:attribute name="dir">rtl</xsl:attribute>
    </xsl:when>
    <xsl:otherwise>
      <xsl:attribute name="dir">ltr</xsl:attribute>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:apply-templates select="envelope" />
</body>
</html>
</xsl:template>

<xsl:template match="envelope">
<table border="0" cellspacing="0" cellpadding="1" width="100%">
    <tr>
    <td bgcolor="#666666">
    <table width="100%" border="0" cellpadding="2" cellspacing="1">
        <tr>            
            <td bgcolor="#666666" valign="middle">
                <table width="100%" cellspacing="0" cellpadding="0" border="0">
                    <tr>
                        <td width="150" class="resultstableHeader"><xsl:value-of select="$i18n/trans-unit[@id='MESSAGE_ID']/source"/>:</td>
                        <td width="600" class="resultstableheadersub"><xsl:apply-templates select="@id" /></td>
		            </tr>					
                </table>
                <table width="100%" cellspacing="0" cellpadding="0" border="0">
		            <tr>
                        <td width="125" class="resultstableHeader"><xsl:value-of select="$i18n/trans-unit[@id='SUBJECT_HEADING']/source"/>:</td>
                        <td class="resultstableheadersub"><xsl:apply-templates select="subject" /></td>
                    </tr>
                    <tr>
                        <td width="100" class="resultstableHeader"><xsl:value-of select="$i18n/trans-unit[@id='CREATED_BY_HEADING']/source"/>:</td>
                        <td class="resultstableheadersub"><a><xsl:attribute name="href">mailto:<xsl:apply-templates select="createdby" /></xsl:attribute><xsl:apply-templates select="createdby" /></a></td>
                    </tr>
                    <tr>
                        <td class="resultstableHeader"><xsl:value-of select="$i18n/trans-unit[@id='SCHEDULED_DATE_HEADING']/source"/>:</td>
                        <td class="resultstableheadersub"><xsl:apply-templates select="scheduleddate" /></td>
                    </tr>
                    <tr>
                        <td class="resultstableHeader"><xsl:value-of select="$i18n/trans-unit[@id='CREATION_DATE_HEADING']/source"/>:</td>
                        <td class="resultstableheadersub"><xsl:apply-templates select="creationdate" /></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td class="resultstableHeader"><xsl:value-of select="$i18n/trans-unit[@id='FROM_HEADING']/source"/>:</td>
                        <td class="resultstableheadersub"><xsl:apply-templates select="from" /></td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr bgcolor="#FFFFFF">
            <td valign="middle">
                <table border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr>
                    <td><img src="spacer.gif" height="10" width="1"/></td>
                </tr>
                <tr>
                    <td class="subheader"><xsl:value-of select="$i18n/trans-unit[@id='RECIPIENTS_HEADING']/source"/></td>
                </tr> 
                <tr>
                    <td bgcolor="#cccccc" height="1"><img src="spacer.gif" height="1" width="1"/></td> 
                </tr>
                <tr>
                    <td><img src="spacer.gif" width="1"/></td>
                </tr>
                <tr>
                    <td bgcolor="#666666" valign="middle">
                        <table width="100%" border="0" cellpadding="2" cellspacing="0">
                        <tr>
                            <td bgcolor="#dfdfdf" class="resultstableSubHeader"><xsl:value-of select="$i18n/trans-unit[@id='RECIPIENT_HEADING']/source"/></td>
                            <td bgcolor="#dfdfdf" class="resultstableSubHeader"><xsl:value-of select="$i18n/trans-unit[@id='ACTION_HEADING']/source"/></td>
                            <td bgcolor="#dfdfdf" class="resultstableSubHeader"><xsl:value-of select="$i18n/trans-unit[@id='DATE_TIME_HEADING']/source"/></td>
                            <td bgcolor="#dfdfdf" class="resultstableSubHeader"><xsl:value-of select="$i18n/trans-unit[@id='COMMENT_HEADING']/source"/></td>
                        </tr>
                        <xsl:apply-templates select="recipients" />
                        </table>
                    </td>
                </tr>
                <tr>
                    <td height="2"><img src="spacer.gif" height="1" width="1"/></td>
                </tr>                
                <tr>
                    <td bgcolor="#cccccc" height="2"><img src="spacer.gif" height="2" width="1"/></td>
                </tr>
                <tr>
                    <td><img src="spacer.gif" height="10" width="1"/></td>
                </tr>
                <tr>
                    <td class="subheader"><xsl:value-of select="$i18n/trans-unit[@id='POST_OFFICES_HEADING']/source"/></td>
                </tr> 
                <tr>
                    <td bgcolor="#cccccc" height="1"><img src="spacer.gif" height="1" width="1"/></td> 
                </tr>
                <tr>
                    <td><img src="spacer.gif" width="1"/></td>
                </tr>
                <tr>
                    <td bgcolor="#666666" valign="middle">
                        <table width="100%" border="0" cellpadding="2" cellspacing="0">
                        <tr>
                            <td bgcolor="#dfdfdf" class="resultstableSubHeader"><xsl:value-of select="$i18n/trans-unit[@id='POST_OFFICE_HEADING']/source"/></td>
                            <td bgcolor="#dfdfdf" class="resultstableSubHeader"><xsl:value-of select="$i18n/trans-unit[@id='DELIVERED_HEADING']/source"/></td>
                            <td bgcolor="#dfdfdf" class="resultstableSubHeader"><xsl:value-of select="$i18n/trans-unit[@id='ROUTE_HEADING']/source"/></td>
                        </tr>
                        <xsl:apply-templates select="postoffices" />                        
                        </table>
                    </td>
                </tr>
                <tr>
                    <td height="2"><img src="spacer.gif" height="1" width="1"/></td>
                </tr>                
                <tr>
                    <td bgcolor="#cccccc" height="2"><img src="spacer.gif" height="2" width="1"/></td>
                </tr>
                <tr>
                    <td><img src="spacer.gif" height="10" width="1"/></td>
                </tr>
                <tr>
                    <td class="subheader"><xsl:value-of select="$i18n/trans-unit[@id='FILES_HEADING']/source"/></td>
                </tr> 
                <tr>
                    <td bgcolor="#cccccc" height="1"><img src="spacer.gif" height="1" width="1"/></td> 
                </tr>
                <tr>
                    <td><img src="spacer.gif" width="1"/></td>
                </tr>
                <tr>
                    <td bgcolor="#666666" valign="middle">
                        <table width="100%" border="0" cellpadding="2" cellspacing="0">
                        <tr>
                            <td bgcolor="#dfdfdf" class="resultstableSubHeader"><xsl:value-of select="$i18n/trans-unit[@id='FILE_HEADING']/source"/></td>
                            <td bgcolor="#dfdfdf" class="resultstableSubHeader"><xsl:value-of select="$i18n/trans-unit[@id='SIZE_HEADING']/source"/></td>
                            <td bgcolor="#dfdfdf" class="resultstableSubHeader"><xsl:value-of select="$i18n/trans-unit[@id='DATE_TIME_HEADING']/source"/></td>
                        </tr>
                        <xsl:apply-templates select="files" /> 
                        </table>
                    </td>
                </tr>
                <tr>
                    <td height="2"><img src="spacer.gif" height="1" width="1"/></td>
                </tr>                
                <tr>
                    <td bgcolor="#cccccc" height="2"><img src="spacer.gif" height="2" width="1"/></td>
                </tr>
                <tr>
                    <td align="left">
                        <table border="0" cellspacing="0" cellpadding="0" width="100%">
                            <tr>
                                <td width="25%"><img src="spacer.gif" height="5" width="1"/></td>
                            </tr>
                            <tr>
                                <td colspan="3" class="subheader"><xsl:value-of select="$i18n/trans-unit[@id='OPTIONS_HEADING']/source"/></td>
                            </tr>
                            <tr>
                                <td colspan="3" bgcolor="#cccccc" height="1"><img src="spacer.gif" height="1" width="1"/></td> 
                            </tr>
                            <tr>
                                <td colspan="3"><img src="spacer.gif" width="1"/></td>
                            </tr>
                            <xsl:apply-templates select="options" />
                            <tr>
                                <td colspan="3"><img src="spacer.gif" width="1"/></td>
                            </tr>
                            <tr>
                                <td colspan="3" bgcolor="#cccccc" height="2"><img src="spacer.gif" height="2" width="1"/></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <xsl:if test="./junkmaileval">
               <tr>
                    <td align="left">
                        <table border="0" cellspacing="0" cellpadding="0" width="100%">
                            <tr>
                                <td width="25%"><img src="spacer.gif" height="5" width="1"/></td>
                            </tr>
                            <tr>
                                <td colspan="3" class="subheader"><xsl:value-of select="$i18n/trans-unit[@id='SPAM_HEADING_1']/source"/></td>
                            </tr>
                            <tr>
                                <td colspan="3" bgcolor="#cccccc" height="1"><img src="spacer.gif" height="1" width="1"/></td> 
                            </tr>
                            <tr>
                                <td colspan="3"><img src="spacer.gif" width="1"/></td>
                            </tr>
                            <xsl:apply-templates select="junkmaileval" />
                            <tr>
                                <td colspan="3"><img src="spacer.gif" width="1"/></td>
                            </tr>
                            <tr>
                                <td colspan="3" bgcolor="#cccccc" height="2"><img src="spacer.gif" height="2" width="1"/></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                </xsl:if>
                <xsl:if test="./junkmailsettings">
                <tr>
                    <td align="left">
                        <table border="0" cellspacing="0" cellpadding="0" width="100%">
                            <tr>
                                <td width="25%"><img src="spacer.gif" height="5" width="1"/></td>
                            </tr>
                            <tr>
                                <td colspan="3" class="subheader"><xsl:value-of select="$i18n/trans-unit[@id='SPAM_HEADING_2']/source"/></td>
                            </tr>
                            <tr>
                                <td colspan="3" bgcolor="#cccccc" height="1"><img src="spacer.gif" height="1" width="1"/></td> 
                            </tr>
                            <tr>
                                <td colspan="3"><img src="spacer.gif" width="1"/></td>
                            </tr>
                            <xsl:apply-templates select="junkmailsettings" />
                            <tr>
                                <td colspan="3"><img src="spacer.gif" width="1"/></td>
                            </tr>
                            <tr>
                                <td colspan="3" bgcolor="#cccccc" height="2"><img src="spacer.gif" height="2" width="1"/></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                </xsl:if>
                <tr>
                    <td align="left">
                      <table border="0" cellspacing="0" cellpadding="0" width="100%">
                        <tr>
                          <td width="25%"><img src="spacer.gif" height="5" width="1"/></td>
                        </tr>
                        <tr>
                          <td colspan="3" class="subheader"><xsl:value-of select="$i18n/trans-unit[@id='RECORD_ID']/source"/></td>
                        </tr>
                        <tr>
                          <td colspan="3" bgcolor="#cccccc" height="1"><img src="spacer.gif" height="1" width="1"/></td>
                        </tr>
                        <tr>
                          <td colspan="3"><img src="spacer.gif" width="1"/></td>
                        </tr>
                        <tr>
                          <table border="0" cellspacing="0" cellpadding="0" width="100%">
                            <tr class="r{position() mod 2}">
                              <td width="150" class="resultstablecontent"><xsl:value-of select="$i18n/trans-unit[@id='RECORD_ID']/source"/>:</td>
                              <td width="600" class="resultstablecontent"><xsl:apply-templates select="@recid" /></td>
                            </tr>
                            <tr class="r{position() mod 2}">
                              <td width="150" class="resultstablecontent"><xsl:value-of select="$i18n/trans-unit[@id='COMMON_RECORD_ID']/source"/>:</td>
                              <td width="600" class="resultstablecontent"><xsl:apply-templates select="@comid" /></td>
                            </tr>
                          </table>
                        </tr>
                        <tr>
                          <td colspan="3"><img src="spacer.gif" width="1"/></td>
                        </tr>
                        <tr>
                          <td colspan="3" bgcolor="#cccccc" height="2"><img src="spacer.gif" height="2" width="1"/></td>
                        </tr>
                      </table>
                    </td>
                  </tr>   
                </table>
            </td>
        </tr>
        <tr bgcolor="#CCCCCC">
            <td colspan="4" align="center" bgcolor="#999999" class="content"><img src="spacer.gif" width="1" height="1"/></td>
        </tr>
    </table>
    </td>
    </tr>
</table>
</xsl:template>

<xsl:template match="subject">
   <xsl:apply-templates />
</xsl:template>

<xsl:template match="options">
    <xsl:for-each select="option">
        <xsl:sort select="@name"/>
        <tr>
            <td class="tablesubheader" bgcolor="#e5e5e5" nowrap="nowrap"><xsl:text disable-output-escaping="yes">&#38;nbsp</xsl:text><xsl:apply-templates select="@name" /></td>
            <td colspan="2" class="scontent" bgcolor="#e5e5e5"><xsl:apply-templates select="@value" /></td>
        </tr> 
    </xsl:for-each>
</xsl:template>

<xsl:template match="files">
    <xsl:for-each select="file">
        <xsl:sort select="name"/>
        <tr valign="middle" class="r{position() mod 2}">
            <td valign="top" class="resultstablecontent"><xsl:apply-templates select="name" /></td>
	    <td class="resultstablecontent">
                <xsl:choose>    
                    <xsl:when test="string-length(size/text())>0"><xsl:value-of select="size" /></xsl:when>
	            <xsl:otherwise><xsl:text disable-output-escaping="yes">&#38;nbsp</xsl:text></xsl:otherwise>
                </xsl:choose>    
            </td>
	    <td class="resultstablecontent">
                <xsl:choose>    
                    <xsl:when test="string-length(timestamp/text())>0"><xsl:value-of select="timestamp" /></xsl:when>
	            <xsl:otherwise><xsl:text disable-output-escaping="yes">&#38;nbsp</xsl:text></xsl:otherwise>
                </xsl:choose>    
            </td>
        </tr>
    </xsl:for-each>
</xsl:template>

<xsl:template match="postoffices">
    <xsl:for-each select="postoffice">
        <xsl:sort select="name"/>
        <tr valign="middle" class="r{position() mod 2}">
            <td valign="top" class="resultstablecontent"><xsl:apply-templates select="name" /></td>
            <td class="resultstablecontent">
                <xsl:choose>
                <xsl:when test="./delivered">
                    <xsl:apply-templates select="delivered" />
                </xsl:when>
                <xsl:otherwise><br/></xsl:otherwise>
                </xsl:choose>
            </td>
            <td class="resultstablecontent"><xsl:apply-templates select="route" /></td>
        </tr>
    </xsl:for-each>
</xsl:template>

<xsl:template match="recipients">
    <xsl:for-each select="postoffice">
        <xsl:sort select="@name"/>
        <tr valign="middle" class="r1">
            <td valign="top" class="resultstablecontent"><xsl:text disable-output-escaping="yes">&#38;nbsp</xsl:text><img src="gwpo.gif" hspace="2" /><xsl:text disable-output-escaping="yes">&#38;nbsp</xsl:text><xsl:apply-templates select="@name" /></td>
            <xsl:choose>
            <xsl:when test="./actions">
                <xsl:apply-templates select="actions" />
            </xsl:when>
            <xsl:otherwise>
                <td class="resultstablecontent"><br/></td>
                <td class="resultstablecontent"><br/></td>
                <td class="resultstablecontent"><br/></td>
            </xsl:otherwise>
            </xsl:choose>
        </tr>
        <xsl:for-each select="recipient">
        <xsl:sort select="name"/>
        <tr valign="middle" class="r1">
            <td valign="top" class="resultstablecontent">
                <xsl:choose>
                  <xsl:when test="@type='CC'">
                    <xsl:text disable-output-escaping="yes">&#38;nbsp&#38;nbsp&#38;nbsp&#38;nbsp</xsl:text>
                    <xsl:value-of select="$i18n/trans-unit[@id='CC_ID']/source"/>
                  </xsl:when>
                  <xsl:when test="@type='BC'">
                    <xsl:text disable-output-escaping="yes">&#38;nbsp&#38;nbsp&#38;nbsp&#38;nbsp</xsl:text>
                    <xsl:value-of select="$i18n/trans-unit[@id='BC_ID']/source"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text disable-output-escaping="yes">&#38;nbsp&#38;nbsp&#38;nbsp&#38;nbsp</xsl:text>
                    <xsl:value-of select="$i18n/trans-unit[@id='TO_ID']/source"/>
                  </xsl:otherwise>
                </xsl:choose><xsl:text disable-output-escaping="yes">&#38;nbsp</xsl:text><xsl:apply-templates select="name" /> (&#x200e;<xsl:apply-templates select="userid" />)&#x200e;</td>
                <xsl:choose>
                <xsl:when test="./actions">
                    <xsl:apply-templates select="actions" />
                </xsl:when>
                <xsl:otherwise>
                    <td class="resultstablecontent"><br/></td>
                    <td class="resultstablecontent"><br/></td>
                    <td class="resultstablecontent"><br/></td>
                </xsl:otherwise>
                </xsl:choose>
        </tr>
        </xsl:for-each>
    </xsl:for-each>
    <xsl:for-each select="recipient">
        <xsl:sort select="name"/>
        <tr valign="middle" class="r1">
            <td valign="top" class="resultstablecontent">
                <xsl:choose>    
                    <xsl:when test="@type='CC'"><xsl:text disable-output-escaping="yes">&#38;nbsp&#38;nbsp&#38;nbsp&#38;nbsp</xsl:text><xsl:value-of select="$i18n/trans-unit[@id='CC_ID']/source"/></xsl:when>
                    <xsl:when test="@type='BC'"><xsl:text disable-output-escaping="yes">&#38;nbsp&#38;nbsp&#38;nbsp&#38;nbsp</xsl:text><xsl:value-of select="$i18n/trans-unit[@id='BC_ID']/source"/></xsl:when>
                    <xsl:otherwise><xsl:text disable-output-escaping="yes">&#38;nbsp&#38;nbsp&#38;nbsp&#38;nbsp</xsl:text><xsl:value-of select="$i18n/trans-unit[@id='TO_ID']/source"/></xsl:otherwise>
                </xsl:choose><xsl:text disable-output-escaping="yes">&#38;nbsp</xsl:text><xsl:apply-templates select="name" /> (&#x200e;<xsl:apply-templates select="userid" />)&#x200e;</td>
                <xsl:choose>
                <xsl:when test="./actions">
                    <xsl:apply-templates select="actions" />
                </xsl:when>
                <xsl:otherwise>
                    <td class="resultstablecontent"><br/></td>
                    <td class="resultstablecontent"><br/></td>
                    <td class="resultstablecontent"><br/></td>
                </xsl:otherwise>
                </xsl:choose>
        </tr>
     </xsl:for-each>
</xsl:template>

<!-- matches only the last action in the list for simple display
    this may need to change to matched by priority -->
<xsl:template match="actions">
  <!-- do something special for the last action -->
    <td class="resultstablecontent">
        <xsl:for-each select="action/@status">
            <xsl:choose>    
		<xsl:when test="../@type='Accepted'">
                    <span class="resultstablegreen"><xsl:apply-templates select="." /></span>
                </xsl:when>
		<xsl:when test="../@type='Declined'">
                    <span class="resultstablered"><xsl:apply-templates select="." /></span>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="." />
                </xsl:otherwise>
            </xsl:choose>
            <!--if it is not the last of the siblings-->
            <xsl:if test="position() >= (count(../*)-1)">
                <br/>
            </xsl:if>
        </xsl:for-each>
    </td>
    <td class="resultstablecontent">
        <xsl:for-each select="action/@timestamp">
            <xsl:apply-templates select="." />
            <!--if it is not the last of the siblings-->
            <xsl:if test="position() >= (count(../*)-1)">
                <br/>
            </xsl:if>
        </xsl:for-each>
    </td>

    <td class="resultstablecontent">
        <xsl:choose>
        <xsl:when test="count(action/comment) > 0">
                <xsl:for-each select="action/comment">
                <xsl:apply-templates select="." />
                    <!--if it is not the last of the siblings-->
                    <xsl:if test="position() >= (count(../*)-1)">
                        <br/>
                    </xsl:if>
                </xsl:for-each>
        </xsl:when>
        <xsl:otherwise><br/></xsl:otherwise>
        </xsl:choose>
    </td>

</xsl:template>

<xsl:template match="name">
   <xsl:apply-templates />
</xsl:template>

<xsl:template match="userid">
   <xsl:apply-templates />
</xsl:template>

<xsl:template match="status">
   <xsl:apply-templates />
</xsl:template>

<xsl:template match="timestamp">
   <xsl:apply-templates />
</xsl:template>

<xsl:template match="comment">
   <xsl:apply-templates />
</xsl:template>

<xsl:template match="type">
    <xsl:choose>    
    <xsl:when test=".='CC'">
        <img src="user_to.png" hspace="2" />
    </xsl:when>
    <xsl:when test=".='BC'">
        <img src="user_to.png" hspace="2" />
    </xsl:when>
    <xsl:otherwise>
        <img src="user_to.png" hspace="2" />
    </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="delivered">
   <xsl:apply-templates />
</xsl:template>

<xsl:template match="route">
   <xsl:apply-templates />
</xsl:template>

<xsl:template match="action">
    <xsl:apply-templates select="comment" />
</xsl:template>

<xsl:template match="junkmaileval">
    <xsl:for-each select="spaminfo">
        <tr valign="middle" class="r{position() mod 2}">
            <td valign="top" class="resultstablecontent"><xsl:apply-templates select="." /></td>
         </tr>
    </xsl:for-each>
</xsl:template>

<xsl:template match="junkmailsettings">
    <xsl:for-each select="spaminfo">
        <tr valign="middle" class="r{position() mod 2}">
            <td valign="top" class="resultstablecontent"><xsl:apply-templates select="." /></td>
         </tr>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
