<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
		xmlns:msxsl="urn:schemas-microsoft-com:xslt"
	        xmlns:user="mynamespace"
        	version="1.0">
    
<xsl:variable name="langfile" select="concat('prop_',//@lang,'.xlf')"/>
<xsl:variable name="i18n" select="document($langfile)/xliff/file/body"/>
    
<xsl:template match="/">
  <meta http-equiv="X-UA-Compatible" content="IE=8" />
  <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
      <title></title>
<style type="text/css">
<![CDATA[

body
{
font-family: Helvetica, sans-serif;
}
img.ipadsprite
{
   background-image: url(abdlg:image:/ipadsprite.png);
   background-repeat: no-repeat;
   width: 16px;
   height: 16px;
}
img.unknown             { background-position: 0px 0px }
img.undelivered         { background-position: -16px 0px }
img.declined            { background-position: -32px 0px }
img.acknowledged        { background-position: -48px 0px }
img.completed           { background-position: -64px 0px }
img.sectiondown         { background-position: -80px 0px; cursor: hand}
img.recipientdown       { background-position: -96px 0px ; cursor: hand}
img.sectionup           { background-position: -112px 0px ; cursor: hand}
img.recipientup         { background-position: -128px 0px ; cursor: hand}
img.undelivereddown     { background-position: -144px 0px ; cursor: hand}
img.undeliveredup       { background-position: -160px 0px ; cursor: hand}

.hidden
{
    display: none;
}
.overflowEllipsis
{
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

.propertiesBdContents
{
padding: 10px;
}

.propertiesHeader
{
text-align: left;
font-size: 16px;
font-weight: bold;
-webkit-border-top-left-radius: 4px;
-webkit-border-top-right-radius: 4px;
border: 1px solid #EDEDED;
color: #505354;
padding-bottom: 4px;
padding-top: 5px;
padding-left: 10px;
padding-right: 5px;
margin-bottom: 1px;
}


.propertiesHeaderOtherThanFirst
{
margin-top: 15px;
}

.propertiesSummary
{
text-align: left;
font-size: 12px;
font-weight: normal;
color: #505354;
padding-bottom: 3px;
padding-top: 3px;
padding-left: 20px;
padding-right: 5px;
}

.propertiesSectionHeader
{
text-align: left;
font-size: 16px;
font-weight: bold;
border: 1px solid #EDEDED;
color: #505354;
background-color: #EDEDED;
padding-bottom: 4px;
padding-top: 5px;
padding-left: 10px;
padding-right: 5px;
margin-bottom: 1px;
}

.propertiesSectionHeaderImage
{
vertical-align:text-top;
}

.propertiesSectionLabel
{
padding-left: 10px;
}

.undeliverableRecipients
{
background-color: #505354;
color: white;
}

.propertiesSystemAttachmentColor
{
color: #B8B8B8;
}

.propertiesSystemAttachmentSpacing
{
padding-left: 0px;
}

.propertiesSection
{
text-align: left;
font-size: 12px;
border: 1px solid #EDEDED;
color: #505354;
padding-bottom: 3px;
padding-top: 3px;
padding-left: 5px;
padding-right: 0px;
margin-bottom: 1px;
}

.propertiesGeneralSection
{
border: 1px solid #EDEDED;
}

.propertiesLabel
{
text-align: left;
font-size: 12px;
white-space: nowrap;
}

.propertiesExtraLabel
{
text-align: left;
font-size: 12px;
white-space: nowrap;
padding-bottom: 3px;
padding-left: 5px;
padding-top: 10px;
}

.propertiesTableCell
{
text-align: left;
color: #505354;
font-size: 12px;
padding-bottom: 0px;
padding-top: 2px;
padding-left: 5px;
padding-right: 5px;
}

.recipientsTableCell
{
text-align: left;
color: #505354;
font-size: 16px;
padding-bottom: 0px;
padding-top: 2px;
padding-left: 5px;
padding-right: 5px;
}

.propertiesTableSizedCol
{
width: 40%;
}

.propertiesTableFileSizeCol
{
width: 17%;
}

.propertiesTableSendOptionsCol
{
width: 23%;
}

.recipientsTableExpandImageCell
{
width: 16px;
}

.propertiesExpandImage
{
float: right;
padding-right: 10px;
overflow: hidden;
}

.propertiesTable
{
width: 100%;
table-layout: fixed;
}
.detailsTable
{
margin-left: 10px;
padding-left: 3px;
border: 1px solid #E0E0E0;
width: 96%;
background-color: #FAFAFA;
margin-bottom: 3px;
}

.itemViewPropertiesPanel
{
padding: 10px;
text-align: center;
-webkit-border-top-left-radius: 10px;
}

}]]>
</style>
</head>
<body>
  <xsl:choose>
    <xsl:when test="//@lang[.='AR' or .='HE']">
      <xsl:attribute name="dir">rtl</xsl:attribute>
    </xsl:when>
    <xsl:otherwise>
      <xsl:attribute name="dir">ltr</xsl:attribute>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:apply-templates select="envelope" />
</body>
</html>
</xsl:template>

<xsl:template name="DoOptions">
  <div class="propertiesHeader propertiesHeaderOtherThanFirst">
    <span>
      <xsl:value-of select="$i18n/trans-unit[@id='SEND_OPTIONS_HEADING']/source"/>
    </span>
    <div class="propertiesExpandImage">
      <img src="dotzero.png" id="head-options" class="ipadsprite sectiondown" width="16" height="16" alt="" title=""></img>
    </div>
  </div>
  <div class="propertiesSection hidden" id="properties-options">
    <table class="propertiesTable" cellspacing="0" cellpadding="0">
      <thead></thead>
      <tfoot></tfoot>
      <tbody class="propertiesGeneralSection">
        <xsl:for-each select="options/option">
          <xsl:sort select="@name"/>
          <tr>
            <td class="propertiesTableCell propertiesTableSendOptionsCol overflowEllipsis">
              <span class="propertiesLabel">
                <xsl:value-of select="@name"/>
              </span>
            </td>
            <td class="propertiesTableCell">
              <span class="propertiesLabel">
                <xsl:value-of select="@value"/>
              </span>
            </td>
          </tr>
        </xsl:for-each>
      </tbody>
    </table>
  </div>
</xsl:template>

    <xsl:template name="DoFiles">
    <div class="propertiesHeader propertiesHeaderOtherThanFirst">
      <span>
        <xsl:value-of select="$i18n/trans-unit[@id='ATTACHMENTS_HEADING']/source"/>
      </span>
      <span class="propertiesSummary">
        <xsl:value-of select="$i18n/trans-unit[@id='USER_ID']/source"/>
        <xsl:value-of select="user-count"/>
        <xsl:text>,</xsl:text>
      </span>
      <span class =" propertiesSystemAttachmentColor propertiesSystemAttachmentSpacing propertiesSummary">
        <xsl:value-of select="$i18n/trans-unit[@id='SYSTEM_ID']/source"/>
        <xsl:value-of select="system-count"/>
      </span>
      <div class="propertiesExpandImage">
        <img src="dotzero.png" id="head-attachments" class="ipadsprite sectiondown" width="16" height="16" alt="" title=""></img>
      </div>
    </div>
    <div class="propertiesSection hidden" id="properties-attachments">
      <table class="propertiesTable" cellspacing="0" cellpadding="0">
        <thead></thead>
        <tfoot></tfoot>
        <tbody class="propertiesGeneralSection">
          <xsl:for-each select="files/file">
            <xsl:sort select="name"/>
            <xsl:choose>
              <xsl:when test="user-created-attachment='1'">
                <tr>
                  <td class="propertiesTableCell overflowEllipsis">
                    <span class="propertiesLabel">
                      <xsl:value-of select="name"/>
                    </span>
                  </td>
                  <td class="propertiesTableCell propertiesTableFileSizeCol overflowEllipsis">
                    <span class="propertiesLabel">
                      <xsl:value-of select="size"/>
                    </span>
                  </td>
                  <td class="propertiesTableCell propertiesTableSizedCol overflowEllipsis">
                    <span class="propertiesLabel">
                      <xsl:value-of select="timestamp"/>
                    </span>
                  </td>
                </tr>
              </xsl:when>
            </xsl:choose>
          </xsl:for-each>
          <xsl:for-each select="files/file">
            <xsl:sort select="name"/>
            <xsl:choose>
              <xsl:when test="user-created-attachment='0'">
              <tr>
                <td class="propertiesTableCell overflowEllipsis">
                  <span class="propertiesSystemAttachmentColor propertiesLabel">
                    <xsl:value-of select="name"/>
                  </span>
                </td>
                <td class="propertiesTableCell propertiesTableFileSizeCol overflowEllipsis">
                  <span class="propertiesSystemAttachmentColor propertiesLabel">
                    <xsl:value-of select="size"/>
                  </span>
                </td>
                <td class="propertiesTableCell propertiesTableSizedCol overflowEllipsis">
                  <span class="propertiesSystemAttachmentColor propertiesLabel">
                    <xsl:value-of select="timestamp"/>
                  </span>
                </td>
              </tr>
            </xsl:when>
            </xsl:choose>
          </xsl:for-each>
        </tbody>
      </table>
    </div>
  </xsl:template>
    
  <xsl:template name="DoActions">
    <xsl:for-each select="action">
      <tr>
        <td class="propertiesTableCell propertiesTableSizedCol overflowEllipsis">
          <span class="propertiesLabel">
            <xsl:value-of select="@status"/>
          </span>
        </td>
        <td class="propertiesTableCell propertiesTableSizedCol overflowEllipsis">
          <span class="propertiesLabel">
            <xsl:value-of select="@timestamp"/>
          </span>
        </td>
        <td class="propertiesTableCell propertiesTableSizedCol overflowEllipsis">
          <span class="propertiesLabel">
            <xsl:value-of select="comment"/>
          </span>
        </td>
      </tr>
    </xsl:for-each>
  </xsl:template>




  <xsl:template name="DoRecipients">
    <xsl:param name="Section"/>
    <xsl:if test="string-length($Section) > 0">
      <xsl:if test="string-length($Section/count/text()) > 0">
        <xsl:variable name="classSectionHeader">
          <xsl:choose>
            <xsl:when test="$Section=undeliverable">
              <xsl:text>undeliverableRecipients propertiesSectionHeader</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>propertiesSectionHeader</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="classExpandImage">
          <xsl:choose>
            <xsl:when test="$Section=undeliverable">
              <xsl:text>ipadsprite undeliveredup</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>ipadsprite sectionup</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <div class="{$classSectionHeader}">
          <xsl:choose>
            <xsl:when test="$Section=undeliverable">
              <img src="dotzero.png" class="ipadsprite undelivered propertiesSectionHeaderImage" width="16" height="16" alt="" title="" ></img>
            </xsl:when>
            <xsl:when test="$Section=retracted">
              <img src="dotzero.png" class="ipadsprite declined propertiesSectionHeaderImage" width="16" height="16" alt="" title=""></img>
            </xsl:when>
            <xsl:when test="$Section=completed">
              <img src="dotzero.png" class="ipadsprite completed propertiesSectionHeaderImage" width="16" height="16" alt="" title=""></img>
            </xsl:when>
            <xsl:when test="$Section=accepted">
              <img src="dotzero.png" class="ipadsprite acknowledged propertiesSectionHeaderImage" width="16" height="16" alt="" title=""></img>
            </xsl:when>
            <xsl:when test="$Section=declined">
              <img src="dotzero.png" class="ipadsprite declined propertiesSectionHeaderImage" width="16" height="16" alt="" title=""></img>
            </xsl:when>
            <xsl:when test="$Section=acknowledged">
              <img src="dotzero.png" class="ipadsprite acknowledged propertiesSectionHeaderImage" width="16" height="16" alt="" title=""></img>
            </xsl:when>
          </xsl:choose>
          <span class="propertiesSectionLabel">
            <xsl:value-of select="$Section/name"/>
            <xsl:text>: </xsl:text>
            <xsl:value-of select="$Section/count"/>
            <xsl:text> </xsl:text>
          </span>

          <div class="propertiesExpandImage">
            <img src="dotzero.png" id="head-{$Section/name}" class="{$classExpandImage}" width="16" height="16" alt="" title=""></img>
          </div>
        </div>
        <div class="propertiesSection" id="properties-{$Section/name}">
          <table class="propertiesTable" cellspacing="0" cellpadding="0">
            <thead></thead>
            <tfoot></tfoot>
            <tbody class="propertiesGeneralSection">
              <xsl:for-each select="$Section/recipients/recipient">
                <xsl:variable name="userName">
                  <xsl:value-of select="name"/>
                </xsl:variable>
                <tr>
                  <td class="recipientsTableCell propertiesTableSizedCol overflowEllipsis">
                    <xsl:value-of select="name"/>
                  </td>
                  <xsl:choose>
                    <xsl:when test="string-length(relevent-comment/@status) > 0">
                      <td class="recipientsTableCell">
                        <xsl:value-of select="relevent-comment/@status"/>
                      </td>
                    </xsl:when>
                    <xsl:when test="string-length(relevent-action/@status) > 0">
                      <td class="recipientsTableCell">
                        <xsl:value-of select="relevent-action/@status"/>
                      </td>
                    </xsl:when>
                    <xsl:when test="string-length(relevent-action/@status) = 0">
                      <td class="propertiesTableCell">
                      </td>
                    </xsl:when>
                  </xsl:choose>
                  <td class="recipientsTableCell recipientsTableExpandImageCell">
                    <div class="propertiesExpandImage">
                      <img src="dotzero.png" id="head-{$userName}" class="ipadsprite recipientdown" width="16" height="16" alt="" title=""></img>
                    </div>
                  </td>
                </tr>
                <td class="propertiesTableCell" colspan="3">
                  <div class="detailsTable hidden" id ="properties-{$userName}">
                    <table class="propertiesTable" cellspacing="0" cellpadding ="0">
                      <thead></thead>
                      <tfoot></tfoot>
                      <tbody>
                        <xsl:call-template name="DoActions">
                        </xsl:call-template>
                      </tbody>
                    </table>
                    <div class="propertiesExtraLabel">
                      <span>
                        <xsl:choose>
                          <xsl:when test="@type='CC'">
                            <xsl:value-of select="$i18n/trans-unit[@id='CC_ID']/source"/>
                          </xsl:when>
                          <xsl:when test="@type='BC'">
                            <xsl:value-of select="$i18n/trans-unit[@id='BC_ID']/source"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="$i18n/trans-unit[@id='TO_ID']/source"/>
                          </xsl:otherwise>
                        </xsl:choose>
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="userid"/>
                      </span>
                    </div>
                  </div>
                </td>
              </xsl:for-each>
            </tbody>
        </table>
        </div>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="envelope">
    <div id ="idItemViewPropertiesPanel" class ="ItemViewPropertiesPanel">
      <div class ="propertiesBdContents">
        <xsl:for-each select="recipients-by-status">
          <div class="propertiesHeader">
            <span>
              <xsl:value-of select="$i18n/trans-unit[@id='RECIPIENTS_HEADING']/source"/>
              <xsl:text>: </xsl:text>
              <xsl:value-of select="recipient-count"/>
            </span>
            <span class="propertiesSummary">
              <xsl:variable name="acc" select="string-length(accepted/count/text())" />
              <xsl:variable name="dec" select="string-length(declined/count/text())" />
              <xsl:variable name="ret" select="string-length(retracted/count/text())" />
              <xsl:variable name="com" select="string-length(completed/count/text())" />
              <xsl:variable name="ack" select="string-length(acknowledged/count/text())" />
              <xsl:variable name="res" select="string-length(responsepending/count/text())" />
              <xsl:variable name="und" select="string-length(undeliverable/count/text())" />
              <xsl:if test="string-length(accepted/count/text()) > 0">
                <xsl:value-of select="accepted/name"/>
                <xsl:text>: </xsl:text>
                <xsl:value-of select="accepted/count"/>
              </xsl:if>
              <xsl:if test="string-length(declined/count/text()) > 0">
                <xsl:if test="$acc > 0">
                <xsl:text>, </xsl:text>
                </xsl:if>
                <xsl:value-of select="declined/name"/>
                <xsl:text>: </xsl:text>
                <xsl:value-of select="declined/count"/>
              </xsl:if>
              <xsl:if test="string-length(completed/count/text()) > 0">
                <xsl:if test="$acc > 0 or $dec > 0">
                  <xsl:text>, </xsl:text>
                </xsl:if>
                <xsl:value-of select="completed/name"/>
                <xsl:text>: </xsl:text>
                <xsl:value-of select="completed/count"/>
              </xsl:if>
              <xsl:if test="string-length(acknowledged/count/text()) > 0">
                <xsl:if test="$acc > 0 or $dec > 0 or $com > 0">
                  <xsl:text>, </xsl:text>
                </xsl:if>
                <xsl:value-of select="acknowledged/name"/>
                <xsl:text>: </xsl:text>
                <xsl:value-of select="acknowledged/count"/>
              </xsl:if>
              <xsl:if test="string-length(responsepending/count/text()) > 0">
                <xsl:if test="$acc > 0 or $dec > 0 or $com > 0 or $ack > 0">
                  <xsl:text>, </xsl:text>
                </xsl:if>
                <xsl:value-of select="responsepending/name"/>
                <xsl:text>: </xsl:text>
                <xsl:value-of select="responsepending/count"/>
              </xsl:if>
              <xsl:if test="string-length(retracted/count/text()) > 0">
                <xsl:if test="$acc > 0 or $dec > 0 or $com > 0 or $ack > 0 or $res > 0">
                  <xsl:text>, </xsl:text>
                </xsl:if>
                <xsl:value-of select="retracted/name"/>
                <xsl:text>: </xsl:text>
                <xsl:value-of select="retracted/count"/>
              </xsl:if>
              <xsl:if test="string-length(undeliverable/count/text()) > 0">
                <xsl:if test="$acc > 0 or $dec > 0 or $com > 0 or $ack > 0 or $res > 0 or $ret > 0">
                  <xsl:text>, </xsl:text>
                </xsl:if>
                <xsl:value-of select="undeliverable/name"/>
                <xsl:text>: </xsl:text>
                <xsl:value-of select="undeliverable/count"/>
              </xsl:if>
            </span>
            <div class="propertiesExpandImage">
              <img src="dotzero.png" id ="head-main" class="ipadsprite sectionup" width="16" height="16" alt="" title=""></img>
            </div>
          </div>
          <div id="properties-main">
            <xsl:call-template name="DoRecipients">
              <xsl:with-param name="Section" select="undeliverable"/>
            </xsl:call-template>
            <xsl:call-template name="DoRecipients">
              <xsl:with-param name="Section" select="retracted"/>
            </xsl:call-template>
            <xsl:call-template name="DoRecipients">
              <xsl:with-param name="Section" select="accepted"/>
            </xsl:call-template>
            <xsl:call-template name="DoRecipients">
              <xsl:with-param name="Section" select="declined"/>
            </xsl:call-template>
            <xsl:call-template name="DoRecipients">
              <xsl:with-param name="Section" select="completed"/>
            </xsl:call-template>
            <xsl:call-template name="DoRecipients">
              <xsl:with-param name="Section" select="acknowledged"/>
            </xsl:call-template>
            <xsl:call-template name="DoRecipients">
              <xsl:with-param name="Section" select="responsepending"/>
            </xsl:call-template>
          </div>
        </xsl:for-each>
        <xsl:call-template name="DoFiles">
        </xsl:call-template>
        <xsl:call-template name="DoOptions">
        </xsl:call-template>
      </div>
    </div>
</xsl:template>
</xsl:stylesheet>
