﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
		xmlns:msxsl="urn:schemas-microsoft-com:xslt"
	        xmlns:user="mynamespace"
        	version="1.0">

<xsl:variable name="langfile" select="concat('biz_',//@lang,'.xlf')"/>
<xsl:variable name="i18n" select="document($langfile)/xliff/file/body"/>

<xsl:template match="/">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template name="lf2br">
	<xsl:param name="StringToTransform"/>
	<xsl:choose>
		<xsl:when test="contains($StringToTransform,'&#xA;')">
			<xsl:value-of select="substring-before($StringToTransform,'&#xA;')"/>
			<br/>
			<xsl:call-template name="lf2br">
				<xsl:with-param name="StringToTransform">
					<xsl:value-of select="substring-after($StringToTransform,'&#xA;')"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$StringToTransform"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="contact">
<html>
<body bgcolor="#ffffff">
<xsl:choose>
  <xsl:when test="//@lang[.='AR' or .='HE']">
    <xsl:attribute name="dir">rtl</xsl:attribute>
  </xsl:when>
  <xsl:otherwise>
    <xsl:attribute name="dir">ltr</xsl:attribute>
  </xsl:otherwise>
</xsl:choose>
<center>
<table border="0" bgcolor="#000000" cellspacing="0" cellpadding="2"><tr><td>
<table border="0" bgcolor="#ffffff" width="350" cellpadding="5">
<tr>
	<td colspan="2">
		<xsl:if test="string-length(Company/text())>0">
		  <font size="+1"><strong><xsl:value-of select="Company"/></strong></font><br/>
		</xsl:if>
		<font size="-1">
	    <xsl:if test="string-length(BusinessStreet/text())>0">
          <xsl:value-of select="BusinessStreet"/><br/>
		</xsl:if>
	      <xsl:if test="string-length(BusinessMailStop/text())>0">
        <xsl:value-of select="BusinessMailStop"/><br/>
		</xsl:if>
	    <xsl:if test="string-length(BusinessCity/text())>0">
		  <xsl:value-of select="BusinessCity"/>,
		</xsl:if>
	    <xsl:if test="string-length(BusinessState/text())>0">
		  <xsl:text> </xsl:text><xsl:value-of select="BusinessState"/>
		</xsl:if>
	    <xsl:if test="string-length(BusinessZip/text())>0">
		  <xsl:text> </xsl:text><xsl:value-of select="BusinessZip"/>
		</xsl:if>
	    <xsl:if test="string-length(BusinessCountry/text())>0">
		  <xsl:text> </xsl:text><xsl:value-of select="BusinessCountry"/>
		</xsl:if>
		</font><br/>
		<img src="abdlg:image:/line.gif" border="0"/>
	</td>
</tr>
<tr>
	<td align="middle" colspan="2">
		<div>
			<strong><xsl:value-of select="DisplayName"/></strong><br/>
			<xsl:if test="string-length(Title/text())>0">
			  <xsl:value-of select="Title"/><br/>
			</xsl:if>
			<xsl:if test="string-length(Department/text())>0">
			  <xsl:value-of select="Department"/>
			</xsl:if>
		</div>
	</td>
</tr>
<tr>
	<td colspan="2">
		<font size="-1">
			<xsl:if test="string-length(BusinessPhone/text())>0">
			  <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_PHONE']/source"/> <xsl:value-of select="BusinessPhone"/><br/>
			</xsl:if>
			<xsl:if test="string-length(Fax/text())>0">
			  <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_FAX']/source"/> <xsl:value-of select="Fax"/><br/>
			</xsl:if>
			<xsl:if test="string-length(DefaultEmail/text())>0">
			  <a>
			  <xsl:attribute name="href">
			  mailto:<xsl:value-of select="DefaultEmail"/>
			  </xsl:attribute>
			  <xsl:value-of select="DefaultEmail"/>
			  </a><br/>
			</xsl:if>
			<xsl:if test="string-length(BusinessWebsite/text())>0">
			  <a>
			  <xsl:attribute name="href">
			  <xsl:value-of select="BusinessWebsite"/>
			  </xsl:attribute>
			  <xsl:value-of select="BusinessWebsite"/>
			  </a><br/>
			</xsl:if>
		</font>
	</td>
</tr>
</table>
</td></tr></table>

<xsl:if test="string-length(Comments/text())>0">
<br/>
<table border="0" width="350">
<tr>
<td bgcolor="#d0d0d0"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_COMMENTS']/source"/></td>
</tr>
<tr>
<td>
<xsl:call-template name="lf2br">
  <xsl:with-param name="StringToTransform" select="Comments"/>
</xsl:call-template>
</td>
</tr>
</table>
</xsl:if>

</center>
</body>
</html>
</xsl:template>

</xsl:stylesheet>