﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
		xmlns:msxsl="urn:schemas-microsoft-com:xslt"
	        xmlns:user="mynamespace"
        	version="1.0">

<xsl:variable name="langfile" select="concat('def_',//@lang,'.xlf')"/>
<xsl:variable name="i18n" select="document($langfile)/xliff/file/body"/>

<xsl:template match="/">
<html>
<style type="text/css">
body, p, table, th, tr, td, ol,  ul, li, textarea, option, input, select {font-family: sans-serif;}
p, td, ol,  ul, textarea, option, input, select {font-size: 0.8em;}
th {color: white; font-weight: bold;  text-align:left; text-indent: 0.5em; background-color: #6b8899;}
body a {color: #039;}
small {font-size: 0.75em;}
.title {background: #cfcdc6; color: black; font-weight: bold; font-size: 1em; letter-spacing: 0.1em; text-indent: 0.4em; width: 100%}
.left {background: #dfddd5}
.section {color: black; font-weight: bold; font-size: .9em; margin-top: 0.4em; margin-bottom: 0.4em; border-bottom: 1px solid #cfcdc6}
</style>
<body bgcolor="#ffffff" borderwidth="0" leftmargin="0" rightmargin="0" topmargin="0" marginwidth="0" marginheight="0">
<xsl:choose>
  <xsl:when test="//@lang[.='AR' or .='HE']">
    <xsl:attribute name="dir">rtl</xsl:attribute>
  </xsl:when>
  <xsl:otherwise>
    <xsl:attribute name="dir">ltr</xsl:attribute>
  </xsl:otherwise>
</xsl:choose>
<div class="title"><xsl:value-of select="//DisplayName"/></div>
<xsl:apply-templates/>
</body>
</html>
</xsl:template>


<xsl:template name="lf2br">
	<xsl:param name="StringToTransform"/>
	<xsl:choose>
		<xsl:when test="contains($StringToTransform,'&#13;&#10;')">
			<xsl:value-of select="substring-before($StringToTransform,'&#13;&#10;')"/>
			<br/>
			<xsl:call-template name="lf2br">
				<xsl:with-param name="StringToTransform">
					<xsl:value-of select="substring-after($StringToTransform,'&#13;&#10;')"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$StringToTransform"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="contact">
<table border="0" width="100%" cellspacing="0" cellpadding="4">
<tr>
  <td valign="top">
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_OFFICE_INFORMATION']/source"/></td>
	</tr>
	<tr>
	  <td>
		<xsl:if test="string-length(Title/text()) > 0">
		  <xsl:value-of select="Title"/><br/>
		</xsl:if>
		<xsl:if test="string-length(Company/text()) > 0">
		  <a>
		  <xsl:attribute name="href">
		  abdlg:launch:/<xsl:value-of select="@book"/>/<xsl:value-of select="CompanyID"/>
		  </xsl:attribute>
		  <xsl:value-of select="Company"/>
		  </a><br/>
		</xsl:if>
		<xsl:if test="string-length(Department/text()) > 0">
		  <xsl:value-of select="Department"/><br/>
		</xsl:if>
	  </td>
	</tr>
	</table>
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_OFFICE_ADDRESS']/source"/></td>
	</tr>
	<tr>
	  <td>
	    <xsl:if test="string-length(BusinessStreet/text())>0">
          <xsl:value-of select="BusinessStreet"/><br/>
		</xsl:if>
	      <xsl:if test="string-length(BusinessMailStop/text())>0">
        <xsl:value-of select="BusinessMailStop"/><br/>
		</xsl:if>
	    <xsl:if test="string-length(BusinessCity/text())>0">
		  <xsl:value-of select="BusinessCity"/>,
		</xsl:if>
	    <xsl:if test="string-length(BusinessState/text())>0">
		  <xsl:text> </xsl:text><xsl:value-of select="BusinessState"/>
		</xsl:if>
	    <xsl:if test="string-length(BusinessZip/text())>0">
		  <xsl:text> </xsl:text><xsl:value-of select="BusinessZip"/>
		</xsl:if>
	    <xsl:if test="string-length(BusinessCountry/text())>0">
		  <xsl:text> </xsl:text><xsl:value-of select="BusinessCountry"/>
		</xsl:if>
		<br/>
	    <xsl:if test="string-length(BusinessWebsite/text())>0">
		  <a>
		  <xsl:attribute name="href">
		  <xsl:value-of select="BusinessWebsite"/>
		  </xsl:attribute>
		  <xsl:value-of select="BusinessWebsite"/>
		  </a>
		</xsl:if>
	  </td>
	</tr>
	</table>
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_HOME_ADDRESS']/source"/></td>
	</tr>
	<tr>
	  <td>
		  <xsl:if test="string-length(HomeStreet/text())>0">
		    <xsl:value-of select="HomeStreet"/><br/>
		  </xsl:if>
		  <xsl:if test="string-length(HomeCity/text())>0">
		    <xsl:value-of select="HomeCity"/>,
		  </xsl:if>
		  <xsl:if test="string-length(HomeState/text())>0">
		    <xsl:text> </xsl:text><xsl:value-of select="HomeState"/>
		  </xsl:if>
		  <xsl:if test="string-length(HomeZip/text())>0">
		    <xsl:text> </xsl:text><xsl:value-of select="HomeZip"/>
		  </xsl:if>
		  <xsl:if test="string-length(HomeCountry/text())>0">
		    <xsl:text> </xsl:text><xsl:value-of select="HomeCountry"/>
		  </xsl:if>
		  <br/>
		  <xsl:if test="string-length(HomeWebsite/text())>0">
		    <a>
			<xsl:attribute name="href">
			<xsl:value-of select="HomeWebsite"/>
			</xsl:attribute>
			<xsl:value-of select="HomeWebsite"/>
			</a>
		  </xsl:if>
	  </td>
	</tr>
	</table>
  </td>
  <td valign="top">
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_EMAIL_ADDRESSES']/source"/></td>
	</tr>
	<tr>
	  <td>
		<xsl:for-each select="EmailAddresses/EmailAddress">
		  <a>
			<xsl:attribute name="href">mailto:<xsl:value-of select="text()"/></xsl:attribute>
			<xsl:value-of select="text()"/>
		  </a><br/>
		</xsl:for-each>
	  </td>
	</tr>
	</table>
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_IM_ADDRESSES']/source"/></td>
	</tr>
	<tr>
	  <td>
		<xsl:for-each select="ImAddresses/ImAddress">
		  <xsl:value-of select="text()"/><br/>
		</xsl:for-each>
	  </td>
	</tr>
	</table>
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_PHONE_NUMBERS']/source"/></td>
	</tr>
	<tr>
	  <td>
		<xsl:if test="string-length(BusinessPhone/text()) > 0">
		  <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_PHONE_OFFICE']/source"/>
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="BusinessPhone"/><br/>
		</xsl:if>
		<xsl:if test="string-length(HomePhone/text()) > 0">
		  <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_PHONE_HOME']/source"/>
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="HomePhone"/><br/>
		</xsl:if>
		<xsl:if test="string-length(MobilePhone/text()) > 0">
		  <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_PHONE_MOBILE']/source"/>
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="MobilePhone"/><br/>
		</xsl:if>
		<xsl:if test="string-length(Fax/text()) > 0">
		  <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_PHONE_FAX']/source"/>
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="Fax"/><br/>
		</xsl:if>
		<xsl:if test="string-length(Pager/text()) > 0">
		  <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_PHONE_PAGER']/source"/>
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="Pager"/><br/>
		</xsl:if>
	  </td>
	</tr>
	</table>
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_OTHER_INFO']/source"/></td>
	</tr>
	<tr>
	  <td>
		<xsl:if test="string-length(Birthday/text()) > 0">
		  <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_BIRTHDAY']/source"/>
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="Birthday"/><br/>
		</xsl:if>
		<xsl:for-each select="UserDefinedFields/UserDefined">
		  <xsl:value-of select="Name"/>: <xsl:value-of select="Value"/><br/>
		</xsl:for-each>
	  </td>
	</tr>
	</table>
  </td>
</tr>
<xsl:if test="string-length(Comments/text())>0">
<tr>
  <td colspan="2">
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_COMMENTS']/source"/></td>
	</tr>
	<tr>
	  <td>
	  <xsl:call-template name="lf2br">
	    <xsl:with-param name="StringToTransform" select="Comments"/>
	  </xsl:call-template>
	  </td>
	</tr>
	</table>
  </td>
</tr>
</xsl:if>
</table>
</xsl:template>



<xsl:template match="group">
<table border="0" width="100%" cellspacing="0" cellpadding="4">
<tr>
  <td valign="top">
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='GROUP_MEMBERS']/source"/></td>
	</tr>
	<xsl:for-each select="GroupMembers/Member">
		<xsl:sort select="Membership" order="descending"/>
		<xsl:sort select="DisplayName"/>
		<tr>
		  <td>
			<xsl:value-of select="Membership"/>: 
			<xsl:choose>
				<xsl:when test="string-length(EmailAddress/text())>0">
					<a>
					<xsl:attribute name="href">
					mailto:<xsl:value-of select="EmailAddress"/>
					</xsl:attribute>
					<xsl:value-of select="DisplayName"/>
					</a>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="DisplayName"/>
				</xsl:otherwise>
			</xsl:choose>
		  </td>
		</tr>
	</xsl:for-each>
	</table>
  </td>
</tr>
<xsl:if test="string-length(Comments/text())>0">
<tr>
  <td colspan="2">
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_COMMENTS']/source"/></td>
	</tr>
	<tr>
	  <td>
	  <xsl:call-template name="lf2br">
	    <xsl:with-param name="StringToTransform" select="Comments"/>
	  </xsl:call-template>
	  </td>
	</tr>
	</table>
  </td>
</tr>
</xsl:if>
</table>
</xsl:template>



<xsl:template match="resource">
<table border="0" width="100%" cellspacing="0" cellpadding="4">
<tr>
  <td valign="top">
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='RESOURCE_PROPERTIES']/source"/></td>
	</tr>
	<tr>
	  <td>
		<xsl:if test="string-length(ResourceType/text())>0">
		  <xsl:value-of select="$i18n/trans-unit[@id='RESOURCE_TYPE']/source"/>
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="ResourceType"/><br/>
		</xsl:if>
		<xsl:if test="string-length(EmailAddress/text())>0">
		  <xsl:value-of select="$i18n/trans-unit[@id='RESOURCE_EMAIL']/source"/>
		  <xsl:text> </xsl:text>
		  <a>
		  <xsl:attribute name="href">
		  mailto:
		  <xsl:value-of select="EmailAddress"/>
		  </xsl:attribute>
		  <xsl:value-of select="EmailAddress"/><br/>
		  </a>
		</xsl:if>
		<xsl:if test="string-length(PhoneNumber/text())>0">
		  <xsl:value-of select="$i18n/trans-unit[@id='RESOURCE_PHONE']/source"/>
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="PhoneNumber"/><br/>
		</xsl:if>
		<xsl:if test="string-length(Owner/text())>0">
		  <xsl:value-of select="$i18n/trans-unit[@id='RESOURCE_OWNER']/source"/>
		  <xsl:text> </xsl:text>
		  <a>
		  <xsl:attribute name="href">
		  abdlg:launch:/<xsl:value-of select="@book"/>/<xsl:value-of select="OwnerID"/>
		  </xsl:attribute>
		  <xsl:value-of select="Owner"/>
		  </a><br/>
		</xsl:if>
	    <xsl:for-each select="UserDefinedFields/UserDefined">
		  <xsl:value-of select="Name"/>: <xsl:value-of select="Value"/><br/>
		</xsl:for-each>
	  </td>
	</tr>
	</table>
  </td>
</tr>
<xsl:if test="string-length(Comments/text())>0">
<tr>
  <td colspan="2">
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_COMMENTS']/source"/></td>
	</tr>
	<tr>
	  <td>
	  <xsl:call-template name="lf2br">
	    <xsl:with-param name="StringToTransform" select="Comments"/>
	  </xsl:call-template>
	  </td>
	</tr>
	</table>
  </td>
</tr>
</xsl:if>
</table>
</xsl:template>



<xsl:template match="organization">
<table border="0" width="100%" cellspacing="0" cellpadding="4">
<tr>
  <td valign="top">
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='ORGANIZATION_ADDRESS']/source"/></td>
	</tr>
	<tr>
	  <td>
		<xsl:if test="string-length(AddressStreet/text())>0">
		  <xsl:value-of select="AddressStreet"/><br/>
		</xsl:if>
		<xsl:if test="string-length(AddressCity/text())>0">
		  <xsl:value-of select="AddressCity"/>,
		</xsl:if>
		<xsl:if test="string-length(AddressState/text())>0">
		  <xsl:text> </xsl:text><xsl:value-of select="AddressState"/>
		</xsl:if>
		<xsl:if test="string-length(AddressZip/text())>0">
		  <xsl:text> </xsl:text><xsl:value-of select="AddressZip"/><br/>
		</xsl:if>
		<xsl:if test="string-length(AddressCountry/text())>0">
		  <xsl:text> </xsl:text><xsl:value-of select="AddressCountry"/><br/>
		</xsl:if>
		<xsl:if test="string-length(Website/text())>0">
		  <a>
		  <xsl:attribute name="href">
		  <xsl:value-of select="Website"/><br/>
		  </xsl:attribute>
		  <xsl:value-of select="Website"/><br/>
		  </a>
		</xsl:if>
      </td>
	</tr>
	</table>
  </td>
  <td valign="top">
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='ORGANIZATION_CONTACTINFO']/source"/></td>
	</tr>
	<tr>
	  <td>
		<xsl:if test="string-length(PrimaryContact/text())>0">
			<xsl:value-of select="$i18n/trans-unit[@id='ORGANIZATION_CONTACT']/source"/>
			<xsl:text> </xsl:text>
			<a>
			<xsl:attribute name="href">
			abdlg:launch:/<xsl:value-of select="@book"/>/<xsl:value-of select="PrimaryContactID"/>
			</xsl:attribute>
			<xsl:value-of select="PrimaryContact"/>
			</a><br/>
		</xsl:if>
		<xsl:if test="string-length(PhoneNumber/text())>0">
		  <xsl:value-of select="$i18n/trans-unit[@id='ORGANIZATION_PHONE']/source"/>
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="PhoneNumber"/><br/>
		</xsl:if>
		<xsl:if test="string-length(FaxNumber/text())>0">
		  <xsl:value-of select="$i18n/trans-unit[@id='ORGANIZATION_FAX']/source"/>
		  <xsl:text> </xsl:text>
		  <xsl:value-of select="FaxNumber"/><br/>
		</xsl:if>
      </td>
	</tr>
	</table>
  </td>
</tr>
<xsl:if test="string-length(Comments/text())>0">
<tr>
  <td colspan="2">
	<table border="0" width="100%">
	<tr>
	  <td class="section"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_COMMENTS']/source"/></td>
	</tr>
	<tr>
	  <td>
	  <xsl:call-template name="lf2br">
	    <xsl:with-param name="StringToTransform" select="Comments"/>
	  </xsl:call-template>
	  </td>
	</tr>
	</table>
  </td>
</tr>
</xsl:if>
<tr>
  <td colspan="2">
	<table border="0" width="100%">
	<tr>
	  <td class="section" colspan="2"><xsl:value-of select="$i18n/trans-unit[@id='ORGANIZATION_MEMBERS']/source"/></td>
	</tr>
	<xsl:for-each select="People/Member">
	<xsl:sort select="Department" order="descending"/>
	<xsl:sort select="DisplayName"/>
		<tr>
			<td>
				<a>
				<xsl:attribute name="href">mailto:
				<xsl:value-of select="EmailAddress"/>
				</xsl:attribute>
				<xsl:value-of select="DisplayName"/>
				</a>
			</td>
			<td><xsl:value-of select="PhoneNumber"/></td>
		</tr>
	</xsl:for-each>
	</table>
  </td>
</tr>
</table>
</xsl:template>

</xsl:stylesheet>