﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
		xmlns:msxsl="urn:schemas-microsoft-com:xslt"
	        xmlns:user="mynamespace"
        	version="1.0">

<xsl:variable name="langfile" select="concat('def_',//@lang,'.xlf')"/>
<xsl:variable name="i18n" select="document($langfile)/xliff/file/body"/>

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<title>
  <xsl:value-of select="//DisplayName"/>
</title>
<style type="text/css">
  body, p, table, th, tr, td, ol,  ul, li, textarea, option, input, select {font-family: sans-serif;}
  body, p, td {font-size: 0.8em;}
  .column {vertical-align: top; width: 50%;}
  .columns {width: 100%; border: 0px;}
  .contactphoto {border: 1px solid #c0c0c0;}
  .data {text-align: left;}
  #display_name {font-weight: bold; font-size: 16pt; white-space: nowrap;}
  .header {background: url("abdlg:image:/gradient.png"); margin: 4px;}
  .label {color: #c0c0c0; font-weight: bold; text-align: right;}
  .left-edge {background: url("abdlg:image:/edge_l.png") top left no-repeat; width: 100%;}
  .right-edge {background: url("abdlg:image:/edge_r.png") top right no-repeat; width: 100%; padding: 4px}
  .thumbnail {float: left; padding: 6px;}
  .phone {text-align: left; white-space: nowrap;}
  .prop-table {border: 0px; width: 100%;}
  .title {color: #a0a0a0; font-weight: bold; text-align: left; text-decoration: underline;}
</style>
  <script type="text/javascript">
    function HideSpacer(obj)
    {
      if(obj)
      {
        var next = obj.nextSibling;
        if(next == null || next.className == "spacer")
          obj.style.display = "none";
      }
    }

    function OnLoad()
    {
      HideSpacer(document.getElementById('address-spacer'));
      HideSpacer(document.getElementById('office-spacer'));
      HideSpacer(document.getElementById('other-spacer'));
      HideSpacer(document.getElementById('personal-spacer'));
      HideSpacer(document.getElementById('udf-spacer'));
    }
  </script>
</head>
<body onload="OnLoad();">
<xsl:choose>
  <xsl:when test="//@lang[.='AR' or .='HE']">
    <xsl:attribute name="dir">rtl</xsl:attribute>
  </xsl:when>
  <xsl:otherwise>
    <xsl:attribute name="dir">ltr</xsl:attribute>
  </xsl:otherwise>
</xsl:choose>
<xsl:apply-templates/>
</body>
</html>
</xsl:template>


<xsl:template name="lf2br">
	<xsl:param name="StringToTransform"/>
	<xsl:choose>
		<xsl:when test="contains($StringToTransform,'&#13;&#10;')">
			<xsl:value-of select="substring-before($StringToTransform,'&#13;&#10;')"/>
			<br/>
			<xsl:call-template name="lf2br">
				<xsl:with-param name="StringToTransform">
					<xsl:value-of select="substring-after($StringToTransform,'&#13;&#10;')"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$StringToTransform"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="PropertyToRow">
  <xsl:param name="Label"/>
  <xsl:param name="Data"/>
  <xsl:if test="string-length($Data) > 0">
    <tr xmlns="http://www.w3.org/1999/xhtml">
      <td class="label">
        <xsl:value-of select="$Label"/>
      </td>
      <td>
        <xsl:value-of select="$Data"/>
      </td>
    </tr>
  </xsl:if>
</xsl:template>

<xsl:template name="AddressToRow">
  <xsl:param name="Label"/>
  <xsl:param name="Address"/>
  <xsl:if test="string-length($Address/Formatted/text()) > 0">
    <tr>
      <td class="label" valign="top">
        <xsl:value-of select="$Label"/>
      </td>
      <td>
        <xsl:call-template name="lf2br">
          <xsl:with-param name="StringToTransform" select="$Address/Formatted"/>
        </xsl:call-template>
        <br/>
        <a>
          <xsl:attribute name="href">
            <xsl:value-of select="$Address/MapUrl"/>
          </xsl:attribute>
          <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_VIEW_MAP']/source"/>
        </a>
      </td>
    </tr>
  </xsl:if>
</xsl:template>

<xsl:template name="UrlToRow">
  <xsl:param name="Label"/>
  <xsl:param name="Url"/>
  <xsl:if test="string-length($Url/text()) > 0">
    <tr xmlns="http://www.w3.org/1999/xhtml">
      <td class="label" valign="top">
        <xsl:value-of select="$Label"/>
      </td>
      <td>
        <a>
          <xsl:attribute name="href">
            <xsl:value-of select="$Url"/>
          </xsl:attribute>
          <xsl:value-of select="$Url"/>
        </a>
      </td>
    </tr>
  </xsl:if>
</xsl:template>
  
<xsl:template match="contact">
  <div class="header">
    <div class="left-edge">
      <div class="right-edge">
        <xsl:if test="string-length(Photo/text())>0">
          <div class="thumbnail">
            <img class="contactphoto" alt="photo.jpg">
              <xsl:attribute name="src"><xsl:value-of select="Photo"/></xsl:attribute>
            </img>
          </div>
        </xsl:if>
        <div id="display_name">
          <xsl:value-of select="DisplayName"/>
        </div>
        <xsl:if test="string-length(Title/text()) > 0">
          <div>
            <xsl:value-of select="Title"/>
          </div>
        </xsl:if>
        <xsl:if test="string-length(Company/text()) > 0">
          <div>
            <a>
              <xsl:attribute name="href">
                abdlg:launch:/<xsl:value-of select="@book"/>/<xsl:value-of select="CompanyID"/>
              </xsl:attribute>
              <xsl:value-of select="Company"/>
            </a>
          </div>
        </xsl:if>
        <xsl:if test="string-length(DefaultPhone/text()) > 0">
          <div>
            <xsl:value-of select="DefaultPhone"/>
          </div>
        </xsl:if>
      </div>
    </div>
  </div>

  <table xmlns="http://www.w3.org/1999/xhtml" class="columns">
    <tr>
      <!-- First Column -->
      <td class="column">
        <xsl:for-each select="EmailAddresses/EmailAddress">
          <div>
            <a><xsl:attribute name="href">mailto:<xsl:value-of select="text()"/></xsl:attribute><xsl:value-of select="text()"/></a>
          </div>
        </xsl:for-each>
        <table border="0" class="prop-table">
          <!-- Postal Addresses -->
          <tr class="spacer" id="address-spacer"><td colspan="2"><hr/></td></tr>
          <xsl:call-template name="AddressToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_OFFICE']/source"/>
            <xsl:with-param name="Address" select="PostalAddresses/PostalAddress[@type='office']"/>
          </xsl:call-template>
          <xsl:call-template name="AddressToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_HOME']/source"/>
            <xsl:with-param name="Address" select="PostalAddresses/PostalAddress[@type='home']"/>
          </xsl:call-template>
          <xsl:call-template name="AddressToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_OTHER']/source"/>
            <xsl:with-param name="Address" select="PostalAddresses/PostalAddress[@type='other']"/>
          </xsl:call-template>
          <!-- Office Properties -->
          <tr class="spacer" id="office-spacer"><td colspan="2"><hr/></td></tr>
          <xsl:call-template name="UrlToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_WEBSITE']/source"/>
            <xsl:with-param name="Url" select="OfficeWebsite"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_DEPARTMENT']/source"/>
            <xsl:with-param name="Data" select="Department"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_PROFESSION']/source"/>
            <xsl:with-param name="Data" select="Profession"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_MANAGER']/source"/>
            <xsl:with-param name="Data" select="Manager"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_ASSISTANT']/source"/>
            <xsl:with-param name="Data" select="Assistant"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_LOCATION']/source"/>
            <xsl:with-param name="Data" select="Location"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_MAILSTOP']/source"/>
            <xsl:with-param name="Data" select="Mailstop"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_NETWORK']/source"/>
            <xsl:with-param name="Data" select="ComputerNetworkName"/>
          </xsl:call-template>
          <!-- Other Properties -->
          <tr class="spacer" id="other-spacer"><td colspan="2"><hr/></td></tr>
          <!-- Instant Messaging Addresses -->
          <xsl:for-each select="ImAddresses/ImAddress">
            <tr>
              <td class="label">
                <xsl:value-of select="@label"/>
              </td>
              <td class="data">
                <xsl:value-of select="text()"/>
              </td>
            </tr>
          </xsl:for-each>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_NICKNAME']/source"/>
            <xsl:with-param name="Data" select="Nickname"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_CUSTOMER_ID']/source"/>
            <xsl:with-param name="Data" select="CustomerID"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_GOVERNMENT_ID']/source"/>
            <xsl:with-param name="Data" select="GovernmentID"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_COMPANY_ID']/source"/>
            <xsl:with-param name="Data" select="OrganizationalID"/>
          </xsl:call-template>
          <xsl:call-template name="UrlToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_FTPSITE']/source"/>
            <xsl:with-param name="Url" select="FtpSite"/>
          </xsl:call-template>
          <xsl:call-template name="UrlToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_FREEBUSY']/source"/>
            <xsl:with-param name="Url" select="FreeBusyUrl"/>
          </xsl:call-template>
          <xsl:call-template name="UrlToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_TEAMING']/source"/>
            <xsl:with-param name="Url" select="TeamingUrl"/>
          </xsl:call-template>
        </table>
      </td>

      <!-- Second Column -->
      <td class="column">
        <table border="0" class="prop-table">
          <!-- Phone Numbers -->
          <xsl:for-each select="PhoneNumbers/PhoneNumber">
            <xsl:if test="string-length(text()) > 0">
              <tr>
                <td class="label">
                  <xsl:value-of select="@label"/>
                </td>
                <td class="phone">
                  <xsl:value-of select="text()"/>
                </td>
              </tr>
            </xsl:if>
          </xsl:for-each>
          <!-- Personal Properties -->
          <tr class="spacer" id="personal-spacer"><td colspan="2"><hr/></td></tr>
          <xsl:call-template name="UrlToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_WEBSITE']/source"/>
            <xsl:with-param name="Url" select="HomeWebsite"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_SPOUSE']/source"/>
            <xsl:with-param name="Data" select="Spouse"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_CHILDREN']/source"/>
            <xsl:with-param name="Data" select="Children"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_HOBBIES']/source"/>
            <xsl:with-param name="Data" select="Hobbies"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_BIRTHDAY']/source"/>
            <xsl:with-param name="Data" select="Birthday"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_ANNIVERSARY']/source"/>
            <xsl:with-param name="Data" select="WeddingAnniversary"/>
          </xsl:call-template>
          <!-- User Defined Properties -->
          <tr class="spacer" id="udf-spacer"><td colspan="2"><hr/></td></tr>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_USERFIELD1']/source"/>
            <xsl:with-param name="Data" select="UserField1"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_USERFIELD2']/source"/>
            <xsl:with-param name="Data" select="UserField2"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_USERFIELD3']/source"/>
            <xsl:with-param name="Data" select="UserField3"/>
          </xsl:call-template>
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_USERFIELD4']/source"/>
            <xsl:with-param name="Data" select="UserField4"/>
          </xsl:call-template>
          <xsl:for-each select="UserDefinedFields/UserDefined">
            <xsl:call-template name="PropertyToRow">
              <xsl:with-param name="Label" select="Name"/>
              <xsl:with-param name="Data" select="Value"/>
            </xsl:call-template>
          </xsl:for-each>
        </table>
      </td>
    </tr>
  </table>
  
  <xsl:if test="count(Categories/Category) > 0">
    <p>
      <span class="label"><xsl:value-of select="$i18n/trans-unit[@id='CONTACT_CATEGORIES']/source"/></span>:
      <xsl:for-each select="Categories/Category">
        <span xmlns="http://www.w3.org/1999/xhtml">
          <xsl:attribute name="style"><xsl:if test="string-length(@TextColor) > 0">color: <xsl:value-of select="@TextColor"/>;</xsl:if><xsl:if test="string-length(@BackColor) > 0">background: <xsl:value-of select="@BackColor"/></xsl:if></xsl:attribute>
          <xsl:value-of select="text()"/>
        </span>
        <xsl:if test="position()!=last()">, </xsl:if>
      </xsl:for-each>
    </p>
  </xsl:if>

  <xsl:if test="string-length(Comments/text())>0">
  <div xmlns="http://www.w3.org/1999/xhtml" class="Comments" >
    <div class="title">
      <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_COMMENTS']/source"/>
    </div>
    <xsl:call-template name="lf2br">
      <xsl:with-param name="StringToTransform" select="Comments"/>
    </xsl:call-template>
  </div>
</xsl:if>

</xsl:template>

</xsl:stylesheet>