﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
		xmlns:msxsl="urn:schemas-microsoft-com:xslt"
	        xmlns:user="mynamespace"
        	version="1.0">

<xsl:variable name="langfile" select="concat('def_',//@lang,'.xlf')"/>
<xsl:variable name="i18n" select="document($langfile)/xliff/file/body"/>
  
 <xsl:output method="xml" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
       doctype-public="html"/>

  <xsl:template match="/">
    <meta http-equiv="X-UA-Compatible" content="IE=8" />  
    <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
      <title>
        <xsl:value-of select="//DisplayName"/>
      </title>
      <style type="text/css">
<![CDATA[
body {
	font: 100%/1.4 Arial, Helvetica, sans-serif;
	background: #FFF;
	margin: 0;
	padding: 0;
	color: #000;
}
h1, h2, h3, h4, h5, h6, p {
	margin:0;
	padding:0 0 0 15px;
}
a img {
	border: none;
}
a:link {
	color:#3e6978;
	text-decoration: underline;
}
a:visited {
	color: #81b2bd;
	text-decoration: underline;
}
a:hover, a:active, a:focus {
	text-decoration: none;
}
.container {
	-moz-border-radius:10px;
	background:none repeat scroll 0 0 #F9F9F9;
	border:2px solid #E3EBED;
	border-radius:15px;
	margin:10px;
	padding:0;
}
.content {
	padding: 10px 0 0;
}
.clearfloat, .pane p.clearfloat {
	clear:both;
	height:0;
	font-size: 0;
	line-height: 0px;
	padding:0;
}
.pane hr {
	background:none repeat scroll 0 0 transparent;
	border:1px solid #E3EBED;
	clear:both;
	height:0;
	margin:0;
	padding:0;
}
.icon {
	background:url(abdlg:image:/SummaryPaneImageList.png) no-repeat scroll 0 0 transparent;
	height:16px;
	margin:0 5px 0 0;
	padding:0 16px 0 0;
	width:16px;
}
.icon.presence {
	background:url(abdlg:image:/SummaryPaneImageList.png) no-repeat scroll -81px 3px transparent;
}
.pane {
	-moz-border-radius:5px;
	background:none repeat scroll 0 0 #F9F9F9;
	border:2px solid #E3EBED;
	float:left;
	border-radius:5px;
	margin:10px;
	min-width:235px;
	padding:0;
}
.icon.email {
	background:url(abdlg:image:/SummaryPaneImageList.png) no-repeat scroll -96px 3px #FFFFFF;
}
.icon.chat {
	background:url(abdlg:image:/SummaryPaneImageList.png) no-repeat scroll -16px 3px #FFFFFF;
}
.icon.phone {
	background:url(abdlg:image:/SummaryPaneImageList.png) no-repeat scroll 0 3px #FFFFFF;
}
.icon.sms {
	background:url(abdlg:image:/SummaryPaneImageList.png) no-repeat scroll -32px 3px #FFFFFF;
}
.icon.address {
	background:url(abdlg:image:/SummaryPaneImageList.png) no-repeat scroll -112px 3px #FFFFFF;
}
.none .icon {
	background:none no-repeat scroll 0 0 transparent;
}
.title, .dept {
	display:block;
	font-size:0.7em;
	font-weight:normal;
	margin:2px 0 4px 22px;
}
.dept {
	font-size:0.85em;
	font-weight:bold;
}
.iconBorder {
	-moz-border-radius:4px;
	background-color:#FFFFFF;
	border:1px solid #CBD2D4;
	border-radius:4px;
	float:left;
	height:16px;
	margin:10px;
	padding:0 6px 9px;
	width:16px;
}
.iconBorder.none {
	-moz-border-radius:0; 
	-webkit-border-radius:0;
	border-radius:0;
	background-color:#FFFFFF;
	border:medium none;
	margin:5px;
	padding:0;
	width:0;
}
.pane h5 {
	float:left;
	font-size:15px;
	padding:14px 0 0;
}
.pane p {
	float:right;
	font-size:13px;
	line-height:20px;
	margin-left:3px;
	padding:14px 14px 0 0;
}
p.default {
	color:#666;
	margin-bottom:10px;
	text-align:right;
}
p.default span {
	color:#A6A6A6;
}
.thumbnail {
  float: left; 
  padding: 6px;
}
}]]>
      </style>
    </head>
    <body>
      <xsl:choose>
        <xsl:when test="//@lang[.='AR' or .='HE']">
          <xsl:attribute name="dir">rtl</xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="dir">ltr</xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>

      <div class="container">
        <div class="content">
          <xsl:apply-templates/>
        </div>
        <p class="clearfloat"></p>
      </div>
    </body>
  </html>
</xsl:template>

<xsl:template name="lf2br">
  <xsl:param name="StringToTransform"/>
  <xsl:choose>
    <xsl:when test="contains($StringToTransform,'&#13;&#10;')">
      <xsl:value-of select="substring-before($StringToTransform,'&#13;&#10;')"/>
      <br/>
      <xsl:call-template name="lf2br">
        <xsl:with-param name="StringToTransform">
          <xsl:value-of select="substring-after($StringToTransform,'&#13;&#10;')"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$StringToTransform"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>
  
  
<xsl:template name="AddressToRow">
    <xsl:param name="Label"/>
    <xsl:param name="Address"/>
    <xsl:if test="string-length($Address/Formatted/text()) > 0">
      <span><xsl:value-of select="$Label"/><xsl:text>: </xsl:text></span>
          <xsl:call-template name="lf2br">
            <xsl:with-param name="StringToTransform" select="$Address/Formatted"/>
          </xsl:call-template>
          <br/>
          <a>
            <xsl:attribute name="href">
              <xsl:value-of select="$Address/MapUrl"/>
            </xsl:attribute>
            <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_VIEW_MAP']/source"/>
          </a>
      <br/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="PropertyToRow">
    <xsl:param name="Label"/>
    <xsl:param name="Data"/>
    <xsl:if test="string-length($Data) > 0">
      <span><xsl:value-of select="$Label"/>
        <xsl:text>: </xsl:text>
      </span><xsl:value-of select="$Data"/>
      <br/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="UrlToRow">
    <xsl:param name="Label"/>
    <xsl:param name="Url"/>
    <xsl:if test="string-length($Url/text()) > 0">
      <span><xsl:value-of select="$Label"/>
        <xsl:text>: </xsl:text>
      </span>
      <a>
            <xsl:attribute name="href">
              <xsl:value-of select="$Url"/>
            </xsl:attribute>
            <xsl:value-of select="$Url"/>
          </a>
      <br/>
    </xsl:if>
  </xsl:template>  
  
<xsl:template match="contact">
  <h3>
    <xsl:if test="string-length(Photo/text())>0">
      <p class="thumbnail">
        <img class="contactphoto" alt="photo.jpg">
          <xsl:attribute name="src">
            <xsl:value-of select="Photo"/>
          </xsl:attribute>
        </img>
      </p>
    </xsl:if>
    <span class="icon presence"></span>
    <xsl:value-of select="DisplayName"/>
    <xsl:if test="string-length(Department/text()) > 0">
      <span class="dept">
        <xsl:value-of select="Department"/>
      </span>
    </xsl:if>
    <xsl:if test="string-length(Title/text()) > 0">
      <span class="title">
        <xsl:value-of select="Title"/>
      </span>
    </xsl:if>
    <xsl:if test="string-length(Company/text()) > 0">
      <span class="title">
        <a>
          <xsl:attribute name="href">
            <xsl:text>abdlg:launch:</xsl:text>/<xsl:value-of select="@book"/>/<xsl:value-of select="CompanyID"/>
          </xsl:attribute>
          <xsl:value-of select="Company"/>
        </a>
      </span>
    </xsl:if>
  </h3>
  <div class="pane">
    <xsl:if test="string-length(EmailAddresses/EmailAddress/text()) > 0">
      <div class="header">
        <div class="iconBorder">
          <span class="icon email"></span>
        </div>
        <h5>
          <xsl:value-of select="$i18n/trans-unit[@id='RESOURCE_EMAIL']/source"/>
        </h5>
        <xsl:variable name="MyDefaultEmail" select="DefaultEmail"/>
        <p class="default">
          <strong>
            <xsl:text>* </xsl:text><a>
              <xsl:attribute name="href">
                <xsl:text>mailto:</xsl:text><xsl:value-of select="DefaultEmail"/>
              </xsl:attribute>
              <xsl:value-of select="DefaultEmail"/>
            </a>
          </strong>
          <br/>
          <br/>
          <xsl:for-each select="EmailAddresses/EmailAddress">
            <xsl:if test="text() != $MyDefaultEmail">
              <a>
              <xsl:attribute name="href">
                <xsl:text>mailto:</xsl:text><xsl:value-of select="text()"/>
              </xsl:attribute>
              <xsl:value-of select="text()"/>
            </a>
            <br/>
            </xsl:if>
          </xsl:for-each>
        </p>
        <hr />
      </div>
    </xsl:if>

    <xsl:if test="string-length(PhoneNumbers/PhoneNumber/text()) > 0">
      <xsl:if test="string-length(DefaultPhone/text()) > 0">
        <div class="header">
          <div class="iconBorder">
            <span class="icon phone"></span>
          </div>
          <h5>
            <xsl:value-of select="$i18n/trans-unit[@id='RESOURCE_PHONE']/source"/>
          </h5>
          <xsl:variable name="MyDefaultPhone" select="DefaultPhone"/>
          <xsl:variable name="MyGenericPhoneLabel" select="GenericPhoneLabel"/>
          <xsl:variable name="MyDefaultPhoneLabel">
            <xsl:for-each select="PhoneNumbers/PhoneNumber">
              <xsl:if test="text() = $MyDefaultPhone">
                <xsl:if test="@label != $MyGenericPhoneLabel">
                  <xsl:if test="string-length(text()) > 0">
                    <xsl:value-of select="@label"/>:
                  </xsl:if>
                </xsl:if>
              </xsl:if>
            </xsl:for-each>
          </xsl:variable>
          <xsl:variable name="HighlightTelephoneNumbers" select="HighlightPhoneNumbers"/>

          <p class="default">
            <xsl:text>* </xsl:text>
            <xsl:value-of select="$MyDefaultPhoneLabel"/>
            <xsl:choose>
              <xsl:when test="$HighlightTelephoneNumbers = 'Yes'">
                <strong>
                  <a>
                    <xsl:attribute name="href">
                      <xsl:text>tel:</xsl:text>
                      <xsl:value-of select="DefaultPhone"/>
                    </xsl:attribute>
                    <xsl:value-of select="DefaultPhone"/>
                  </a>
                </strong>
              </xsl:when>
              <xsl:when test="$HighlightTelephoneNumbers = 'No'">
                <xsl:value-of select="DefaultPhone"/>
              </xsl:when>
            </xsl:choose>
            <br/>
            <br/>
            <xsl:for-each select="PhoneNumbers/PhoneNumber">
              <xsl:if test="text() != $MyDefaultPhone">
                <xsl:if test="string-length(text()) > 0">
                <span>
                  <xsl:value-of select="@label"/>:
                </span>
                  <xsl:choose>
                    <xsl:when test="$HighlightTelephoneNumbers = 'Yes'">
                      <a>
                        <xsl:attribute name="href">
                          <xsl:text>tel:</xsl:text>
                          <xsl:value-of select="text()"/>
                        </xsl:attribute>
                        <xsl:value-of select="text()"/>
                      </a>
                    </xsl:when>
                    <xsl:when test="$HighlightTelephoneNumbers = 'No'">
                      <xsl:value-of select="text()"/>
                    </xsl:when>
                  </xsl:choose>
                  <br/>
              </xsl:if>
              </xsl:if>
            </xsl:for-each>
          </p>
          <hr />
        </div>
      </xsl:if>
    </xsl:if>

    <xsl:if test="string-length(ImAddresses/ImAddress/text()) > 0">
      <div class="header">
        <div class="iconBorder">
          <span class="icon chat"></span>
        </div>
        <h5>
          <xsl:value-of select="$i18n/trans-unit[@id='RESOURCE_CHAT']/source"/>
        </h5>
        <xsl:variable name="MyDefaultImLabel">
          <xsl:value-of select="substring-before(DefaultIm, ':')"/>
        </xsl:variable>
        <xsl:variable name="MyDefaultImProvider">
          <xsl:value-of select="substring-after(DefaultIm, ':')"/>
        </xsl:variable>
        <p class="default">
         <xsl:text>* </xsl:text>
         <xsl:value-of select="$MyDefaultImLabel"/>
          <xsl:text>: </xsl:text>
          <strong>
            <a>
              <xsl:attribute name="href">
                <xsl:text>chat:</xsl:text><xsl:value-of select="DefaultIm"/>
              </xsl:attribute>
              <xsl:value-of select="$MyDefaultImProvider"/>
            </a>
          </strong>
          <br/>
          <br/>
          <xsl:for-each select="ImAddresses/ImAddress">
            <xsl:if test="@label != $MyDefaultImLabel">
              <span>
                <xsl:value-of select="@label"/>:
              </span>
              <a>
                <xsl:attribute name="href">
                  <xsl:text>chat:</xsl:text><xsl:value-of select="@label"/>:<xsl:value-of select="text()"/>
                </xsl:attribute>
                <xsl:value-of select="text()"/>
              </a>
              <br/>
            </xsl:if>
          </xsl:for-each>
        </p>
        <hr />
      </div>
    </xsl:if>

    <xsl:variable name="Mobile">
      <xsl:variable name="MyMobilePhoneLabel" select="MobilePhoneLabel"/>
      <xsl:for-each select="PhoneNumbers/PhoneNumber">
        <xsl:if test="@label=$MyMobilePhoneLabel">
          <xsl:if test="string-length(text()) > 0">
            <xsl:value-of select="text()"/>
          </xsl:if>
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="Car">
      <xsl:variable name="MyCarPhoneLabel" select="CarPhoneLabel"/>
      <xsl:for-each select="PhoneNumbers/PhoneNumber">
        <xsl:if test="@label=$MyCarPhoneLabel">
          <xsl:if test="string-length(text()) > 0">
            <xsl:value-of select="text()"/>
          </xsl:if>
        </xsl:if>
      </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="DefaultMobile">
      <xsl:if test="(string-length($Mobile) > 0)">
        <xsl:value-of select="$Mobile" />
      </xsl:if>
      <xsl:if test="((string-length($Mobile) = 0) and (string-length($Car) > 0))">
        <xsl:value-of select="$Car" />
      </xsl:if>
    </xsl:variable>

    <xsl:if test="string-length($DefaultMobile) > 0">
      <div class="header">
        <div class="iconBorder">
          <span class="icon sms"></span>
        </div>
        <h5>
          <xsl:value-of select="$i18n/trans-unit[@id='RESOURCE_SMS']/source"/>
        </h5>
        <p class="default">
          <xsl:text>* </xsl:text>
          <xsl:if test="$Mobile = $DefaultMobile">
            <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_PHONE_MOBILE']/source"/>
            <xsl:text> </xsl:text>
          </xsl:if>
          <xsl:if test="$Car = $DefaultMobile">
            <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_PHONE_CAR']/source"/>
            <xsl:text> </xsl:text>
          </xsl:if>
          <strong>
            <a>
              <xsl:attribute name="href">
                <xsl:text>sms:</xsl:text><xsl:value-of select="$DefaultMobile"/>
              </xsl:attribute>
              <xsl:value-of select="$DefaultMobile"/>
            </a>
          </strong>
          <br/>
          <br/>
          <xsl:if test="(string-length($Mobile) > 0) and ($Mobile != $DefaultMobile)">
            <span>
              <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_PHONE_MOBILE']/source"/>
              <xsl:text> </xsl:text>
            </span>
            <a>
              <xsl:attribute name="href">
                <xsl:text>sms:</xsl:text><xsl:value-of select="$Mobile"/>
              </xsl:attribute>
              <xsl:value-of select="$Mobile"/>
            </a>
            <br/>
          </xsl:if>
          <xsl:if test="(string-length($Car) > 0) and ($Car != $DefaultMobile)">
            <span>
              <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_PHONE_CAR']/source"/>
              <xsl:text> </xsl:text>
            </span>
            <a>
              <xsl:attribute name="href">
                <xsl:text>sms:</xsl:text><xsl:value-of select="$Car"/>
              </xsl:attribute>
              <xsl:value-of select="$Car"/>
            </a>
            <br/>
          </xsl:if>
        </p>
        <hr />
      </div>
    </xsl:if>

    <xsl:if test="string-length(PostalAddresses/PostalAddress/Formatted/text()) > 0">
      <div class="header">
        <div class="iconBorder">
          <span class="icon address"></span>
        </div>
        <h5>
          <xsl:value-of select="$i18n/trans-unit[@id='ORGANIZATION_ADDRESSES']/source"/>
        </h5>
        <p class="default">
          <xsl:text>* </xsl:text>
          <xsl:choose>
            <xsl:when test="string-length(PostalAddresses/PostalAddress[@type='office']) > 0">
              <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_OFFICE']/source"/>
              <xsl:text>: </xsl:text>
            </xsl:when>
            <xsl:when test="string-length(PostalAddresses/PostalAddress[@type='home']) > 0">
              <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_HOME']/source"/>
              <xsl:text>: </xsl:text>
            </xsl:when>
            <xsl:when test="string-length(PostalAddresses/PostalAddress[@type='other']) > 0">
              <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_OTHER']/source"/>
              <xsl:text>: </xsl:text>
            </xsl:when>
          </xsl:choose>
          <a>
            <xsl:attribute name="href">
              <xsl:value-of select="PostalAddresses/PostalAddress/MapUrl"/>
            </xsl:attribute>
            <xsl:value-of select="$i18n/trans-unit[@id='CONTACT_VIEW_MAP']/source"/>
          </a>
          <br/>
          <br/>
          <xsl:call-template name="AddressToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_OFFICE']/source"/>
            <xsl:with-param name="Address" select="PostalAddresses/PostalAddress[@type='office']"/>
          </xsl:call-template>
          <xsl:call-template name="AddressToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_HOME']/source"/>
            <xsl:with-param name="Address" select="PostalAddresses/PostalAddress[@type='home']"/>
          </xsl:call-template>
          <xsl:call-template name="AddressToRow">
            <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_OTHER']/source"/>
            <xsl:with-param name="Address" select="PostalAddresses/PostalAddress[@type='other']"/>
          </xsl:call-template>
        </p>
        <hr />
      </div>
    </xsl:if>

  <xsl:variable name="NeedMisc">
    <xsl:value-of select="OfficeWebsite"/>
    <xsl:value-of select="Department"/>
    <xsl:value-of select="Profession"/>
    <xsl:value-of select="Manager"/>
    <xsl:value-of select="Location"/>
    <xsl:value-of select="Mailstop"/>
    <xsl:value-of select="ComputerNetworkName"/>
    <xsl:value-of select="Nickname"/>
    <xsl:value-of select="CustomerID"/>
    <xsl:value-of select="GovernmentID"/>
    <xsl:value-of select="OrganizationalID"/>
    <xsl:value-of select="FtpSite"/>
    <xsl:value-of select="FreeBusyUrl"/>
    <xsl:value-of select="TeamingUrl"/>
    <xsl:value-of select="HomeWebsite"/>
    <xsl:value-of select="Spouse"/>
    <xsl:value-of select="Children"/>
    <xsl:value-of select="Hobbies"/>
    <xsl:value-of select="Birthday"/>
    <xsl:value-of select="WeddingAnniversary"/>
    <xsl:value-of select="UserField1"/>
    <xsl:value-of select="UserField2"/>
    <xsl:value-of select="UserField3"/>
    <xsl:value-of select="UserField4"/>
    <xsl:value-of select="UserDefinedFields/UserDefined/Value"/>
  </xsl:variable>

  <xsl:if test="string-length($NeedMisc) > 0">
    <div class="header">
      <div class="iconBorder">
      </div>
      <h5>
        <xsl:value-of select="$i18n/trans-unit[@id='MISCELLANEOUS']/source"/>
      </h5>
      <p class="default">
        <br/>
        <br/>
        <xsl:call-template name="UrlToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_WEBSITE']/source"/>
          <xsl:with-param name="Url" select="OfficeWebsite"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_DEPARTMENT']/source"/>
          <xsl:with-param name="Data" select="Department"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_PROFESSION']/source"/>
          <xsl:with-param name="Data" select="Profession"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_MANAGER']/source"/>
          <xsl:with-param name="Data" select="Manager"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_ASSISTANT']/source"/>
          <xsl:with-param name="Data" select="Assistant"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_LOCATION']/source"/>
          <xsl:with-param name="Data" select="Location"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_MAILSTOP']/source"/>
          <xsl:with-param name="Data" select="Mailstop"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_NETWORK']/source"/>
          <xsl:with-param name="Data" select="ComputerNetworkName"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_NICKNAME']/source"/>
          <xsl:with-param name="Data" select="Nickname"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_CUSTOMER_ID']/source"/>
          <xsl:with-param name="Data" select="CustomerID"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_GOVERNMENT_ID']/source"/>
          <xsl:with-param name="Data" select="GovernmentID"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_COMPANY_ID']/source"/>
          <xsl:with-param name="Data" select="OrganizationalID"/>
        </xsl:call-template>
        <xsl:call-template name="UrlToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_FTPSITE']/source"/>
          <xsl:with-param name="Url" select="FtpSite"/>
        </xsl:call-template>
        <xsl:call-template name="UrlToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_FREEBUSY']/source"/>
          <xsl:with-param name="Url" select="FreeBusyUrl"/>
        </xsl:call-template>
        <xsl:call-template name="UrlToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_TEAMING']/source"/>
          <xsl:with-param name="Url" select="TeamingUrl"/>
        </xsl:call-template>
        <xsl:call-template name="UrlToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_WEBSITE']/source"/>
          <xsl:with-param name="Url" select="HomeWebsite"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_SPOUSE']/source"/>
          <xsl:with-param name="Data" select="Spouse"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_CHILDREN']/source"/>
          <xsl:with-param name="Data" select="Children"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_HOBBIES']/source"/>
          <xsl:with-param name="Data" select="Hobbies"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_BIRTHDAY']/source"/>
          <xsl:with-param name="Data" select="Birthday"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_ANNIVERSARY']/source"/>
          <xsl:with-param name="Data" select="WeddingAnniversary"/>
        </xsl:call-template>
         <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_USERFIELD1']/source"/>
          <xsl:with-param name="Data" select="UserField1"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_USERFIELD2']/source"/>
          <xsl:with-param name="Data" select="UserField2"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_USERFIELD3']/source"/>
          <xsl:with-param name="Data" select="UserField3"/>
        </xsl:call-template>
        <xsl:call-template name="PropertyToRow">
          <xsl:with-param name="Label" select="$i18n/trans-unit[@id='CONTACT_USERFIELD4']/source"/>
          <xsl:with-param name="Data" select="UserField4"/>
        </xsl:call-template>
        <xsl:for-each select="UserDefinedFields/UserDefined">
          <xsl:call-template name="PropertyToRow">
            <xsl:with-param name="Label" select="Name"/>
            <xsl:with-param name="Data" select="Value"/>
          </xsl:call-template>
        </xsl:for-each>
      </p>
      <p class="clearfloat"></p>
    </div>
  </xsl:if>
  </div>

</xsl:template>




</xsl:stylesheet>