<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="/">
    <html xmlns="http://www.w3.org/1999/xhtml" >
      <head>
        <title>
          <xsl:value-of select="/itemlist/@title"/>
        </title>
        <style type="text/css">
          body, p, table, th, tr, td, ol,  ul, li, textarea, option, input, select {font-family: sans-serif;font-size: xx-small;}
          form {margin: 0px;}
          .group {color: #808080; border-bottom: 1px solid #808080; font-size: 1.2em;}
          .summary {color: #808080; margin-bottom: 5px;}
        </style>
        <base>
          <xsl:attribute name="href">
            <xsl:value-of select="concat('res://gwdta1',//@lang,'.dll/')"/>
          </xsl:attribute>
        </base>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="//@lang[.='AR' or .='HE']">
            <xsl:attribute name="dir">rtl</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="dir">ltr</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="/itemlist">
    <table xmlns="http://www.w3.org/1999/xhtml" width="100%">
      <xsl:apply-templates/>
    </table>
  </xsl:template>

  <!-- Don't display anything for the settings -->
  <xsl:template match="/itemlist/settings"/>

  <!-- Display column headers unless we are in summary mode -->
  <xsl:template match="/itemlist/columns">
    <xsl:if test="not(/itemlist/settings/detailmode) or /itemlist/settings/detailmode!='summary'">
      <tr xmlns="http://www.w3.org/1999/xhtml">
        <th>&#160;</th>
        <th>&#160;</th>
        <xsl:for-each select="column">
          <th>
            <xsl:value-of select="text()"/>
          </th>
        </xsl:for-each>
      </tr>
    </xsl:if>
  </xsl:template>

  <!-- Display group headers -->
  <xsl:template match="//group">
    <tr xmlns="http://www.w3.org/1999/xhtml">
      <td>&#160;</td>
      <td class="group">
        <xsl:attribute name="colspan">
          <xsl:value-of select="count(/itemlist/columns/column) + 1"/>
        </xsl:attribute>
        <xsl:value-of select="@label"/>
      </td>
    </tr>
  </xsl:template>
  
  <!-- Display the items -->
  <xsl:template match="//item">
    <tr xmlns="http://www.w3.org/1999/xhtml">
      <xsl:attribute name="style">
        <xsl:if test="state/category/@bgcolor">
          background: <xsl:value-of select="state/category/@bgcolor"/>;
        </xsl:if>
        <xsl:if test="state/category/@color">
          color: <xsl:value-of select="state/category/@color"/>;
        </xsl:if>
        <xsl:if test="state/unread">
          font-weight: bold;
        </xsl:if>
      </xsl:attribute>
      
      <!-- checklist column -->
      <td>
        <xsl:if test="/itemlist/settings/viewmode='tasklist'">
          <xsl:choose>
            <xsl:when test="state/tasklist">
              <form>
                <input type="checkbox">
                  <xsl:if test="state/tasklist='completed'"><xsl:attribute name="checked"/></xsl:if>
                </input>
              </form>
            </xsl:when>
            <xsl:otherwise>&#160;</xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </td>
      
      <!-- item state column -->
      <td>
        <!-- item type -->
        <xsl:choose>
          <xsl:when test="state/type='appointment'">
            <img src="png/il_type_appt.png"/>
          </xsl:when>
          <xsl:when test="state/type='task'">
            <img src="png/il_type_task.png"/>
          </xsl:when>
          <xsl:when test="state/type='note'">
            <img src="png/il_type_note.png"/>
          </xsl:when>
          <xsl:when test="state/type='phone'">
            <img src="png/il_type_phone.png"/>
          </xsl:when>
          <xsl:when test="state/type='docref'">
            <img src="png/il_type_docref.png"/>
          </xsl:when>
          <xsl:when test="state/type='contact'">
            <img src="png/il_type_contact.png"/>
          </xsl:when>
          <xsl:when test="state/type='group'">
            <img src="png/il_type_group.png"/>
          </xsl:when>
          <xsl:when test="state/type='resource'">
            <img src="png/il_type_resource.png"/>
          </xsl:when>
          <xsl:when test="state/type='organization'">
            <img src="png/il_type_organization.png"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="state/unread">
                <img src="png/il_type_mail.png"/>
              </xsl:when>
              <xsl:otherwise>
                <img src="png/il_type_mail_open.png"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>

        <!-- box type -->
        <xsl:choose>
          <xsl:when test="state/boxtype='sent'">
            <img src="png/il_boxtype_sent.png"/>
          </xsl:when>
          <xsl:when test="state/boxtype='draft'">
            <img src="png/il_boxtype_draft.png"/>
          </xsl:when>
          <xsl:when test="state/boxtype='personal'">
            <img src="png/il_boxtype_posted.png"/>
          </xsl:when>
        </xsl:choose>

        <xsl:if test="state/hasattach">
          <img src="png/il_state_attach.png"/>
        </xsl:if>
        
        <xsl:choose>
          <xsl:when test="state/replied and state/forwarded">
            <img src="png/il_state_reply_and_forward.png"/>
          </xsl:when>
          <xsl:when test="state/replied">
            <img src="png/il_state_reply.png"/>
          </xsl:when>
          <xsl:when test="state/forwarded">
            <img src="png/il_state_forward.png"/>
          </xsl:when>
        </xsl:choose>
      </td>

      <xsl:choose>
        <xsl:when test="/itemlist/settings/detailmode='summary'">
          <td>
            <xsl:for-each select="column">
              <div>
                <xsl:if test="position()>1 and count(parent::node()/state/category)=0">
                  <xsl:attribute name="class">summary</xsl:attribute>
                </xsl:if>
                <xsl:choose>
                  <xsl:when test="string-length(text())>0">
                    <xsl:value-of select="text()"/>
                  </xsl:when>
                  <xsl:otherwise>
                    &#160;
                  </xsl:otherwise>
                </xsl:choose>
              </div>
            </xsl:for-each>
          </td>
        </xsl:when>
        <xsl:otherwise>
          <xsl:for-each select="column">
            <td>
              <xsl:choose>
                <xsl:when test="string-length(text())>0">
                  <xsl:value-of select="text()"/>
                </xsl:when>
                <xsl:otherwise>
                  &#160;
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
    </tr>
  </xsl:template>
  
  </xsl:stylesheet> 
